/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.services.ServiceException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.services.JPEGTurboService;
import loci.formats.services.JPEGTurboServiceImpl;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDType;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.Timestamp;

public class NDPIReader
extends BaseTiffReader {
    private static final int MAX_SIZE = 2048;
    private static final int OFFSET_HIGH_BYTES = 65324;
    private static final int BYTE_COUNT_HIGH_BYTES = 65325;
    private static final int VERSION = 65420;
    private static final int SOURCE_LENS = 65421;
    private static final int X_POSITION = 65422;
    private static final int Y_POSITION = 65423;
    private static final int Z_POSITION = 65424;
    private static final int TISSUE_INDEX = 65425;
    private static final int MARKER_TAG = 65426;
    private static final int REFERENCE = 65427;
    private static final int MARKER_TAG_HIGH_BYTES = 65432;
    private static final int FILTER_SET_NAME = 65434;
    private static final int EXPOSURE_RATIO = 65435;
    private static final int RED_MULTIPLIER = 65436;
    private static final int GREEN_MULTIPLIER = 65437;
    private static final int BLUE_MULTIPLIER = 65438;
    private static final int THUMB_TAG_2 = 65439;
    private static final int FOCUS_POINT_REGIONS = 65440;
    private static final int CAPTURE_MODE = 65441;
    private static final int SERIAL_NUMBER = 65442;
    private static final int JPEG_QUALITY = 65444;
    private static final int REFOCUS_INTERVAL = 65445;
    private static final int FOCUS_OFFSET = 65446;
    private static final int FIRMWARE_VERSION = 65448;
    private static final int METADATA_TAG = 65449;
    private static final int LABEL_OBSCURED = 65450;
    private static final int WAVELENGTH = 65451;
    private static final int LAMP_AGE = 65453;
    private static final int EXPOSURE_TIME = 65454;
    private static final int FOCUS_TIME = 65455;
    private static final int SCAN_TIME = 65456;
    private static final int WRITE_TIME = 65457;
    private static final int FULLY_AUTO_FOCUS = 65458;
    private static final int DEFAULT_GAMMA = 65500;
    private int initializedSeries = -1;
    private int initializedPlane = -1;
    private int sizeZ = 1;
    private int pyramidHeight = 1;
    private JPEGTurboService service = new JPEGTurboServiceImpl();
    private Double magnification;
    private String serialNumber;
    private String instrumentModel;

    public NDPIReader() {
        super("Hamamatsu NDPI", new String[]{"ndpi"});
        this.domains = new String[]{"Histology"};
        this.canSeparateSeries = false;
    }

    @Override
    public int getTileRows(int no) {
        FormatTools.assertId(this.currentId, true, 1);
        int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
        return this.service.getTileRows();
    }

    @Override
    public int getTileColumns(int no) {
        FormatTools.assertId(this.currentId, true, 1);
        int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
        return this.service.getTileColumns();
    }

    @Override
    public byte[] openCompressedBytes(int no, int x, int y) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
        IFD ifd = (IFD)this.ifds.get(ifdIndex);
        if (this.useTiffParser(ifd)) {
            byte[] buf = new byte[(int)this.getCompressedByteCount(ifd, x, y)];
            return this.openCompressedBytes(no, buf, x, y);
        }
        if (this.initializedSeries != this.getCoreIndex() || this.initializedPlane != no) {
            this.resetStream(ifd);
            this.initializedSeries = this.getCoreIndex();
            this.initializedPlane = no;
        }
        return this.service.getCompressedTile(x, y);
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] openCompressedBytes(int no, byte[] buf, int x, int y) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
        IFD ifd = (IFD)this.ifds.get(ifdIndex);
        if (this.useTiffParser(ifd)) {
            try {
                try (RandomAccessInputStream s2 = new RandomAccessInputStream(this.currentId);){
                    this.tiffParser = new TiffParser(s2);
                    this.tiffParser.setUse64BitOffsets(true);
                    byte[] byArray = this.copyTile(ifd, buf, x, y);
                    return byArray;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.tiffParser.getStream().close();
            }
        }
        if (this.initializedSeries != this.getCoreIndex() || this.initializedPlane != no) {
            this.resetStream(ifd);
            this.initializedSeries = this.getCoreIndex();
            this.initializedPlane = no;
        }
        this.service.getCompressedTile(buf, x, y);
        return buf;
    }

    @Override
    public Codec getTileCodec(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
        IFD ifd = (IFD)this.ifds.get(ifdIndex);
        return ifd.getCompression().getCodec();
    }

    @Override
    public CodecOptions getTileCodecOptions(int no, int x, int y) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
        IFD ifd = (IFD)this.ifds.get(ifdIndex);
        CodecOptions options = ifd.getCompression().getCompressionCodecOptions(ifd);
        options.width = this.getOptimalTileWidth();
        options.height = this.getOptimalTileHeight();
        return options;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (!isThisType) return isThisType;
        if (!open) return isThisType;
        try (RandomAccessInputStream stream = new RandomAccessInputStream(name);){
            TiffParser parser = new TiffParser(stream);
            parser.setDoCaching(false);
            parser.setUse64BitOffsets((double)stream.length() >= Math.pow(2.0, 32.0));
            if (!parser.isValidHeader()) {
                boolean bl = false;
                return bl;
            }
            IFD ifd = parser.getFirstIFD();
            if (ifd == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = ifd.containsKey(65426) || ifd.containsKey(65449);
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("I/O exception during isThisType() evaluation.", e);
            return false;
        }
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
        if (x == 0 && y == 0 && w == 1 && h2 == 1) {
            return buf;
        }
        if (this.useTiffParser((IFD)this.ifds.get(ifdIndex))) {
            try {
                try (RandomAccessInputStream s2 = new RandomAccessInputStream(this.currentId);){
                    this.tiffParser = new TiffParser(s2);
                    this.tiffParser.setUse64BitOffsets(true);
                    this.tiffParser.setYCbCrCorrection(false);
                    byte[] byArray = this.tiffParser.getSamples((IFD)this.ifds.get(ifdIndex), buf, x, y, w, h2);
                    return byArray;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.tiffParser.getStream().close();
            }
        }
        if (this.initializedSeries != this.getCoreIndex() || this.initializedPlane != no) {
            IFD ifd = (IFD)this.ifds.get(ifdIndex);
            this.resetStream(ifd);
            this.initializedSeries = this.getCoreIndex();
            this.initializedPlane = no;
        }
        this.service.getTile(buf, x, y, w, h2);
        return buf;
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int currentSeries = this.getSeries();
        if (this.getCoreIndex() >= this.pyramidHeight) {
            return super.openThumbBytes(no);
        }
        int thumbX = this.getThumbSizeX();
        int thumbY = this.getThumbSizeY();
        int rgbCount = this.getRGBChannelCount();
        if (this.hasFlattenedResolutions()) {
            this.setSeries(this.pyramidHeight - 1);
        } else {
            this.setResolution(this.pyramidHeight - 1);
        }
        byte[] thumb = null;
        if (thumbX == this.getThumbSizeX() && thumbY == this.getThumbSizeY() && rgbCount == this.getRGBChannelCount()) {
            thumb = FormatTools.openThumbBytes(this, no);
            this.setSeries(currentSeries);
            this.setResolution(0);
        } else {
            for (int s2 = this.getSeriesCount() - 1; s2 >= 0; --s2) {
                this.setSeries(s2);
                if (thumbX != this.getThumbSizeX() || thumbY != this.getThumbSizeY() || s2 == currentSeries || rgbCount != this.getRGBChannelCount()) continue;
                thumb = FormatTools.openThumbBytes(this, no);
                break;
            }
            this.setSeries(currentSeries);
            if (thumb == null) {
                thumb = FormatTools.openThumbBytes(this, no);
            }
        }
        return thumb;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (!fileOnly) {
            this.service.close();
            this.initializedSeries = -1;
            this.initializedPlane = -1;
            this.sizeZ = 1;
            this.pyramidHeight = 1;
            this.magnification = null;
            this.serialNumber = null;
            this.instrumentModel = null;
            if (this.tiffParser != null) {
                this.tiffParser.getStream().close();
            }
        }
        super.close(fileOnly);
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        int no = 0;
        int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
        IFD ifd = (IFD)this.ifds.get(ifdIndex);
        try {
            if (this.useTiffParser(ifd)) {
                return (int)ifd.getTileWidth();
            }
            if (this.initializedSeries != this.getCoreIndex() || this.initializedPlane != no) {
                this.resetStream(ifd);
                this.initializedSeries = this.getCoreIndex();
                this.initializedPlane = no;
            }
        }
        catch (IOException | FormatException e) {
            return 1024;
        }
        return this.service.getTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        int no = 0;
        int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
        IFD ifd = (IFD)this.ifds.get(ifdIndex);
        try {
            if (this.useTiffParser(ifd)) {
                return (int)ifd.getTileLength();
            }
            if (this.initializedSeries != this.getCoreIndex() || this.initializedPlane != no) {
                this.resetStream(ifd);
                this.initializedSeries = this.getCoreIndex();
                this.initializedPlane = no;
            }
        }
        catch (IOException | FormatException e) {
            return 1024;
        }
        return this.service.getTileHeight();
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (!this.service.isLibraryLoaded()) {
            throw new IOException("JPEG service failed to load Turbo JPEG library");
        }
        RandomAccessInputStream s2 = new RandomAccessInputStream(id);
        this.use64Bit = (double)s2.length() >= Math.pow(2.0, 32.0);
        s2.close();
        super.initFile(id);
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        int captureMode;
        String metadataTag;
        int s2;
        IFD ifd;
        int i;
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getMainIFDs();
        long[] ifdOffsets = this.tiffParser.getIFDOffsets();
        for (i = 0; i < this.ifds.size(); ++i) {
            ifd = (IFD)this.ifds.get(i);
            ifd.remove(65439);
            TiffIFDEntry markerTag = (TiffIFDEntry)ifd.get(65426);
            if (markerTag != null && markerTag.getValueOffset() > this.in.length()) {
                ifd.remove(65426);
            }
            if (!this.use64Bit) continue;
            try (RandomAccessInputStream stream = new RandomAccessInputStream(this.currentId);){
                int byteCountTag;
                long[] stripByteCounts;
                int t2;
                stream.order(ifd.isLittleEndian());
                stream.seek(ifdOffsets[i]);
                int keyCount = stream.readUnsignedShort();
                int[] tag = new int[keyCount];
                long[] highOrder = new long[keyCount];
                for (t2 = 0; t2 < keyCount; ++t2) {
                    tag[t2] = stream.readUnsignedShort();
                    IFDType type = IFDType.get(stream.readUnsignedShort());
                    int valueCount = stream.readInt();
                    int nValueBytes = valueCount * type.getBytesPerElement();
                    if (nValueBytes > 4) {
                        long offset = stream.readUnsignedInt();
                        ifd.put(tag[t2], new TiffIFDEntry(tag[t2], type, valueCount, offset));
                        continue;
                    }
                    stream.skipBytes(4);
                }
                stream.skipBytes(8);
                for (t2 = 0; t2 < keyCount; ++t2) {
                    highOrder[t2] = stream.readInt();
                    if (highOrder[t2] <= 0L) continue;
                    int n = t2;
                    highOrder[n] = highOrder[n] << 32;
                    Object value = ifd.get(tag[t2]);
                    if (value instanceof TiffIFDEntry) {
                        TiffIFDEntry entry = (TiffIFDEntry)value;
                        long newOffset = entry.getValueOffset() + highOrder[t2];
                        TiffIFDEntry newEntry = new TiffIFDEntry(entry.getTag(), entry.getType(), entry.getValueCount(), newOffset);
                        ifd.put(tag[t2], newEntry);
                        continue;
                    }
                    if (!(value instanceof Number)) continue;
                    ifd.put(tag[t2], ((Number)value).longValue() + highOrder[t2]);
                }
                this.tiffParser.fillInIFD(ifd);
                long[] offsetHighBytes = ifd.getIFDLongArray(65324);
                long[] byteCountHighBytes = ifd.getIFDLongArray(65325);
                int stripOffsetTag = 273;
                long[] stripOffsets = ifd.getIFDLongArray(stripOffsetTag);
                if (stripOffsets == null) {
                    stripOffsetTag = 324;
                    stripOffsets = ifd.getIFDLongArray(stripOffsetTag);
                }
                if ((stripByteCounts = ifd.getIFDLongArray(byteCountTag = 279)) == null) {
                    byteCountTag = 325;
                    stripByteCounts = ifd.getIFDLongArray(byteCountTag);
                }
                if (stripOffsets.length <= 1 || offsetHighBytes == null) continue;
                for (int strip = 0; strip < stripOffsets.length; ++strip) {
                    int n = strip;
                    stripOffsets[n] = stripOffsets[n] + (offsetHighBytes[strip] << 32);
                    if (byteCountHighBytes == null) continue;
                    int n2 = strip;
                    stripByteCounts[n2] = stripByteCounts[n2] + (byteCountHighBytes[strip] << 32);
                }
                ifd.putIFDValue(stripOffsetTag, stripOffsets);
                ifd.putIFDValue(byteCountTag, stripByteCounts);
                continue;
            }
        }
        for (i = 1; i < this.ifds.size(); ++i) {
            boolean isPyramid;
            ifd = (IFD)this.ifds.get(i);
            if (ifd.getImageWidth() == ((IFD)this.ifds.get(0)).getImageWidth() && ifd.getImageLength() == ((IFD)this.ifds.get(0)).getImageLength()) {
                ++this.sizeZ;
                continue;
            }
            if (this.sizeZ != 1) continue;
            Object source_lens_value = ifd.getIFDValue(65421);
            if (source_lens_value != null) {
                float source_lens = ((Float)source_lens_value).floatValue();
                isPyramid = source_lens != -1.0f && source_lens != -2.0f;
            } else {
                boolean bl = isPyramid = i < this.ifds.size() - 1;
            }
            if (!isPyramid) continue;
            ++this.pyramidHeight;
        }
        int seriesCount = this.pyramidHeight + (this.ifds.size() - this.pyramidHeight * this.sizeZ);
        for (int i2 = 0; i2 < this.ifds.size(); ++i2) {
            IFD ifd2 = (IFD)this.ifds.get(i2);
            this.tiffParser.fillInIFD(ifd2);
            int[] bpp = ((IFD)this.ifds.get(i2)).getBitsPerSample();
            for (int q = 0; q < bpp.length; ++q) {
                if (bpp[q] >= 8) continue;
                bpp[q] = 8;
            }
            ((IFD)this.ifds.get(i2)).putIFDValue(258, bpp);
        }
        this.core.clear();
        for (s2 = 0; s2 < seriesCount; ++s2) {
            CoreMetadata ms = new CoreMetadata();
            if (s2 == 0) {
                ms.resolutionCount = this.pyramidHeight;
                this.core.add(ms);
                continue;
            }
            if (s2 < this.pyramidHeight) {
                this.core.add(0, ms);
                continue;
            }
            this.core.add(ms);
        }
        for (s2 = 0; s2 < this.core.size(); ++s2) {
            for (int r = 0; r < this.core.size(s2); ++r) {
                int index = this.core.flattenedIndex(s2, r);
                IFD ifd3 = (IFD)this.ifds.get(this.getIFDIndex(index, 0));
                PhotoInterp p = ifd3.getPhotometricInterpretation();
                int samples = ifd3.getSamplesPerPixel();
                CoreMetadata ms = (CoreMetadata)this.core.get(s2, r);
                ms.rgb = samples > 1 || p == PhotoInterp.RGB;
                ms.sizeX = (int)ifd3.getImageWidth();
                ms.sizeY = (int)ifd3.getImageLength();
                ms.sizeZ = index < this.pyramidHeight ? this.sizeZ : 1;
                ms.sizeT = 1;
                ms.sizeC = ms.rgb ? samples : 1;
                ms.littleEndian = ifd3.isLittleEndian();
                ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
                ms.imageCount = ms.sizeZ * ms.sizeT;
                ms.pixelType = ifd3.getPixelType();
                ms.metadataComplete = true;
                ms.interleaved = !this.useTiffParser(ifd3);
                ms.falseColor = false;
                ms.dimensionOrder = "XYCZT";
                ms.thumbnail = index != 0;
            }
        }
        IFD first = (IFD)this.ifds.get(0);
        Object source_lens_value = first.getIFDValue(65421);
        if (source_lens_value != null) {
            this.magnification = ((Float)source_lens_value).floatValue();
        }
        if ((metadataTag = first.getIFDStringValue(65449)) != null) {
            String[] entries;
            for (String entry : entries = metadataTag.split("\n")) {
                int eq = entry.indexOf(61);
                if (eq < 0) continue;
                String key = entry.substring(0, eq).trim();
                String value = entry.substring(eq + 1).trim();
                this.addGlobalMeta(key, value);
                if (key.equals("Objective.Lens.Magnificant") && this.magnification == null) {
                    this.magnification = DataTools.parseDouble(value);
                    continue;
                }
                if (key.equals("NDP.S/N")) {
                    this.serialNumber = value;
                    continue;
                }
                if (!key.equals("Product")) continue;
                this.instrumentModel = value;
            }
        }
        if ((captureMode = first.getIFDIntValue(65441)) > 6) {
            for (int r = 0; r < this.core.size(0); ++r) {
                int index = this.core.flattenedIndex(0, r);
                IFD ifd4 = (IFD)this.ifds.get(this.getIFDIndex(index, 0));
                ifd4.put(258, this.getBitsPerSample(captureMode));
                ifd4.put(277, 1);
                ifd4.put(262, PhotoInterp.BLACK_IS_ZERO);
                CoreMetadata ms = (CoreMetadata)this.core.get(0, r);
                ms.sizeC = 1;
                ms.rgb = false;
                ms.pixelType = 3;
            }
        }
        String captureModeDescription = this.getCaptureMode(captureMode);
        this.addGlobalMeta("NDP.image version", first.get(65420));
        this.addGlobalMeta("Magnification", source_lens_value);
        this.addGlobalMeta("Slide center X (nm)", first.get(65422));
        this.addGlobalMeta("Slide center Y (nm)", first.get(65423));
        this.addGlobalMeta("Slide center Z (nm)", first.get(65424));
        this.addGlobalMeta("Tissue index", first.get(65425));
        this.addGlobalMeta("Reference", first.get(65427));
        this.addGlobalMeta("Filter set name", first.get(65434));
        this.addGlobalMeta("Exposure ratio", first.get(65435));
        this.addGlobalMeta("Gain multiplier (red)", first.get(65436));
        this.addGlobalMeta("Gain multiplier (green)", first.get(65437));
        this.addGlobalMeta("Gain multiplier (blue)", first.get(65438));
        this.addGlobalMeta("Capture mode", captureModeDescription);
        this.addGlobalMeta("Scanner serial number", first.get(65442));
        this.addGlobalMeta("JPEG quality", first.get(65444));
        this.addGlobalMeta("Refocus interval (minutes)", first.get(65445));
        this.addGlobalMeta("Focus offset (nm)", first.get(65446));
        this.addGlobalMeta("Scanner firmware version", first.get(65448));
        this.addGlobalMeta("Label obscured", first.get(65450));
        this.addGlobalMeta("Emission wavelength", first.get(65451));
        this.addGlobalMeta("Lamp age (hours)", first.get(65453));
        this.addGlobalMeta("Exposure time (microseconds)", first.get(65454));
        this.addGlobalMeta("Focus time (seconds)", first.get(65455));
        this.addGlobalMeta("Scan time (seconds)", first.get(65456));
        this.addGlobalMeta("File write time (seconds)", first.get(65457));
        this.addGlobalMeta("Fully automatic focus", first.get(65458));
        this.addGlobalMeta("Default gamma correction", first.get(65500));
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setInstrumentID(instrumentID, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        if (this.instrumentModel != null) {
            store.setMicroscopeModel(this.instrumentModel, 0);
        }
        if (this.magnification != null) {
            store.setObjectiveNominalMagnification(this.magnification, 0, 0);
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            if (this.hasFlattenedResolutions() || i > 2) {
                store.setImageName("Series " + (i + 1), i);
            } else {
                switch (i) {
                    case 0: {
                        store.setImageName("", i);
                        break;
                    }
                    case 1: {
                        store.setImageName("macro image", i);
                        break;
                    }
                    case 2: {
                        store.setImageName("macro mask image", i);
                    }
                }
            }
            store.setImageInstrumentRef(instrumentID, i);
            store.setObjectiveSettingsID(objectiveID, i);
            if (i > 0) {
                int ifdIndex = this.getIFDIndex(i, 0);
                String creationDate = ((IFD)this.ifds.get(ifdIndex)).getIFDTextValue(306);
                if ((creationDate = DateTools.formatDate(creationDate, DATE_FORMATS, ".")) != null) {
                    store.setImageAcquisitionDate(new Timestamp(creationDate), i);
                }
                double xResolution = ((IFD)this.ifds.get(ifdIndex)).getXResolution();
                double yResolution = ((IFD)this.ifds.get(ifdIndex)).getYResolution();
                Length sizeX = FormatTools.getPhysicalSizeX(xResolution);
                Length sizeY = FormatTools.getPhysicalSizeY(yResolution);
                if (sizeX != null) {
                    store.setPixelsPhysicalSizeX(sizeX, i);
                }
                if (sizeY == null) continue;
                store.setPixelsPhysicalSizeY(sizeY, i);
                continue;
            }
            store.setImageDescription(this.serialNumber, i);
            for (int p = 0; p < this.getImageCount(); ++p) {
                int ifdIndex = this.getIFDIndex(i, p);
                IFD ifd = (IFD)this.ifds.get(ifdIndex);
                Number x = (Number)ifd.getIFDValue(65422);
                Number y = (Number)ifd.getIFDValue(65423);
                Number z = (Number)ifd.getIFDValue(65424);
                int[] zct = this.getZCTCoords(p);
                if (x != null || y != null || z != null) {
                    store.setPlaneTheZ(new NonNegativeInteger(zct[0]), i, p);
                    store.setPlaneTheC(new NonNegativeInteger(zct[1]), i, p);
                    store.setPlaneTheT(new NonNegativeInteger(zct[2]), i, p);
                }
                if (x != null) {
                    store.setPlanePositionX(FormatTools.getStagePosition((Double)x.doubleValue(), UNITS.NANOMETRE), i, p);
                }
                if (y != null) {
                    store.setPlanePositionY(FormatTools.getStagePosition((Double)y.doubleValue(), UNITS.NANOMETRE), i, p);
                }
                if (z != null) {
                    store.setPlanePositionZ(FormatTools.getStagePosition((Double)z.doubleValue(), UNITS.NANOMETRE), i, p);
                }
                if (zct[0] != 0 || zct[2] != 0) continue;
                String channelName = ifd.getIFDTextValue(65434);
                store.setChannelName(channelName, i, zct[1]);
                Object wave = ifd.getIFDValue(65451);
                if (wave == null || !(wave instanceof Number)) continue;
                store.setChannelEmissionWavelength(FormatTools.getEmissionWavelength(((Number)wave).doubleValue()), i, zct[1]);
            }
        }
    }

    private int getIFDIndex(int seriesIndex, int zIndex) {
        if (seriesIndex < this.pyramidHeight) {
            return zIndex * this.pyramidHeight + seriesIndex;
        }
        return this.sizeZ * this.pyramidHeight + (seriesIndex - this.pyramidHeight);
    }

    private boolean useTiffParser(IFD ifd) throws FormatException {
        return ifd.getImageWidth() <= 2048L || ifd.getImageLength() <= 2048L || ifd.getCompression() != TiffCompression.JPEG || !ifd.containsKey(65426);
    }

    private String getCaptureMode(int mode) {
        switch (mode) {
            case 0: {
                return "Brightfield";
            }
            case 1: {
                return "Fluorescence";
            }
            case 2: {
                return "Fluorescence with brightfield focusing";
            }
            case 4: {
                return "36 bit color fluorescence";
            }
            case 5: {
                return "36 bit color fluorescence with brightfield focusing";
            }
            case 6: {
                return "12 bit mono fluorescence";
            }
            case 7: {
                return "12 bit mono fluorescence with brightfield focusing";
            }
            case 13: {
                return "14 bit mono fluorescence";
            }
            case 14: {
                return "14 bit mono fluorescence with brightfield focusing";
            }
            case 16: {
                return "14 bit mono brightfield";
            }
            case 17: {
                return "16 bit mono fluorescence";
            }
            case 18: {
                return "16 bit mono fluorescence with brightfield focusing";
            }
        }
        return "unknown";
    }

    private int getBitsPerSample(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                return 8;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 12;
            }
            case 13: 
            case 14: 
            case 16: {
                return 14;
            }
            case 17: 
            case 18: {
                return 16;
            }
        }
        return -1;
    }

    private long[] getMarkers(IFD ifd) throws FormatException {
        long[] markers = ifd.getIFDLongArray(65426);
        long[] markerHighBytes = ifd.getIFDLongArray(65432);
        if (!this.use64Bit) {
            for (int i = 0; i < markers.length; ++i) {
                markers[i] = markers[i] & 0xFFFFFFFFL;
            }
        } else if (markerHighBytes != null) {
            for (int i = 0; i < markers.length; ++i) {
                if (i >= markerHighBytes.length) continue;
                markers[i] = markers[i] & 0xFFFFFFFFL;
                int n = i;
                markers[n] = markers[n] + (markerHighBytes[i] << 32);
            }
        } else {
            LOGGER.debug("Optional tag {} missing or unreadable", (Object)65432);
            for (int i = 1; i < markers.length; ++i) {
                if (markers[i] >= markers[i - 1]) continue;
                int n = i;
                markers[n] = markers[n] + (long)Math.pow(2.0, 32.0);
            }
        }
        return markers;
    }

    private void resetStream(IFD ifd) throws IOException, FormatException {
        long offset = ifd.getStripOffsets()[0];
        long byteCount = ifd.getStripByteCounts()[0];
        if (this.in != null) {
            this.in.close();
        }
        this.in = new RandomAccessInputStream(this.currentId);
        this.in.seek(offset);
        this.in.setLength(offset + byteCount);
        try {
            this.service.close();
            long[] markers = this.getMarkers(ifd);
            if (markers != null) {
                this.service.setRestartMarkers(markers);
            }
            this.service.initialize(this.in, this.getSizeX(), this.getSizeY());
        }
        catch (ServiceException e) {
            throw new FormatException(e);
        }
    }
}

