The rainSTORM software package is a comprehensive suite for processing and analysing single-molecule localisation microscopy datasets.
It was created by the Laser Analytics Group at the University of Cambridge and the Biophysics Group at NPL, and is now further developed and maintained by the Advanced Imaging Group at the University of Szeged.


# Functionalities

rainSTORM's algorithms can be called via Matlab scripts or via two graphical programs. The "rainSTORM" graphical user interface is used to process the image stacks to create localization datasets. The "Image_Viewer" GUI can then be used to analyse these datasets further.
The software package contains the components to perform common localization microscopy data processing and analysis tasks, namely:

- image stack reading and metadata extraction
- quasi-static fluorescent backround removal
- localization, i.e. identifying the spots of single molecules on the camera frames
- localization data filtering
- histograms to assess data quality
- drift correction
- astigmatic axial position determination
- super-resolved image creation
- cluster analysis with DBSCAN
- concatenation of localizations belonging to the same single molecule blinking event

The package can also import localization data files created with ThunderSTORM, besides its own data format. Implementing support for other data formats should be relatively straightforward by utilising the underlying infrastructure.

# Requirements

RainSTORM 4.x has been tested for use with MATLAB 2018a and later versions. Unfortunately, it does not work with GNU Octave, even without the GUI.

The image stack processing ("localization") requires the following Matlab toolboxes:

- Image processing toolbox
- Parallel processing toolbox (optional)

The localization data analysis and processing requires the following Matlab toolboxes:

- Optimization toolbox  (rainSTORM's cross-correlation-based drift correction)
- Statistics and Machine Learning Toolbox (cluster analysis)

For Nikon ND2 and OME-TIFF image stack support, install the [Bio-Formats MATLAB Toolbox](https://www.openmicroscopy.org/bio-formats/).
Download the latest version, then extract and copy it inside, preferably in the `lib\imageStack\externals\` folder.


# Organization of the code

Most of the functionality is organized into libraries, for greater reusability.
At the next abstraction level, rainSTORM defines "operations" for the specific data analysis steps. These functions have somewhat standardized inputs and outputs, meaning that operation functions performing the same task (e.g. image stack reading, localization) should be interchangeable.
The settings of the operations can be saved into and imported from JSON files.
The graphical programs and the batch processing scripts rely on Matlab objects, that calls the operations in their methods.
Codes specific to software packages (rainSTORM, ThunderSTORM) are placed in their separate folders.


# Usage

To call the rainSTORM graphical user interface, simply run the 'start_rainSTORM.m' Matlab file. In the interface, import the image stack(s), adjust the settings, and then process the images. The Image_Viewer can be invoked from the rainSTORM GUI after processing the data, or it can be called independently using the start_Image_Viewer.m Matlab file. It can import localization data sets (CSV files) that have been saved previously. 

As an alternative, the datasets can be processed and analysed without a GUI using the 'rainSTORM_batchProcessing' script. This approach is intended for processing large number of datasets with pre-defined settings.

For more customizable data analysis, see the "example srcipts".

Alternatively, ThunderSTORM can also be run via MIJ to process image stacks, see the "ThunderSTORM_install.md" description.

# Notes

Note for general interest that the "rain" prefix of rainSTORM is not a
particular acronynm. It is simply a name to assist file organisation. 

# Acknowledgements

If this software is helpful, then
Please consider acknowledging or referencing the following paper:

Optical Nanoscopy 2012, 1:12 

Blind assessment of localisation microscope image resolution
Eric J Rees, Miklos Erdelyi, Dorothea Pinotsi, Alex Knight, 
Daniel Metcalf and Clemens F Kaminski 

doi:10.1186/2192-2853-1-12

This paper explains the "Precision Limit" of resolution that is 
evaluated by the rainSTORM software. Referencing it will also 
acknowledge the main authors of the software.

The rainSTORM 4.x series does not yet have any publication.
