% concept:

% - one pointillistic data (localizations or trajectory) is one basic unit
% - trajectories object can be created from a localization data object, but
% it will be a new successor unit, but it will replace the localization data object
% - clusters is not a pointillistic data unit as is lacks temporal
% information, it is an "evaluation"
% - a "channel" contains severral pointillistic data that belongs together (e.g. polarization, multicolor, biplane...)
% - channels can be merged or the data splitted into several channels (e.g. ROIs of mmSTORM)
% - "reconstructions" derived from the same data, but differrent evaluatzion parameretes (e.g. filterings, simple/jittered histogram visulaization or localization/trajectory data) 
% - reconstructions are saved in their separate data files and with separate
% evaluation parameters
% -or should the recons belong to the same evaluation???
% operations int he evaluation parameters should be nested sequentially

classdef analysisClass < handle
    %UNTITLED7 Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        
        datasetName = '';
        datasetPath = '';

        operations = struct([]);
        
        imageStackData = imageStackClass.empty;
        pointillisticDatas = pointillisticDataClass.empty;
        
        actualDataIndex = 0;
        
    end
    
    methods
        
        function analysisObject = analysisClass()
            % create empty object
            
%             % path of the evaluation codes relative to the script location:
%             codePath='./';
% 
%             % adding the directories containing the required functions
%             run(fullfile(codePath, 'addSubfoldersToPath.m'));
% 
%             % path of the operation settings file relative to the script location:
%             operationSettingsPath=fullfile(codePath, 'algorithms/rainSTORM/settings');
%             % name of the operation settings file to be used:
% 
%             settingsFile='rainSTORM_defaults.json';
% 
%             % path of the camera settings file relative to the script location:
%             cameraPropertiesPath=fullfile(codePath, ['algorithms', filesep, 'rainSTORM', filesep, 'settings']);
%             % name of the camera settings file to be used:
%             cameraPropertiesFile='AdOptIm_cameras.json';
% 
%             [analysisObject.operations] = loadOperations(operationSettingsPath, settingsFile);
%             [analysisObject.operations] = loadCameraCalibration(cameraCalibrationPath, cameraCalibrationFile, analysisObject.operations);
            

        end
   
        function loadOperationSettings(analysisObject, operationSettingsFullFile)
           
            [operationSettingsPath, name, ext] = fileparts(operationSettingsFullFile);
            operationSettingsFile = [name, ext];
            operations = loadOperations(operationSettingsPath, operationSettingsFile);

            analysisObject.operations = rainSTORM_GUI_settings_extract.full(operations);
            
        end
        
        function loadCameraCalibration(analysisObject, cameraCalibrationFullFile)
           
            [cameraCalibrationPath, name, ext] = fileparts(cameraCalibrationFullFile);
            cameraCalibrationFile = [name, ext];
            analysisObject.operations = loadCameraCalibration(cameraCalibrationPath, cameraCalibrationFile, analysisObject.operations);
            
        end 
        
        function setAdditionalMagnification(analysisObject, additionalMagnification)
           
            analysisObject.operations.imageStack.creation.reading.settings.additionalMagnification = additionalMagnification;
            
        end
        
        function setCameraSignaConversionParameters(analysisObject, definedParametersStruct)
            
            analysisObject.operations.imageStack.creation.reading.settings.missingCameraSignalConversionParameterOverwrite = definedParametersStruct;
            analysisObject.operations.localizationData.creation.loading.settings.missingCameraSignalConversionParameterOverwrite = definedParametersStruct;
            
        end
        
        function imageStackImport(analysisObject, imageStackFullName, imageStackFormat)
           
            for idxData = 1:numel(analysisObject.imageStackData)
                delete(analysisObject.imageStackData(idxData));
                analysisObject.imageStackData(idxData) = [];
            end
            
            analysisObject.imageStackData = imageStackClass();
            
            [datasetName, imageStackPath] = analysisObject.imageStackData.read(analysisObject.operations, imageStackFullName, imageStackFormat);
            
            analysisObject.datasetName = datasetName;
            analysisObject.datasetPath = imageStackPath;
            
            analysisObject.updateDataNamings();
            
        end
        
        function removeBackground(analysisObject)
            
            
            stackData = analysisObject.imageStackData;
            if ismethod(stackData, 'removeBackground')
                stackData.removeBackground(analysisObject.operations)
            end
            
        end
        
        function [sumImageFigure, sumImageMatrix] = createSumImage(analysisObject, prevSF)
            
            if isempty(analysisObject.imageStackData)
                sumImageFigure = [];
                return
            elseif isempty(analysisObject.imageStackData.frameSum)
                sumImageFigure = [];
                return
            end
            
            %I do not think it needs to be an integer
            %prevSF = max(round(prevSF),0);
            
            frameSum = analysisObject.imageStackData.frameSum;
            
            dataName = analysisObject.datasetName;
            
            [sumImageFigure, sumImageMatrix] = rainSTORM_sumImage(frameSum, prevSF, dataName);
            
        end
        
        function saveSumImage(analysisObject, dataIndex, prevSF, exportPath, exportName, subfolderFlag)
            
            if isempty(prevSF)
                sharedParameters = analysisObject.pointillisticDatas(dataIndex).analysisParameters.sharedParameters;
                prevSF = 100 * sharedParameters.supResImagePixelSize_nm/sharedParameters.cameraSignalConversion.pixelSize_nm;
            end
            
            [~, sumImageMatrix] = analysisObject.createSumImage(prevSF);
            
            if isempty(sumImageMatrix)
                return
            end
            
            if isempty(exportPath)
                exportPath = analysisObject.datasetPath;
            end
            
            if isempty(exportName)
                exportName = analysisObject.datasetName;
            end
            
            if subfolderFlag
                [~, subfolderName, ~] = fileparts(exportName);
                exportPath = fullfile(exportPath, subfolderName);
            end
            
            if dataIndex> 1
                exportName = [exportName, '-', num2str(dataIndex)];
            end
            
            outputName = fullfile(exportPath, [exportName, '_sumImage.png']);
            imwrite(sumImageMatrix, outputName, 'png');
        end
        
        function localize(analysisObject)
            
            for idxData = 1:numel(analysisObject.pointillisticDatas)
                delete(analysisObject.pointillisticDatas(idxData))
                analysisObject.pointillisticDatas(idxData) = [];
            end
            
            stackData = analysisObject.imageStackData;
            if ismethod(stackData, 'localize')
                dataIndex = 1;
                [analysisObject.pointillisticDatas(dataIndex), dataType] = stackData.localize(analysisObject.operations);
                
                analysisObject.updateDataNamings();

                analysisObject.actualDataIndex = dataIndex;

            end
            
        end
        
        function filter(analysisObject, dataIndex, filteringOperation)
            
            pointillisticDataObject = analysisObject.pointillisticDatas(dataIndex);
            if ismethod(pointillisticDataObject, 'filter')
                pointillisticDataObject.filter(filteringOperation);
            end
            
        end
        
        function duplicatePointillisticData(analysisObject, dataIndex)
            
            if isempty(analysisObject)
                return;
            end
            
            dataIndex = uint16(dataIndex);
            if dataIndex < 1 || dataIndex > numel(analysisObject.pointillisticDatas)
               error('Invalid data index (%s) was given for pointillistic data duplication.', dataIndex) 
            end
            
            newData = pointillisticDataClass();
            
            % copy the properties of the handle class one-by-one:
            propertyNames = properties(newData);
            for idxProperty = 1:numel(propertyNames)
                actualProperty=propertyNames{idxProperty};
                newData.(actualProperty) = analysisObject.pointillisticDatas(dataIndex).(actualProperty);
            end
            analysisObject.pointillisticDatas(end+1) = newData;
            newDataIndex = numel(analysisObject.pointillisticDatas(end));
            
            analysisObject.updateDataNamings();
            
            analysisObject.actualDataIndex = newDataIndex;

        end
        
        function localizationDataImport(analysisObject, dataFileFullName, convention)
            % with image stack data or pointillistic data
            
            for idxData = 1:numel(analysisObject.pointillisticDatas)
                delete(analysisObject.pointillisticDatas(idxData))
                analysisObject.pointillisticDatas(idxData) = [];
            end
            
            dataIndex = 1;
            analysisObject.pointillisticDatas(dataIndex) = pointillisticDataClass();
            
            [originalDataName, originalDataPath, dataType] = analysisObject.pointillisticDatas(dataIndex).dataImport(analysisObject.operations, dataFileFullName, convention);
            analysisObject.pointillisticDatas(dataIndex).estimatePrecision();
            
            analysisObject.datasetName = originalDataName;
            analysisObject.datasetPath = originalDataPath;
            
            analysisObject.actualDataIndex = dataIndex;
            
            analysisObject.updateDataNamings();
            
        end
        
        
        function dataExport(analysisObject, dataIndex, exportPath, exportName, subfolderFlag, convention)
            
            analysisObject.updateDataNamings();
            
            dataObject = analysisObject.pointillisticDatas(dataIndex);
            
            if isempty(exportPath)
                exportPath = analysisObject.datasetPath;
            end
            
            if subfolderFlag
                if ~isempty(exportName)
                    [~, subfolderName, ~] = fileparts(exportName);
                else
                    subfolderName = analysisObject.datasetName;
                end
                exportPath = fullfile(exportPath, subfolderName);
            end
            
            if ~isfolder(exportPath)
               mkdir(exportPath) 
            end
            
            dataObject.dataExport(exportPath, exportName, convention);
            
        end
        
        function figuresExport(analysisObject, dataIndex, exportPath, exportName, subfolderFlag)
            
            pointillisticDataObject = analysisObject.pointillisticDatas(dataIndex);
            
            if isempty(exportPath)
                exportPath = analysisObject.datasetPath;
            end
            
            if subfolderFlag
                if ~isempty(exportName)
                    [~, subfolderName, ~] = fileparts(exportName);
                else
                    subfolderName = analysisObject.datasetName;
                end
                exportPath = fullfile(exportPath, subfolderName);
            end
            
            if ~isfolder(exportPath)
               mkdir(exportPath) 
            end
            
            pixelizationOperationSettings = analysisObject.operations.localizationData.processing.pixelization;
            visualizationOperationSettings = analysisObject.operations.localizationData.processing.visualization;
            pointillisticDataObject.figuresExport(pixelizationOperationSettings, visualizationOperationSettings, exportPath, exportName);
            
        end
        
        function SupResImage_accepted(analysisObject, dataIndex)
           
            dataObject = analysisObject.pointillisticDatas(dataIndex);
            
            if ismethod(dataObject, 'pixelize_accepted')
                dataObject.pixelize_accepted(analysisObject.operations);
            else
                warning()
            end
            
        end
        
        function Histograms(analysisObject, dataIndex)
            
             dataObject = analysisObject.pointillisticDatas(dataIndex);
             
             histogramsFigure = dataObject.createHistograms();
             
             figure(histogramsFigure);
             
        end
        
        function concatenate()
            
        end
        
        function clusterize()
            
        end
        
        function deleteData(analysisObject, dataIndex, dataType)
           
            switch dataType
                case 'pointillisticData'
                    if dataIndex<numel(analysisObject.imageStackData)
                        delete(analysisObject.pointillisticDatas(dataIndex));
                        analysisObject.pointillisticDatas(dataIndex) = [];
                    else
                        warning('The image stack data to be deleted does not exist');
                    end
                case 'imageStackData'
                    if dataIndex<numel(analysisObject.imageStackData)
                        delete(analysisObject.imageStackData(dataIndex));
                        analysisObject.imageStackData(dataIndex) = [];
                    else
                        warning('The image stack data to be deleted does not exist');
                    end
            end
            
            analysisObject.updateDataNamings();
            
        end
        
    end
    
    methods(Access=private)
        function updateDataNamings(analysisObject)
        % Lets name the datas this way...
            
            dataNumber = numel(analysisObject.imageStackData);
            for dataIndex = 1:dataNumber
                dataType = analysisObject.imageStackData(dataIndex).dataType;
                if dataNumber == 1
                    dataName = [analysisObject.datasetName, '-', dataType];
                else
                    dataName = [analysisObject.datasetName, '-', num2str(dataIndex), '-', dataType];
                end
                analysisObject.imageStackData(dataIndex).dataName = dataName;
            end
            
            dataNumber = numel(analysisObject.pointillisticDatas);
            for dataIndex = 1:dataNumber
                dataType = analysisObject.pointillisticDatas(dataIndex).dataType;
                if dataNumber == 1
                    dataName = [analysisObject.datasetName, '-', dataType];
                else
                    dataName = [analysisObject.datasetName, '-', num2str(dataIndex), '-', dataType];
                end
                analysisObject.pointillisticDatas(dataIndex).dataName = dataName;
            end
        end
    end
end

