classdef imageStackClass < handle
% This class reads an image stack and stores it in an object.


    properties

        dataName = ''
        
        dataType = ''
        
        operations = struct([])
        
        analysisParameters = struct([])
            
        imageStack = [];                          % image stack loaded into integer array
        backgroundStack = [];                     % the component of the stack beside the useful signal
        
        frameSum = [];                            % sum of the frames
        
        
    end
    
    % Constructor
    methods
        function stackObject=imageStackClass()
        % construct an empty object when called
        
        end
    end
    
    % functions used to get some properties of the image stack
    methods
        
        function [originalDataName, originalDataPath] = read(stackObject, operations, fullFileName, imageStackFormat)
            
            [analysisParameters, frameStack, frameStack_originalMetadata, frameStack_omeMetadata] = runOperation.creation(operations, 'imageStack', 'reading', {}, fullFileName, imageStackFormat);
            
            
            stackObject.analysisParameters = analysisParameters;
            stackObject.imageStack = frameStack;
            
            originalDataName = analysisParameters.sharedParameters.originalDataName;
            originalDataPath = analysisParameters.sharedParameters.originalDataPath;
            
            stackObject.dataName = originalDataName;
            stackObject.dataType = analysisParameters.dataType;
            
            stackObject.createSumImage();
            
        end
        
        function createSumImage(stackObject)
            
            imageStack = stackObject.imageStack;
            
            stackObject.frameSum = sum(uint32(imageStack),3);
            
        end
        
        function removeBackground(stackObject, operations)
            
            % get the background removed and the background stack
            [analysisParameters, frameStack, frameStack_background] = runOperation.processing(operations, 'backgroundRemoval', stackObject.analysisParameters, stackObject.imageStack);
    
            
            stackObject.analysisParameters = analysisParameters;
            stackObject.imageStack = frameStack;
            stackObject.backgroundStack = frameStack_background;
            
            stackObject.createSumImage();
            
        end
        
        function [localizationObject, dataType] = localize(stackObject, operations)
            
            % localize the image stack
            [analysisParameters, localizationData, ~] = runOperation.creation(operations, 'localizationData', 'localization', {stackObject.analysisParameters}, stackObject.imageStack);
            
            localizationObject = pointillisticDataClass();
            
            localizationObject.analysisParameters = analysisParameters;
            
            localizationObject.accepted = localizationData;
            
            % create an empty rejected data for later filtering
            localizationObject.rejected = pointillisticData_fieldManagement.createEmptyData(localizationObject.accepted);
            
            % TODO: proper data number (not just based on the "x_coord")
            localizationObject.filteringBooleanVect = true(size(localizationObject.accepted.x_coord));
            
            dataType = analysisParameters.dataType;
            localizationObject.dataType = dataType;
            
        end 
        
    end
end
