classdef conventionFunctions

    properties (Constant)
        
        functionLists = [...
            struct(...
            'convention', 'rainSTORM',...
            'fieldDefinitionsFunctionName', 'rainSTORM_dataConversionDefinitions',...
            'dataImportFunctionName', 'rainSTORM_dataImport',...
            'dataExportFunctionName', 'rainSTORM_dataExport'...
            ),...
            struct(...
            'convention', 'rainSTORM legacy',...
            'fieldDefinitionsFunctionName', 'rainSTORM_legacy_dataConversionDefinitions',...
            'dataImportFunctionName', 'rainSTORM_legacy_dataImport',...
            'dataExportFunctionName', 'rainSTORM_legacy_dataExport'...
            ),...
            struct(...
            'convention', 'rainSTORM scripting version',...
            'fieldDefinitionsFunctionName', 'rainSTORM_dataConversionDefinitions',...
            'dataImportFunctionName', 'rainSTORM_scriptingVersion_dataImport',...
            'dataExportFunctionName', 'rainSTORM_scriptingVersion_dataExport'...
            ),...
            struct(...
            'convention', 'ThunderSTORM',...
            'fieldDefinitionsFunctionName', 'ThunderSTORM_dataConversionDefinitions',...
            'dataImportFunctionName', 'ThunderSTORM_dataImport',...
            'dataExportFunctionName', 'ThunderSTORM_dataExport'...
            )...
        ];
    end
    
    methods (Static)

        function list = conventionList()
            %list = cellfun(@(x)x.convention, conventionFunctions.functionLists, 'UniformOutput', false);
            list = {conventionFunctions.functionLists.convention};
        end
        
        function dataImportFunction = dataImport(convention)
            functionLists = conventionFunctions.functionNames(convention);
            
            dataImportFunction = str2func(functionLists.dataImportFunctionName);
        end

        function dataExportFunction = dataExport(convention)
            functionLists = conventionFunctions.functionNames(convention);
            
            dataExportFunction = str2func(functionLists.dataExportFunctionName);
        end

        function fieldDefinitionsFunction = fieldDefinitions(convention)
            functionLists = conventionFunctions.functionNames(convention);
            
            fieldDefinitionsFunction = str2func(functionLists.fieldDefinitionsFunctionName);
        end
        
        function [algorithmFields, analysesFields] = conventionFields(convention, algorithm, analyses)
           
            fieldDefinitionsFunction = conventionFunctions.fieldDefinitions(convention);
            
            [algorithmFields_all, analysesFields_all] = fieldDefinitionsFunction();
            
            algorithmFields = struct([]);
            for idxAlgorithm = 1: numel(algorithmFields_all)
                if any(strcmp(algorithmFields_all(idxAlgorithm).name, algorithm))
                    algorithmFields = algorithmFields_all(idxAlgorithm).fields;
                end
            end
            if isempty(algorithmFields)
               warning('Could find any algorithm field definitons for the "%s" algorithm . Check whether valid algorithm name was supplyed for the given "%s" convention.', algorithm, convention) 
            end
            
            analysesFields = {};
            for idx = 1:numel(analyses)
                analysis_actual = analyses{idx};
                for idxAnalysis= 1: numel(analysesFields_all)
                    if strcmp(analysesFields_all(idxAnalysis).name, analysis_actual)
                        analysesFields{end+1} = analysesFields_all(idxAnalysis).fields;
                    end
                end
                if isempty(analysesFields_all)
                   warning('Could find any analysis field definitons for the "%s" analysis . Check whether valid algorithm name was supplyed for the given "%s" convention.', analysis_actual, convention) 
                end
            end
        end

        
        function functionLists = functionNames(convention)
            
            functionLists = struct([]);
            for idxConvention = 1:numel(conventionFunctions.functionLists)
                
                if strcmp(conventionFunctions.functionLists(idxConvention).convention, convention)
                    functionLists = conventionFunctions.functionLists(idxConvention);
                    break;
                end
                
            end
            
            if isempty(functionLists)
                error('No such convention %s', convention)
            end
            
        end

    end
end
