function [dataMatrix, headerList] = convertDataToExport(pointillisticData, convention, algorithm, analyses, cameraSignalConversion)
% Converts the localization data into the given convention.

[algorithmFields, analysesFields] = conventionFunctions.conventionFields(convention, algorithm, analyses);

fieldnameList = {};
headerList = {};
functionlist = [];


[fieldnameList, headerList, functionlist] = addFieldToExport(algorithmFields, fieldnameList, headerList, functionlist);
for idxAnalysis = 1:numel(analyses)
    [fieldnameList, headerList, functionlist] = addFieldToExport(analysesFields{idxAnalysis}, fieldnameList, headerList, functionlist);
end


columnNumber = numel(fieldnameList);
rowNumber = numel(pointillisticData.(fieldnameList{1}));
dataMatrix = zeros(rowNumber, columnNumber);
for columnIndex = 1:columnNumber
   
    actualFunction = functionlist{columnIndex};
    
    actualColumn = actualFunction(pointillisticData, cameraSignalConversion);
    
    dataMatrix(:,columnIndex) = actualColumn;
end

end

function [fieldnameList, headerList, functionlist] = addFieldToExport(definitionStruct, fieldnameList, headerList, functionlist)

    for idxField = 1:numel(definitionStruct)

        actualField = definitionStruct(idxField).fieldname;
        if sum(strcmp(fieldnameList, actualField)) && ~isempty(actualField) ~=0
            warning('The field %s to be added for export already exist. Now overwriting it. Please check the duplicate field conversion definitions.', actualField)
        else
            fieldnameList{end+1} = definitionStruct(idxField).fieldname;
            headerList{end+1} = definitionStruct(idxField).header;
            functionlist{end+1} = definitionStruct(idxField).function_backward;
        end

    end

end