function pointillisticData = convertImportedData(dataMatrix, dataHeaders, convention, algorithm, analyses, cameraSignalConversion)
% Converts the imported localization data to the "rainSTORM" data
% convention.

[algorithmFields, analysesFields] = conventionFunctions.conventionFields(convention, algorithm, analyses);

fieldnameList = {};
headerList = {};
functionlist = {};


[fieldnameList, headerList, functionlist] = addFieldToImport(algorithmFields, fieldnameList, headerList, functionlist);
for idxAnalysis = 1:numel(analyses)
    [fieldnameList, headerList, functionlist] = addFieldToImport(analysesFields{idxAnalysis}, fieldnameList, headerList, functionlist);
end


pointillisticData = table();
for fieldIndex = 1:numel(fieldnameList)
   
    actualFieldname = fieldnameList{fieldIndex};
    actualHeader = headerList{fieldIndex};
    actualFunction = functionlist{fieldIndex};
    
    if ~isempty(actualFieldname)
        
        actualData = actualFunction(dataMatrix, dataHeaders, cameraSignalConversion);
        
        pointillisticData = addvars(pointillisticData, actualData, 'NewVariableNames', {actualFieldname});
        
    end
    
end

function [fieldnameList, headerList, functionlist] = addFieldToImport(definitionStruct, fieldnameList, headerList, functionlist)

    for idxField = 1:numel(definitionStruct)

        acutalField = definitionStruct(idxField).fieldname;
        if isempty(acutalField)
            continue;
        elseif any(strcmp(fieldnameList, acutalField))
            warning(['The field \"', acutalField, '\" to be added for import already exist. Now overwriting it. Please check the duplicates in the the field conversion definitions.']);
        else
            fieldnameList{end+1} = definitionStruct(idxField).fieldname;
            headerList{end+1} = definitionStruct(idxField).header;
            functionlist{end+1} = definitionStruct(idxField).function_forward;
        end

    end

end

function [fieldnameList, headerList, functionlist] = addFieldToExport(definitionStruct, fieldnameList, headerList, functionlist)

    for idxField = 1:numel(definitionStruct)

        acutalField = definitionStruct(idxField).fieldname;
        if isempty(acutalField)
            continue;
        elseif any(stcmp(fieldnameList), acutalField)
            warning(['The field \"', acutalField, '\" to be added for import already exist. Now overwriting it. Please check the duplicates in the field conversion definitions']);
        else
            fieldnameList{end+1} = definitionStruct(idxField).fieldname;
            headerList{end+1} = definitionStruct(idxField).header;
            functionlist{end+1} = definitionStruct(idxField).function_backward;
        end

    end

end

end
