classdef getDataFieldUnits


    methods (Static)

        function [unitsList] = default(fieldNames)
            % Returns the data units of the "rainSTORM" convention, that it
            % used internally for the analyses.

            rainSTORM_data_fields = rainSTORM_dataDefinitions();
            rainSTORM_fieldnames = fieldnames(rainSTORM_data_fields);

            unitsList = cell(size(fieldNames));


            for idxField = 1:numel(fieldNames)

                actualField = fieldNames{idxField};
                if sum(strcmp(unitsList, actualField)) && ~isempty(actualField) ~=0
                    % do nothing
                elseif any(strcmp(rainSTORM_fieldnames, actualField))
                    unitsList{idxField} = rainSTORM_data_fields.(actualField).unit;
                else
                    unitsList{idxField} = '';
                end

            end

        end

        function [unitsList] = convention(fieldNames, convention, algorithm, analyses)
            % Returns the original data units chosen convention of the
            % supplied data fields.

            [algorithmFields, analysesFields] = conventionFunctions.conventionFields(convention, algorithm, analyses);

            jointFields = [algorithmFields, analysesFields{:}];
        
            % remove the definitions where the "fieldname" is empty
            jointFields = jointFields(~strcmp({jointFields.fieldname}, ''));

            fieldnames_convention = {jointFields.fieldname};

            unitsList = cell(size(fieldNames));


            for idxField = 1:numel(fieldNames)
                actualField = fieldNames{idxField};
                if any(strcmp(fieldnames_convention, actualField))
                    unitsList{idxField} = jointFields(idxField).unit;
                else
                    unitsList{idxField} = '';
                end
            end

        end


    end

end