function [correlation] = imageCrossCorrelation(image1, image2)
% This function cross-correlates two images of the same size

spectrum1=fft2(image1);

spectrum2=fft2(image2);

normalization=1/sqrt(sum(sum(spectrum1))*sum(sum(spectrum2)));

temp=conj(spectrum1).*spectrum2*normalization;

correlation_complex = ifft2(temp);

correlation=abs(fftshift(correlation_complex));


end

