classdef imageStack_driftDetermination
% These methods perform drift correction on image stack without any
% localization data.
    
    methods (Static)
        
        function drift = rollingCrossCorrelation(imageStack, settings)
            % This method goes through the image stack in a "rolling"
            % matter, froms blocks of the neighbouring frames and cross correlates them. 
            
            blockSize=settings.blockSize;
            baseline=settings.baseline;
            
            % number of blovks to be formed:
            blockN=ceil(size(imageStack, 3)/blockSize);
            % cross correlation steps:
            stepN=blockN;
            
            % reference image, created of the whole stack:
            image_ref=mean(double(imageStack-baseline), 3);
            
            % initialize variable:
            correlatedCoordinate_x=zeros(stepN, 1);
            correlatedCoordinate_y=zeros(stepN, 1);
            frameCenter=zeros(stepN, 1);
            
%             startingStackIndex_prev=startingStackIndex;
%             endingStackIndex_prev=endingStackIndex;
            

            for idxStep=1:stepN
                
                startingStackIndex=1+(idxStep-1)*blockSize;
                if idxStep<stepN
                    endingStackIndex=startingStackIndex+blockSize-1;
                elseif idxStep==stepN
                    endingStackIndex=size(imageStack, 3);
                end
                
                imageStackCut=imageStack(:,:, startingStackIndex:endingStackIndex);
                
                imageBlock=mean(double(imageStackCut-baseline), 3);
                
                correlationAmplitude=imageCrossCorrelation(image_ref, imageBlock);
                
                maxValue=max(max(correlationAmplitude));
                [I1, I2] = find(correlationAmplitude==maxValue);
                
                coordinates_x=1:size(correlationAmplitude, 1);
                data_x=correlationAmplitude(:, I2);
                peakIdx_x=I1;
                correlatedCoordinate_x(idxStep) = imageStack_driftDetermination.quadraticInterpolate(coordinates_x, data_x, peakIdx_x);
                
                coordinates_y=1:size(correlationAmplitude, 2);
                data_y=correlationAmplitude(I1, :);
                peakIdx_y=I2;
                correlatedCoordinate_y(idxStep) = imageStack_driftDetermination.quadraticInterpolate(coordinates_y, data_y, peakIdx_y);
                

                
                frameCenter(idxStep) = mean(startingStackIndex:endingStackIndex);
                
            end
            
            drift_x=correlatedCoordinate_x-correlatedCoordinate_x(1);
            drift_y=correlatedCoordinate_y-correlatedCoordinate_y(1);
            
            frames=transpose(1:size(imageStack, 3));
            drift.x_coord=interp1(frameCenter,drift_x,frames, 'pchip', 'extrap');
            drift.y_coord=interp1(frameCenter,drift_y,frames, 'pchip', 'extrap');
            
            
        end
        
        
        
        function interpolatedPosition = quadraticInterpolate(coordinates, data, peakIdx)
            
        % a maximális adatpont és a szomszédainak koordinátái:
		coord_left=coordinates(peakIdx-1);
		coord_center=coordinates(peakIdx);
		coord_right=coordinates(peakIdx+1);

		% a maximális adatpont és a szomszédainak értékei:
		value_left=data(peakIdx-1);
		value_center=data(peakIdx);
		value_right=data(peakIdx+1);

		% a csúcs pozíciója négyzetes interpolációval:
		interpolatedPosition=((value_left-value_center)*(coord_center^2-coord_right^2)+(value_right-value_center)*(coord_left^2-coord_center^2))/((value_left-value_center)*(2*coord_center-2*coord_right)+(value_right-value_center)*(2*coord_left-2*coord_center));        
            
        end
        
        
    end
end

