function cameraSettings = imageStack_getCameraSettings(omeMetadata, originalMetadata, imageExtension)

% TODO:
% - as much data should be extracted from the OME metadata as
% possible as the "description string" is not standardized
% - getting the camera model name from the OME metadata
% - getting the acquisition software name for the "description
% string", which is not standardized and the acquisition
% software (like NIS Elements) should be known


%% Read the parameters from the OME object
% hopefully setting these to 0s will work properly:
imageIndex=0;
channelIndex=0;
planeIndex=0;
instrumentIndex=0;
detectorIndex=0;


try
    metaDataStruct.detectorManufacturer=char(omeMetadata.getDetectorManufacturer(instrumentIndex, detectorIndex));
catch
    metaDataStruct.detectorManufacturer='';
end


try
    metaDataStruct.detectorModel=char(omeMetadata.getDetectorModel(instrumentIndex, detectorIndex));
catch
    metaDataStruct.detectorModel='';
end


try
    metaDataStruct.detectorSerialNumber=char(omeMetadata.getDetectorSerialNumber(instrumentIndex, detectorIndex));
catch
    metaDataStruct.detectorSerialNumber='';
end


% getting the number of frames:
try
    metaDataStruct.planeCount=uint32(omeMetadata.getPlaneCount(imageIndex));
    % alternative (should find a solution for the number conversion):
    %frameN=omeMeta.getPixelsSizeT(imageIndex); %
catch
    metaDataStruct.planeCount=uint32.empty;
end

% TODO: pixel physical size????? (should be corrected with the magnifcation)
% it works well with Nikon nd2 files (image space pixel size if returned
% and not the physical pixel size on the detektor) but does it work with
% images files saved with other software?
try
    metaDataStruct.pixelsPhysicalSizeX_nm=double(omeMetadata.getPixelsPhysicalSizeX(imageIndex).value(ome.units.UNITS.NANOMETER));
catch
    metaDataStruct.pixelsPhysicalSizeX_nm=[];
end

try
    metaDataStruct.pixelsPhysicalSizeY_nm=double(omeMetadata.getPixelsPhysicalSizeY(imageIndex).value(ome.units.UNITS.NANOMETER));
catch
    metaDataStruct.pixelsPhysicalSizeY_nm=[];
end


% getting the camera exposure time:
try
    metaDataStruct.planeExposureTime_ms=double(omeMetadata.getPlaneExposureTime(imageIndex, planeIndex).value(ome.units.UNITS.MILLISECOND));
catch
    metaDataStruct.planeExposureTime_ms=[];
end


% getting the frame interval:
if metaDataStruct.planeCount>1
    planeIndex_first=0;
    planeIndex_last=metaDataStruct.planeCount-1;
    timeStamp_first=double(omeMetadata.getPlaneDeltaT(imageIndex, planeIndex_first).value(ome.units.UNITS.MILLISECOND));
    timeStamp_last=double(omeMetadata.getPlaneDeltaT(imageIndex, planeIndex_last).value(ome.units.UNITS.MILLISECOND));
    metaDataStruct.frameInterval_ms=(timeStamp_last-timeStamp_first)/(metaDataStruct.planeCount-1);
elseif metaDataStruct.planeCount==1
    % in case of a single image, let it be:
    metaDataStruct.frameInterval_ms = NaN;
else
    error('Serious problem with the camera frame numbers.')
end


try
    metaDataStruct.channelEmissionWavelength_nm=double(omeMetadata.getChannelEmissionWavelength(imageIndex, channelIndex).value(ome.units.UNITS.NANOMETER));
catch
    metaDataStruct.channelEmissionWavelength_nm=[];
end

try
    metaDataStruct.channelExcitationWavelength_nm=double(omeMetadata.getChannelExcitationWavelength(imageIndex, channelIndex).value(ome.units.UNITS.NANOMETER));
catch
    metaDataStruct.channelExcitationWavelength_nm=[];
end


try
    metaDataStruct.detectorSettingsReadOutRate=double(omeMetadata.getDetectorSettingsReadOutRate(imageIndex,channelIndex));
catch
    metaDataStruct.detectorSettingsReadOutRate=[];
end


try
    metaDataStruct.detectorGain=double(omeMetadata.getDetectorGain(instrumentIndex, detectorIndex));
catch
    metaDataStruct.detectorGain=[];
end


try
    metaDataStruct.detectorSettingsGain=double(omeMetadata.getDetectorSettingsGain(imageIndex, channelIndex));
catch
    metaDataStruct.detectorSettingsGain=[];
end


try
    metaDataStruct.detectorAmplificationGain=double(omeMetadata.getDetectorAmplificationGain(instrumentIndex, detectorIndex));
catch
    metaDataStruct.detectorAmplificationGain=[];
end

% TODO: how can it be extracted from the OME metadata whether the detector
% had electron multiplication?
metaDataStruct.emMultiplication=false;


%%
% Extract the remaining 
switch imageExtension
    case {'.tif', '.tiff', '.ome.tiff'}
        try
            descriptionString=char(omeMetadata.getImageDescription(imageIndex));
            
            % extract the values from the description string saved by Nikon Nis
            % viewer:
            metaDataStruct=extractNikonDescriptionString(descriptionString, metaDataStruct);
        catch
            % do nothing
        end
    case '.nd2'
        if isa(originalMetadata, 'java.util.Hashtable')
            % when the metadata was extracted using the "bfopen"
            % function:
            descriptionString=originalMetadata.get('Global sSpecSettings');
            
            if isempty(descriptionString)
                % when the metadata was extracted using the "bfGetReader"
                % function and the "getGlobalMetadata" method of the
                % returned object:
                descriptionString=originalMetadata.get('sSpecSettings');
            end
            
            if isempty(descriptionString)
               error('The image descripting string is missing from the Nikon ND2 file.'); 
            end
           
        else
            error('Invalid object type was given to the "originalMetadata".')
        end
        
        % remove the "carriage return character", who thought it is a good
        % idea to use them....
        descriptionString=strrep(descriptionString, char(13), newline);
        
        % extract the values from the description string saved by Nikon Nis
        % viewer:
        metaDataStruct=extractNikonDescriptionString(descriptionString, metaDataStruct);
        
        % set the description string in the OME metadata object:
        omeMetadata.setImageDescription(descriptionString, imageIndex);
    otherwise
        error('Unimplemented acquisition software.')
end
%%

% TODO:check whether it is needed:
% if isnan(frameInterval_ms)
%    frameInterval_ms=exposureTime_ms;
% end

%% Fill the camera parameters

cameraSettings.manufacturer=metaDataStruct.detectorManufacturer;
cameraSettings.model=metaDataStruct.detectorModel;
cameraSettings.serialNumber=metaDataStruct.detectorSerialNumber;
cameraSettings.settings.readOutRate=metaDataStruct.detectorSettingsReadOutRate;
cameraSettings.settings.conversionGain=double(metaDataStruct.detectorGain);
cameraSettings.settings.amplificationGain=double(metaDataStruct.detectorAmplificationGain);
cameraSettings.settings.emMultiplication=logical(metaDataStruct.emMultiplication);
cameraSettings.exposureTime_ms=double(metaDataStruct.planeExposureTime_ms);
cameraSettings.frameInterval_ms=double(metaDataStruct.frameInterval_ms);
% TODO: camera binnig
cameraSettings.pixelSize_nm=double(metaDataStruct.pixelsPhysicalSizeX_nm);
cameraSettings.emissionWavelength_nm=double(metaDataStruct.channelEmissionWavelength_nm);

% Note:
% "cameraSettings.settings" is used by camera settings identification when
% determining the photon/count conversion, do not change ot add fields to
% it

end


function metaDataStruct=extractNikonDescriptionString(descriptionString, metaDataStruct)

descriptionStruct=convertDescriptionString(descriptionString);


%% Read the remaining parameters from the info structure

% when reading the exposure time from a OME metadata it gives x1000 the correct value:
if isfield(descriptionStruct, 'Exposure')
    exposure_temp=strsplit(descriptionStruct.Exposure);
    metaDataStruct.planeExposureTime = str2double(exposure_temp{1});
    %TODO: unit conversion: ms
end


% The "serial number" of the detector is written in the "detector model"
% property of the OME metadata extracted from Nikon ND2, fuck it....
detectorModel = '';
cameraName = '';
if isfield(metaDataStruct, 'detectorModel')
    detectorModel=metaDataStruct.detectorModel;
end
if isfield(descriptionStruct, 'Camera_Name')
    cameraName = descriptionStruct.Camera_Name;
end
if ~isempty(detectorModel)
    % in case of ND2 files saved with with Nikon NIS Elements.... 
    metaDataStruct.detectorSerialNumber=detectorModel;
elseif ~isempty(cameraName)
    % in case of TIFF files saved with with Nikon NIS Elements.... 
    cameraName_split = strsplit(cameraName);
    metaDataStruct.detectorSerialNumber = cameraName_split{end};
else
    warning('Could extract "serial number" property from the image stack metadata.')
end

% fuck you Nikon!!!!! 
% in the nd2 files produced with SZTE AdOptIm's NIS Elements the serial
% number and the detector model are swapped in the OME metadata (later is
% also empty there...) 
metaDataStruct.detectorSerialNumber=metaDataStruct.detectorModel;

% TODO: the validity of this approach should be checked
if isfield(descriptionStruct, 'Camera_Type')
    cameraTypeString = strsplit(descriptionStruct.Camera_Type);
    metaDataStruct.detectorManufacturer=cameraTypeString{1};
    metaDataStruct.detectorModel=cameraTypeString{2};
end


if isfield(descriptionStruct, 'Readout_Speed')
    % the iXon camera has "Readout Speed"
    metaDataStruct.detectorSettingsReadOutRate = descriptionStruct.Readout_Speed;
elseif isfield(descriptionStruct, 'Readout_Rate')
    % the Zyla camera has "Readout Rate" 
    metaDataStruct.detectorSettingsReadOutRate = descriptionStruct.Readout_Rate;
else
    warning('Could extract "readout rate" property from the image stack metadata.')
end

if isfield(descriptionStruct, 'Multiplier')
    if strcmp(descriptionStruct.Multiplier, 'Off')
        metaDataStruct.emMultiplication=false;
        metaDataStruct.detectorAmplificationGain = [];
    else
        metaDataStruct.emMultiplication=true;
        metaDataStruct.detectorAmplificationGain = str2double(descriptionStruct.Multiplier);
    end
else
    % the Zyla camera has no "Multiplier" field
    metaDataStruct.emMultiplication=false;
    metaDataStruct.detectorAmplificationGain = [];
    % TODO: check whether the this filed with the empty string is required
    % at all, or should not be defined in this case
end

if isfield(descriptionStruct, 'Binnig')
    metaDataStruct.detectorBinnig = uint8(str2double(descriptionStruct.Binnig));
end

if isfield(descriptionStruct, 'Conversion_Gain')
    %metaDataStruct.detectorGain = str2double(strrep(descriptionStruct.Conversion_Gain, 'x', ''));
    metaDataStruct.detectorGain = str2double(descriptionStruct.Conversion_Gain(isstrprop(descriptionStruct.Conversion_Gain, 'digit')));
end


end


function descriptionStruct=convertDescriptionString(descriptionString)

%% Convert the info string into a structure:
% split the info string into a cella rray containing lines:
infoString_params=splitlines(descriptionString);

% remove leading and trailing whitespace from string lines:
infoString_params = strtrim(infoString_params);

% remove the empty lines
infoString_params(cellfun('isempty', infoString_params))=[];

paramsN=numel(infoString_params);

descriptionStruct=struct();
for idxParam=1:paramsN
    if ~isempty(infoString_params{idxParam})
        splittedParam=strsplit(infoString_params{idxParam}, ': ');
        if numel(splittedParam)==2
            paramName=splittedParam{1};
            paramsString=splittedParam{2};

            % replace the special characters in the parameter name with another character:
            paramName=regexprep(paramName, '\W', '_');

            descriptionStruct.(paramName)=paramsString;
        elseif numel(splittedParam)==1
            paramName=splittedParam{1};
            
            % remove the ':' from tha name as the string splitting was not
            % performed:
            paramName=strrep(paramName, ':', '');
            
            % replace the special characters in the parameter name with another character:
            paramName=regexprep(paramName, '\W', '_');

            descriptionStruct.(paramName)='';
        else
           warning('Some problem with the image stack parameters reading.') 
        end
    else
        % do nothing
    end
end
% TODO: check whether it works for tiff files saved with NIS Elements

            % alternative solution would be if the infoString_params could
            % be slitted further into paramsNx2 size cell array:
%             paramNames=cat(1, infoString_params(:, 1));
%             paramsStrings=cat(1, infoString_params(:, 2));
%             
%             imInfo=cell2struct(paramNames, paramsStrings, 1);

end



function temp()
% infók az OME metaadat object-ről

    % source: https://docs.openmicroscopy.org/bio-formats/latest/developers/matlab-dev.html#retrieving-metadata

            % getting the OME metadata without loading the whole file:
            reader = bfGetReader('path/to/data/file');
            omeMeta = reader.getMetadataStore();
            
            omeMeta = BioFormatsData{1, 4};
            
            % for converting the XML data to plain text):
            omeXML = char(omeMeta.dumpXML());
            

            % üres Nikon NIS Elements-sel kimentett fájlok esetén:
            
            omeMeta.getDetectorSettingsZoom(imageIndex, channelIndex)
            omeMeta.getObjectiveNominalMagnification(instrumentIndex, objectiveIndex)
            omeMeta.getObjectiveCalibratedMagnification(instrumentIndex, objectiveIndex)
            omeMeta.getDetectorSettingsBinning(imageIndex, channelIndex)
            omeMeta.getMicroscopeManufacturer(instrumentIndex)
            omeMeta.getPixelsTimeIncrement(imageIndex)
            
            
        software=BioFormatsData{2}.get('Global m_SWNameString');
        %m_SWNameString = NIS-Elements AR

end

% Two kind of metadata is returned , the OME metadata (data{4}), and the
% original metadata (data{2})

% the pixze
%data{1,4}.getPixelsPhysicalSizeX(0).value()
% theunit of pixel size, micrometer
%data{1,4}.getPixelsPhysicalSizeX(0).unit().getSymbol()
%getPixelsPhysicalSizeX(0).value(ome.units.UNITS.MICROMETER); % in µm


%https://docs.openmicroscopy.org/bio-formats/6.4.0/developers/matlab-dev.html

%To convert the OME metadata into a string, use the dumpXML() method:
%omeXML = char(omeMeta.dumpXML());
%https://javadoc.io/static/org.openmicroscopy/ome-xml/6.0.1/ome/xml/meta/MetadataRetrieve.html#

% the cropped ROI bounds:
% data{2}.get('Global Top')
% data{2}.get('Global Bottom')
% data{2}.get('Global Right')
% data{2}.get('Global Left')

% % Query some metadata fields (keys are format-dependent)
% metadata = data{1, 2};
% subject = metadata.get('Subject');
% title = metadata.get('Title');
%
% metadataKeys = metadata.keySet().iterator();
% for i=1:metadata.size()
%   key = metadataKeys.nextElement();
%   value = metadata.get(key);
%   fprintf('%s = %s\n', key, value)
% end

% Remarks on the Nikon files:
% the Nikon ND2 stack's OME metadata imageDescription tag exist but does not contain any meaningful element.
% the Nikon ND2 stack's original metadata (data{4}) store more information than the OME metadata {data{4}}
% the Nikon tiff files do contain non-empty imageDescription tag
% the Nikon tiff files do contain as much metadata as the ND2 files (e.g. the cropped ROI bounds**)
% the tiff files original metadata (data{2}) does not store any information(???)

% ** they are stored in a twisted form in some tag e.g.:"bounding-rectangle="-178.000000,-152.000000", instead of 178 (top) and 360 (right)
% This information is outside of the OME metadata and I dont think it can
% be extracted with the other metadata (data{2}) either
