classdef imageStack_manipulation
    
    methods (Static)
        
        
        
        function imageStack = crop(imageStack, xBounds, yBounds, zBounds)
            % TODO!!!!
            % This function crops a frame stack into a smaller one. The cropping region
            % has to given in a 3*2 sized array where the first dimension corresponds
            % to the "x", "y" and "frame index" coordinates and the second dimension
            % corresponds to the lower and upper cropping bounds.
            
            if xBounds(1)>xBounds(2)
                temp=xBounds(1);
                xBounds(1)=xBounds(2);
                xBounds(2)=temp;
            end
            if xBounds(1)<1 
                xBounds(1) = 1;
            end
            if xBounds(2)>size(imageStack,1) 
                xBounds(2) = size(imageStack,1);
            end
            
            if yBounds(1)>yBounds(2)
                temp=yBounds(1);
                yBounds(1)=yBounds(2);
                yBounds(2)=temp;
            end
            if yBounds(1)<1 
                yBounds(1) = 1;
            end
            if yBounds(2)>size(imageStack,2) 
                yBounds(2) = size(imageStack,2) ;
            end
            
            if zBounds(1)>zBounds(2)
                temp=zBounds(1);
                zBounds(1)=zBounds(2);
                zBounds(2)=temp;
            end
            if zBounds(1)<1 
                zBounds(1) = 1;
            end
            if zBounds(2)>size(imageStack,3) 
                zBounds(2) = size(imageStack,3);
            end
            
            imageStack=imageStack(...
                xBounds(1):xBounds(2),...
                yBounds(1):yBounds(2),...
                zBounds(1):zBounds(2));
            
        end
        
        
        function imageStack = reftectVertically(imageStack)
            
            check dimensions!!!
            imageStack(:, :, :)=imageStack(:, end:-1:1, :);
            
        end
        
        function imageStack = reflectHorizontally(imageStack)
            
            check dimensions!!!
            imageStack(:, :, :)=imageStack(end:-1:1, :, :);
            
        end
        
        
        % TODO: methods for rotating or reflecting (flipping) the image stack would
        % also be useful.
        
        
        
        
    end
    
    
    
    methods
        
        function bound=checkBounds(imageStackSize, bound, dimension)
            
            if isempty(bound)
                
                
            end
        end
        
        
        
    end
    
    
end