function [filteredStack, backgroundStack, kernelRange] = movingGaussianAverageFilter(imageStack, GaussianFWHM, baseline)
% Moving average filter with Gaussian weighting
% TODO: simplify it similarly to the "movingMedianFilter".

    frameN=size(imageStack, 3);

    frameStackClass=class(imageStack);
    frameStackClassFunctionHandle=str2func(frameStackClass);

    % determine the range of the kernel by the ration of the area under the
    % Gaussian within and outside of the kernel:
    areaRatio=0.999;
    kernelMinimalDiameter=GaussianRange.integral_2D_criterion(GaussianFWHM, areaRatio);

    kernelSupport=ceil(kernelMinimalDiameter);
    if mod(kernelSupport, 2)==0
        kernelSupport=kernelSupport+1;
    end
    kernelRange=floor(kernelSupport/2);


    dataPointCoord=-kernelRange:1:kernelRange;
    kernelFunctionParameters.size.value=GaussianFWHM;
    samplingType='integral over pixels';
    binCenter=0;
    binSize=1;
    GaussianKernel_vect=kernelFunction_1D.Gaussian(dataPointCoord, kernelFunctionParameters, samplingType, binCenter, binSize);

    GaussianKernel_vect_temp(1,1,:)=GaussianKernel_vect(:);

    pixelN_x=size(imageStack, 1);
    pixelN_y=size(imageStack, 2);

    GaussianKernel=repmat(GaussianKernel_vect_temp, pixelN_x, pixelN_y, 1);
    % normalize the kernel function:
    GaussianKernel=GaussianKernel./sum(GaussianKernel, 3);

    backgroundStack=zeros(size(imageStack), frameStackClass);

    for idxFrame=1:kernelRange

        GaussianKernel_cropped=GaussianKernel(:,:,kernelRange+2-idxFrame:kernelSupport);

        GaussianKernel_cropped=GaussianKernel_cropped./sum(GaussianKernel_cropped, 3);

        stack_cropped=double(imageStack(:,:,1:idxFrame+kernelRange));

        backgroundStack(:,:,idxFrame)=frameStackClassFunctionHandle(sum(stack_cropped.*GaussianKernel_cropped, 3));

    end


    for idxFrame=kernelRange+1:frameN-kernelRange

        stack_cropped=double(imageStack(:,:,idxFrame-kernelRange:idxFrame+kernelRange));

        backgroundStack(:,:,idxFrame)=frameStackClassFunctionHandle(sum(stack_cropped.*GaussianKernel, 3));

    end


    for idxFrame=frameN-kernelRange+1:frameN

        GaussianKernel_cropped=GaussianKernel(:,:,1:frameN-idxFrame+kernelRange+1);

        GaussianKernel_cropped=GaussianKernel_cropped./sum(GaussianKernel_cropped, 3);

        stack_cropped=double(imageStack(:,:,idxFrame-kernelRange:end));

        backgroundStack(:,:,idxFrame)=frameStackClassFunctionHandle(sum(stack_cropped.*GaussianKernel_cropped, 3));

    end
    
    filteredStack=imageStack-(backgroundStack-frameStackClassFunctionHandle(baseline));

end

