function [filteredStack, backgroundStack] = movingMedianFilter(imageStack, frameRange, baseline)
% Simple moving median filter

    frameN=size(imageStack, 3);

    frameStackClass=class(imageStack);
    frameStackClassFunctionHandle=str2func(frameStackClass);

    backgroundStack=zeros(size(imageStack), frameStackClass);


    for idxFrame=1:frameN

        frameIndex_min = max(idxFrame-frameRange, 1);
        frameIndex_max = min(idxFrame+frameRange, frameN);

        stack_cropped=double(imageStack(:,:,frameIndex_min:frameIndex_max));

        backgroundStack(:,:,idxFrame)=frameStackClassFunctionHandle(median(stack_cropped, 3));

    end

    filteredStack=imageStack-(backgroundStack-frameStackClassFunctionHandle(baseline));

end

