classdef readImageMetadata
    
    
    methods(Static)
       
        function  [omeMeta, descriptionString]=OME_TIFF(BioFormatsData)
            
            % old way:
            %imInfo = imfinfo(imageFileName);
            %metadata.metadataString=imInfo.ImageDescription;
            
            omeMeta=BioFormatsData{4};
            
            imageIndex=0;
            descriptionString_javaString=omeMeta.getImageDescription(imageIndex);
            
            % convert the java string to Matlab character array:
            % source:https://stackoverflow.com/questions/2492646/matlab-dealing-with-java-lang-string
            descriptionString=char(descriptionString_javaString);
            % not working alternative:
            %descriptionString=descriptionString_javaString.toCharArray();
            
        end
        
        function  [omeMeta, descriptionString]=Nikon_ND2(BioFormatsData)
            
            omeMeta=BioFormatsData{4};
            descriptionString=BioFormatsData{2}.get('Global sSpecSettings');
            
            % TODO:
            % source: https://docs.openmicroscopy.org/bio-formats/6.6.0/developers/matlab-dev.html#retrieving-metadata
            omeMeta.setImageDescription(descriptionString, 0)
            
            plane = zeros(64, 64, 1, 2, 2, 'uint8');
            metadata = createMinimalOMEXMLMetadata(plane);
            
        end
        
        
    end
end

