classdef GaussianRange
% This class contains methods with witch it den be deermined how large
% shall chosen for the Gaussian function to fulfill some criterions, like
% the maximal value or the function area outside the range.
    
    
    methods (Static)
        function diameter = value_criterion(FWHM, peakRatio)
            % This function returns the diameter of range within the
            % Gaussian function is larger than the given peak ration.
            
            if peakRatio>0 && peakRatio<1
                % do nothing
            else
                error('Wrong value was given for the Gaussian value drop criterion.')
            end
            
            % convert the FWHM to STD:
            sigma=FWHM/(2*sqrt(2*log(2)));
            % the range within th condition is fulfilled:
            range=sqrt(-2*sigma^2*log(peakRatio));
            
            % diameters of the range:
            diameter=2*range;
        end
        
        function diameter = integral_2D_criterion(FWHM, areaRatio)
            % This function returns the diameter of range within the
            % area under the normalized 2D Gaussian function does not reach
            % the given value.
            
            if areaRatio>0 && areaRatio<1
                % do nothing
            else
                error('Wrong value was given for the within range Gaussian area ratio criterion.')
            end
            
            % the condition is very similar to the "value criterion":
            diameter=GaussianRange.value_criterion(FWHM, 1-areaRatio);
        end
    end
end

