classdef optimizationFunctionals
    % These methods return the values of the selected functional that
    % should be optimized (minimized) with the given localization
    % algorithm.
    
    
    methods (Static)
        function MSE = meanSquaredError(sampledFunction, measuredValues, minimizationFlag)
            % This function return the mean squared error
            
            % mean squared error:
            MSE = sum((sampledFunction-measuredValues).^2)/numel(measuredValues);      % mean squared error as the residue
            
            if minimizationFlag
               % do nothing, minimize it with the minimization algorithms
            else
                % if someoone wants to maximize it for some reason with the
                % minimization algorithms
                MSE=-1*MSE;
            end
        end
        
        function likelihood=likelihood_Poisson(sampledFunction, measuredValues, minimizationFlag)
            % TODO
        end
        
    end
end

