classdef trigonometricFunctions
% This function holds definitions related to various trigonometric
% functions.
    
    
    methods(Static)

        function [sampledFunction] = sin(coordinates, functionParameters, modelSettings)
            % This function holds the definition of a sin function.
            
            background=functionParameters.background;
            amplitude=functionParameters.amplitude;
            k=2*pi/functionParameters.periodicity;
            translation=functionParameters.translation;
            
            sampledFunction=background+amplitude*sin(k*(coordinates-translation));
        end

        %TODO: define other trigonometric functions when needed.
        
        
    end
end