classdef pointillisticData_pixelization
    %UNTITLED2 Summary of this class goes here
    %   Detailed explanation goes here
    
    methods (Static)
        
        function  [imageMatrix, pixelCenters] = getImageMatrixfromBinerizedIndices(pointillisticData, indicesCell, xBounds, yBounds, kernelSettings, acquisitionParameters)
            % This function calculates the image matrix from a pre
            % calculated indices cell that contains the data indices
            % belongng to each pixel.
            
            % TODO: this function is not checked nor well overthought
            
            kernelSettings.functionParameters.size=unitConversion.convert2DVectorQuantity(kernelSettings.functionParameters.size, 'camera pixel length', acquisitionParameters);
            
            % initialize the matrix of the image
            N_x=size(indicesCell,1);
            N_y=size(indicesCell,2);
            imageMatrix=uint16(zeros(N_x, N_y));
            % go through the pixels and calculate the desired quantity
            for idx_x=1:N_x
                for idx_y=1:N_y
                    binCenter.x=(xBounds(idx_x, 1)+xBounds(idx_x, 2))/2;
                    binCenter.y=(yBounds(idx_y, 1)+yBounds(idx_y, 2))/2;
                    binSize.x=abs(xBounds(idx_x, 1)-xBounds(idx_x, 2));
                    binSize.y=abs(yBounds(idx_y, 1)-yBounds(idx_y, 2));
                    
                    % indices of data falling within the currect pixel's
                    % affected region:
                    originalDataIndices_xyCut=indicesCell{idx_x, idx_y};
                    
                    % cut tha data points affected by the kernelized pixel:
                    [dataCoords, dataValues]=pointillisticData_kernelOnImagePixels.cutPointillisticData(pointillisticData, originalDataIndices_xyCut, kernelSettings.dataFieldName);
                    
                    % get the pixel value of the data points with kernel function applied on them for the image matrix:
                    operationHandle=str2func(kernelSettings.operationName);
                    imageMatrix(idx_x, idx_y)=operationHandle(dataCoords, dataValues, kernelSettings, binCenter, binSize);
                end
            end
            
            % return the centers of the pixels too:
            pixelCenters.x=(xBounds(:, 1)+xBounds(:, 2))/2;
            pixelCenters.y=(yBounds(:, 1)+yBounds(:, 2))/2;
            pixelCenters.unit='camera pixel length';
            
        end
        
        
        function [indicesCell, xBounds, yBounds] = pixelizeViaThresholding(pointillisticData, ROI_bounds, pixelSize, kernelSupportSize, samplingType, acquisitionParameters)
            % This function sorts the pointillistic data into cell array
            % (indices of the data points only) from whose elements image
            % pixels can easily be derived. It applies simple filtering on
            % the coordinates to achive the pixelization. It should have
            % the performance of the legacy rainSTORM algorithm, although
            % with some effort more efficient elgorithm could be developed
            % (it is unnecessary to perform the filtering on data points
            % that are already assigned to a pixel).
            
            ROI_bounds=unitConversion.convert2DVectorQuantity(ROI_bounds, 'camera pixel length', acquisitionParameters);
            pixelSize=unitConversion.convert2DVectorQuantity(pixelSize, 'camera pixel length', acquisitionParameters);
            kernelSupportSize=unitConversion.convert2DVectorQuantity(kernelSupportSize, 'camera pixel length', acquisitionParameters);
            
            [xBounds, yBounds]=kernelAffectedRegions.getRegionBounds_2D(ROI_bounds, pixelSize, kernelSupportSize, samplingType);

            % number of image pixels in the rows and columns
            N_x=size(xBounds, 1);
            N_y=size(yBounds, 1);
            
            % pointillistic data used for pixelization
            dataToPixelize.x_coord=pointillisticData.x_coord;
            dataToPixelize.y_coord=pointillisticData.y_coord;
            dataToPixelize.idx=1:numel(dataToPixelize.x_coord);
            
            % go through the pixels of the image
            indicesCell=cell(N_x, N_y);
            for idx_x=1:N_x
                
                
                % apply the filtering on the pointillistic data
                filterStructureX.x_coord=xBounds(idx_x, :);
                filteredDataX=pointillisticData_filtering.threshold(dataToPixelize, filterStructureX);
                
                for idx_y=1:N_y
                    
                    
                    % apply the filtering on the pointillistic data
                    filterStructureY.y_coord=yBounds(idx_y, :);
                    filteredDataXY=pointillisticData_filtering.threshold(filteredDataX, filterStructureY);
                    
                    % add the data indices to the right cell of the array 
                    indicesCell{idx_x, idx_y}=filteredDataXY.idx;
                end
            end
        end
        
        
        function [indicesCell, xBounds_xSorted, yBounds_ySorted] = pixelizeViaSorting(pointillisticData, ROI_bounds, pixelSize, kernelSupportSize, samplingType, acquisitionParameters)

            % This function sorts the pointillistic data into cell array
            % (indices of the data points only) from whose elements image
            % pixels can easily be derived. It applies simple filtering on
            % the coordinates to achive the pixelization. It should have
            % the performance of the legacy rainSTORM algorithm, although
            % with some effort more efficient algorithm could be developed
            % (it is unnecessary to perform the filtering on data points
            % that are already assigned to a pixel).
            
            ROI_bounds=unitConversion.convert2DVectorQuantity(ROI_bounds, 'camera pixel length', acquisitionParameters);
            pixelSize=unitConversion.convert2DVectorQuantity(pixelSize, 'camera pixel length', acquisitionParameters);
            kernelSupportSize=unitConversion.convert2DVectorQuantity(kernelSupportSize, 'camera pixel length', acquisitionParameters);
            
            % get the pixel bounds on sorted order
            [xBounds_xSorted, yBounds_ySorted]=kernelAffectedRegions.getRegionBounds_2D(ROI_bounds, pixelSize, kernelSupportSize, samplingType);

            % number of image pixels in the rows and columns
            N_x=size(xBounds_xSorted, 1);
            N_y=size(yBounds_ySorted, 1);
            
            % go through the pixels of the image
            indicesCell=cell(N_x, N_y);
            
            % sorting the "x" coordinates:
            [sortedData_x, sortingOrder_x]=sort(pointillisticData.x_coord);

            % sorting the "y" coordinates after sorting them in "x"
            % ascending order:
            y_coord_xSorted=pointillisticData.y_coord(sortingOrder_x);
            [sortedData_y, sortingOrder_y]=sort(y_coord_xSorted);

            lowerIndex_starting = 1;
            indexRanges_xSorted = sortedPointillisticData_divide.slideBoundaryIndex(sortedData_x, xBounds_xSorted, lowerIndex_starting);
            indexRanges_ySorted = sortedPointillisticData_divide.slideBoundaryIndex(sortedData_y, yBounds_ySorted, lowerIndex_starting);
            
            for idx_x=1:N_x
                for idx_y=1:N_y
                    
                    % lower and upper indices of the "x" sorted coordiantes of that
                    % fall between the given "x" bounds:
                    indexRanges_xDivision=indexRanges_xSorted(idx_x,:);

                    % lower and upper indices of the "y" sorted coordiantes of that
                    % fall between the given "y" bounds:
                    indexRanges_yDivision=indexRanges_ySorted(idx_y,:);

                    xSortedIndices_yCut = sortingOrder_y(indexRanges_yDivision(1):indexRanges_yDivision(2));

                    xSortedIndices_xyCut = xSortedIndices_yCut(xSortedIndices_yCut>=indexRanges_xDivision(1) & xSortedIndices_yCut<=indexRanges_xDivision(2));

                    %% Y selection
                    % the indices of the data points falling in the
                    % affected zone of the currect pixel:
                    indicesCell{idx_x, idx_y}=sortingOrder_x(xSortedIndices_xyCut);
                    
                end
            end
        end
        
    end
end

