classdef calculateSpatiotemporalDensity
% These functions calculate the spatio-temporal density of the pontillistic
% data points. It requires a ROI selection and a frame index range.
    
methods (Static)
    
    function [spatiotemporalDensity, spatialDensity, temporalDensity] = surface(pointillisticData, ROI_structure, frameThresholds, areaUnit, timeUnit, acquisitionParameters)
        % This function calculates the 2D spatial and temporal density.
        
        % area of the selected ROI:
        area=pointillisticData_selectROI.calculateArea(ROI_structure);
        % number of frames in the frame range:
        time.value=frameThresholds(2)-frameThresholds(1)+1;
        time.unit='camera frame interval';
        
        % convert the area and time values:
        area=unitConversion.convertScalarQuantity(area, areaUnit, acquisitionParameters);
        time=unitConversion.convertScalarQuantity(time, timeUnit, acquisitionParameters);
        
        
        % pontillistic datas within the ROI:
        filterBoolVect_ROI=pointillisticData_selectROI.cutROI(pointillisticData, ROI_structure, acquisitionParameters);
        
        % pointillistic data withis the frame range:
        filterSettings.frame_idx=frameThresholds;
        filterBoolVect_frames = pointillisticData_filtering.getBooleanVect(pointillisticData, filterSettings);
        
        % pontillistic datas within the ROI and frame range:
        filterBoolVect=filterBoolVect_ROI.*filterBoolVect_frames;
        
        % number of pointillistic datas passed the filtering:
        dataN=sum(filterBoolVect);
        
        % the spatio-temporal density
        spatiotemporalDensity.value=dataN/area.value/time.value;
        spatiotemporalDensity.unit=['1/', area.unit, '/', time.unit];
        spatialDensity.value=dataN/area.value;
        spatialDensity.unit=['1/', area.unit];
        temporalDensity.value=dataN/time.value;
        temporalDensity.unit=['1/', time.unit];
    end
    
    function line()
        % This function calculates the 1D spatial and temporal density.
    end
    
    function point()
        % This function calculates the 0D spatial and temporal density (so temporal density only).
        
    end
    
    
end

end

