function [XC, nOfEl, volumeOfCl, distOfCl] = clusterProperties(X, IDX)
    % calculate other properties of the clusters

    dimension=size(X, 2);

    %% center of clusters
    XC=zeros([max(IDX), size(X,2)]);
    for indcl=1:max(IDX)
        XC(indcl,:)=mean(X(IDX==indcl,:), 1);
    end 

    %% num of elements of each cl
    nOfEl=zeros([max(IDX), 1]);
    for indcl=1:max(IDX)
        nOfEl(indcl,:)=sum(IDX==indcl);
    end

    %% area/volume of clusters
    volumeOfCl=zeros([max(IDX), 1]);
    if dimension==2
        minPoints=3;
    elseif dimension==3
        minPoints=4;
    else
        error('Invalid cluster data')
    end
    for indcl=1:max(IDX)
        clusterPoints=double(X(IDX==indcl,:));
        if size(clusterPoints, 1)>=minPoints
            [~,volumeOfCl(indcl,:)]=convhull(clusterPoints);
        else
            % give zero volume of there are too few localization
            % points in the cluster to form a volume
            volumeOfCl(indcl,:)=0;
        end
    end

    %% distance of closest cluster
    minDistM=pdist2(XC,XC);
    minDistM(~minDistM)=nan;
    distOfCl=transpose(min(minDistM));

end

