classdef pointillisticData_selection
    %UNTITLED Summary of this class goes here
    %   Detailed explanation goes here
    
    methods (Static)
        function [dataFileFullNameList, N_dataFiles, dataPath, dataFileNameList, dataFileExtList] = single(varargin)
            if numel(varargin)==0
                defaultPath='';          % open the dialog in the actual work path
            elseif numel(varargin)==1
                defaultPath=varargin{1};
            end
            
            % File chooser dialog to select one or several data files
            [dataFiles, dataPath,~] = uigetfile(...
                {'*.csv', 'coma separated values file';...
                '*.*', 'All files'},...
                'Open data files',...
                defaultPath,...
                'MultiSelect', 'off');
            
            [dataFileFullNameList, N_dataFiles, dataFileNameList, dataFileExtList] =...
                pointillisticData_selection.conformFileNameList(dataFiles, dataPath);
        end
        
        function [dataFileFullNameList, N_dataFiles, dataPath, dataFileNameList, dataFileExtList] = multiple(varargin)
            if numel(varargin)==0
                defaultPath='';          % open the dialog in the actual work path
            elseif numel(varargin)==1
                defaultPath=varargin{1};
            end
            
            % File chooser dialog to select one or several data files
            [dataFiles, dataPath,~] = uigetfile(...
                {'*.csv', 'coma separated values file';...
                '*.*', 'All files'},...
                'Open data files',...
                defaultPath,...
                'MultiSelect', 'on');
            
            if iscell(dataFiles) || ischar(dataFiles)
                [dataFileFullNameList, N_dataFiles, dataFileNameList, dataFileExtList] =...
                    pointillisticData_selection.conformFileNameList(dataFiles, dataPath);
            elseif dataFiles == 0
                dataFileFullNameList = {};
                N_dataFiles = 0;
                dataFileNameList = {};
                dataFileExtList = {};
            else
                error('Some error during pointillistic data selection. Check what has happened, it should not have occured!')
            end
        end
        
        function folder
            % TODO
        end
        
        function csvList = allFromSubdirectories(varargin)

            if numel(varargin)==0
                defaultPath='';          % open the dialog in the actual work path
            elseif numel(varargin)==1
                defaultPath=varargin{1};
            end
            
            parentDirectory = uigetdir(defaultPath, 'Select the parent folder of the *.csv data files.');
            
            subDirectories = strsplit(genpath(parentDirectory), ':');

            % delete the first element, which is the parent directory
            subDirectories(1) = [];

            csvList = {'dummy'};

            for subdirIndex = 1:numel(subDirectories)

                fileList = dir([subDirectories{subdirIndex}, filesep, '*', 'locs.csv']);

                for fileIndex = 1:numel(fileList)

                    fileName = fileList(fileIndex).name;

                    [~,~,fileExtension] = fileparts(fileName);

                    if strcmp(fileExtension, '.csv')
                        csvList{end+1} = fullfile(subDirectories{subdirIndex}, fileName);
                    end

                end

            end

            csvList(1) = [];

        end
        
        function [dataFileFullNameList, N_dataFiles, dataFileNameList, dataFileExtList] = conformFileNameList(dataFiles, dataPath)
            % This function conforms the file name list for further use.
            % If only one file was selected, puts its name into a one
            % element cell array to be consistent with multiple file
            % selection. It also concatenates the file paths and names to
            % get the full paths.
            
            % The number of input data files
            if iscell(dataFiles)
                N_dataFiles=numel(dataFiles);
            else
                N_dataFiles=1;
            end
            
            % full name of the data files
            dataFileFullNameList=cell(1,N_dataFiles);
            % names of the data files
            dataFileNameList=cell(1,N_dataFiles);
            % extensions of the data files
            dataFileExtList=cell(1,N_dataFiles);
            
            % adding the data files into a cell array (the "list")
            if N_dataFiles==1
                dataFileFullNameList{1}=[dataPath, dataFiles];
                [~, dataFileNameList{1}, dataFileExtList{1}]=fileparts(dataFiles);
            else
                for idxFile=1:N_dataFiles
                    dataFileFullNameList{idxFile}=[dataPath, dataFiles{idxFile}];
                    [~, dataFileNameList{idxFile}, dataFileExtList{idxFile}]=fileparts(dataFiles{idxFile});
                end
            end
        end
        
    end
end

