% Beware: the "jsonencode" cannot differentiate between empty struct
% and empty cell array

classdef jsonManagement
    % This class contains methods for managing JSON text/data, line
    % exporting Matlab structure to a JSON file or importing JSON data from
    % a file into a MATLAB structure.
    
    methods(Static)
        
        function importedStructure = import(fileName)
            
            % open the file for reading in text mode:
            fileID = fopen(fileName, 'rt');
            jsonString = fscanf(fileID, '%c');
            fclose(fileID);
            
            importedStructure=jsondecode(jsonString);
            
        end
        
        function export(structureToExport, fileName)
            
            % create the JSON string from the structure data:
            jsonString=jsonencode(structureToExport,'ConvertInfAndNaN', false);
            
            % need to handle the escape characters because os fprintf
            jsonString = strrep(jsonString, '\\', '\\\\');
            % the jsonencode converts the "\" escape character to "\\",
            % this double stuff must be retained after the fprintf...
            
            % open or create the file for writing in text mode:
            fileID = fopen(fileName,'wt');
            fprintf(fileID, jsonString);
            fclose(fileID);
            
        end
        
    end
end

% TODO: the exported JSON file has no line breaks and indents, it is not very readable
% possible solution (have not tried yet): JSONLab
% https://www.mathworks.com/matlabcentral/fileexchange/33381-jsonlab-a-toolbox-to-encode-decode-json-files
