function [outputStructure] = objectToStructure(inputClass)
% This function converts the given object to a structure that has the same
% fields as the object. It also checks the fields or properties and
% converts them too, if necessary.


if isobject(inputClass)
    % if the input is an object, go through its properties and pass them to the
    % output structure or convert them to structure, too
    
    % the structure to be retuned:
    outputStructure=struct();
    
    % properties of the object:
    classProperties=properties(inputClass);
    % the number of properties of the obejct:
    propertiesN=numel(classProperties);
    
    % go thought the properties and pass their values to the output
    % structure:
    for idxProperty=1:propertiesN
        % do it recursively:
        outputStructure.(classProperties{idxProperty})=objectToStructure(inputClass.(classProperties{idxProperty}));
    end
    
elseif isstruct(inputClass)
    % if the input is a structure, go through its fields and pass them to the
    % output structure or convert them to structure, too
    
    % the structure to be retuned:
    outputStructure=struct();
    
    % properties of the object:
    fieldNames=fieldnames(inputClass);
    % the number of fields of the structure:
    fieldsN=numel(fieldNames);
    
    % go thought the fields and pass their values to the output
    % structure:
    for idxField=1:fieldsN
        % do it recursively:
        outputStructure.(fieldNames{idxField})=objectToStructure(inputClass.(fieldNames{idxField}));
    end
else
    % if the input is some other variable with distict value (this is the
    % right condition), returns it
    outputStructure=inputClass;
end

end

