classdef outputNaming

    methods (Static)
        
        function newFullName = custom(type, workingDirectory, originalName, stringToAppend, outputExtension)
            switch type
                case 'absolute'
                    [originalPath, originalName, originalExtension]=fileparts(originalName);
                    newName=[originalName, stringToAppend, outputExtension];
                    newFullName=fullfile(workingDirectory, newName);
                    if isempty(workingDirectory)
                        warning('File will be saved relative to the Matlab working directory.')
                    elseif ~strcmp(workingDirectory(1), filesep)
                        warning('File will be saved relative to the Matlab working directory.')
                    end
                case 'relative'
                    [originalPath, originalName, originalExtension]=fileparts(originalName);
                    newName=[originalName, stringToAppend, outputExtension];
                    newFullName=fullfile(originalPath, workingDirectory, newName);
                otherwise
                    error('The output name creation type (absolute or relative file path) was not specified.')
            end
        end
        
        
        function outputFullName = versioning(outputFullName)
            versionIdx=1;
            while isfile(outputFullName)
                [outputPathPath, ouputName, outputExtension]=fileparts(outputFullName);
                outputFileName=[ouputName, outputExtension];
                versionIdx=versionIdx+1;
                stringToPaste=['_ver', num2str(versionIdx), outputExtension];
                stringToReplace=['_ver', num2str(versionIdx-1), outputExtension];
                if contains(outputFileName, stringToReplace)
                    outputFileName=strrep(outputFileName, stringToReplace, stringToPaste);
                else
                    outputFileName=[ouputName, stringToPaste];
                end
                outputFullName=fullfile(outputPathPath, outputFileName);
            end
        end
        
        function outputFullName = localizationData(originalFullName)
            [stringToAppend, outputExtension] = outputNaming.definitions ('localization data');
            outputFullName=outputNaming.custom(originalFullName, stringToAppend, outputExtension);
            outputFullName = outputNaming.versioning(outputFullName);
        end
        
        function outputFullName = infoFile(originalFullName)
            [stringToAppend, outputExtension] = outputNaming.definitions ('info file');
            outputFullName=outputNaming.custom(originalFullName, stringToAppend, outputExtension);
            outputFullName = outputNaming.versioning(outputFullName);
        end
        
        function outputFullName = driftFigure(originalFullName)
            [stringToAppend, outputExtension] = outputNaming.definitions('drift figure');
            outputFullName=outputNaming.custom(originalFullName, stringToAppend, outputExtension);
            outputFullName = outputNaming.versioning(outputFullName);
        end
        
        function outputFullName = driftTrajectory(originalFullName)
            [stringToAppend, outputExtension] = outputNaming.definitions ('drift trajectory');
            outputFullName=outputNaming.custom(originalFullName, stringToAppend, outputExtension);
            outputFullName = outputNaming.versioning(outputFullName);
        end
        
        function outputFullName = trajectoryData(originalFullName)
            [stringToAppend, outputExtension] = outputNaming.definitions ('trajectory data');
            outputFullName=outputNaming.custom(originalFullName, stringToAppend, outputExtension);
            outputFullName = outputNaming.versioning(outputFullName);
        end
        
        function outputFullName = trajectoryInfoData(originalFullName)
            [stringToAppend, outputExtension] = outputNaming.definitions ('trajectory info data');
            outputFullName=outputNaming.custom(originalFullName, stringToAppend, outputExtension);
            outputFullName = outputNaming.versioning(outputFullName);
        end
        
        function outputFullName = clusterData(originalFullName)
            [stringToAppend, outputExtension] = outputNaming.definitions ('cluster data');
            outputFullName=outputNaming.custom(originalFullName, stringToAppend, outputExtension);
            outputFullName = outputNaming.versioning(outputFullName);
        end
        
        function outputFullName = clusterInfoData(originalFullName)
            [stringToAppend, outputExtension] = outputNaming.definitions ('cluster info data');
            outputFullName=outputNaming.custom(originalFullName, stringToAppend, outputExtension);
            outputFullName = outputNaming.versioning(outputFullName);
        end
        
        function outputFullName = superResolvedImage(originalFullName)
            [stringToAppend, outputExtension] = outputNaming.definitions ('super resolved image');
            outputFullName=outputNaming.custom(originalFullName, stringToAppend, outputExtension);
            outputFullName = outputNaming.versioning(outputFullName);
        end
        
        
        function [stringToAppend, outputExtension] = definitions (outputType)
            
            switch outputType
                
                case 'localization data'
                    stringToAppend='_locs';
                    outputExtension='.csv';
                    
                case 'info file'
                    stringToAppend='_info';
                    outputExtension='.xml';
                    
                case 'drift figure'
                    stringToAppend='_drift';
                    outputExtension='.png';
                    
                case 'drift trajectory'
                    stringToAppend='_drift';
                    outputExtension='.csv';
                    
                case 'trajectory data'
                    stringToAppend='_trajs';
                    outputExtension='.csv';
                    
                case 'trajectory info data'
                    stringToAppend='_trajsInfo';
                    outputExtension='.mat';
                    
                case 'cluster data'
                    stringToAppend='_clusters';
                    outputExtension='.csv';
                    
                case 'cluster info data'
                    stringToAppend='_clustersInfo';
                    outputExtension='.mat';
                    
                case 'super resolved image'
                    stringToAppend='_supResIm';
                    outputExtension='.png';
                    
                otherwise
            end
            
            
        end
        
    end
end

