% path of the evaluation codes relative to the script location:
codePath='..';

% adding the directories containing the required functions
run(fullfile(codePath, 'addSubfoldersToPath.m'));

% path of the operation settings file relative to the script location:
operationSettingsPath=fullfile(codePath, ['algorithms', filesep, 'rainSTORM', filesep, 'settings']);
% name of the operation settings file to be used:
settingsFile='rainSTORM_defaults.json';
% path of the camera settings file relative to the script location:
cameraPropertiesPath=operationSettingsPath;
% name of the camera settings file to be used:
cameraPropertiesFile='AdOptIm_cameras.json';

%csv_dataConvention='none';
csv_dataConvention='rainSTORM';
%csv_dataConvention='rainSTORM legacy';

%% running the algorithms

% loading the settings files:
[operations] = settingsManagement.loadOperations(operationSettingsPath, settingsFile);
[operations] = settingsManagement.loadCameraProperties(cameraPropertiesPath, cameraPropertiesFile, operations);

%% Data loading

defaultPath = '';
localizationDataFullFileName=pointillisticData_selection.single(defaultPath);

[localizationData, evaluationParameters] = pointillisticData_load.csv_separateInfo(localizationDataFullFileName{1}, csv_dataConvention);
cameraSignalConversion=evaluationParameters.imageStackReading.metadata.cameraSignalConversion;


%% Visualization (localizations)

[evaluationParameters, localizationImageMatrix, localizationFigure] = runOperation(operations, 'localizationVisualization', evaluationParameters, localizationData);

%% 



imagePixelSize=unitConversion.convert2DVectorQuantity(evaluationParameters.localizationVisualization.settings.pixelization.pixelSize, 'camera pixel length', cameraSignalConversion);
%ROIs = pointillisticData_selectROI.drawAdjustableRectangle_multiple(localizationFigure, cameraSignalConversion);
%ROIs = pointillisticData_selectROI.drawAdjustableRectangle(localizationFigure, imagePixelSize, cameraSignalConversion);

size_x = 300;
size_y = 300;
size_unit = 'nm';
angle_value = 0;
angle_unit = 'degree';
ROIs=pointillisticData_selectROI.selectPoints_ellipticROIs(localizationFigure, size_x, size_y, size_unit, angle_value, angle_unit, cameraSignalConversion);

for idxROI = 1:numel(ROIs.parameters)
    
    ROI = struct();
    ROI.type = ROIs.type;
    ROI.parameters(1) = ROIs.parameters(idxROI);

    localizationData_filtered = pointillisticData_selectROI.filterROI(localizationData, ROI, cameraSignalConversion);

    % % set the filtering thresholds:
    % filteringThresholds=struct();
    % filteringThresholds.sig=[0.7, 4];
    % filteringThresholds.std=unitConversion.convertValue([0, 45], 'nm', 'camera pixel length', cameraSignalConversion);
    % 
    % % setting for the localization precision calculations (needed if the
    % % filtering is performed on it):
    % fieldCalculationSettings.precision.method='Thompson';
    % fieldCalculationSettings.acquisitionParameters=evaluationParameters.imageStackReading.metadata.cameraSignalConversion;

    % % filter the localizations:
    % [localizationData, localizationData_rejected, filteringBooleanVect_localizations] = pointillisticData_filtering.threshold(localizationData, filteringThresholds, fieldCalculationSettings);
    % evaluationParameters.filtering.settings.thresholds=filteringThresholds;

    transformationSettings.acquisitionParams = cameraSignalConversion;
    transformationSettings.evaluationSettings.ROI = ROI.parameters;
    transformationSettings.rotation_XY = ROI.parameters.angle;
    transformationSettings.translation_XY = ROI.parameters.center;

    localizationData_ROI_rotated = pointillisticData_coordinateTransformation.inverseTransform(localizationData_filtered, transformationSettings);

    positionUnit='nm';
    x = unitConversion.convertValue(localizationData_ROI_rotated.x_coord, 'camera pixel length', positionUnit, cameraSignalConversion);
    y = unitConversion.convertValue(localizationData_ROI_rotated.y_coord, 'camera pixel length', positionUnit, cameraSignalConversion);
    z = unitConversion.convertValue(localizationData_ROI_rotated.z_coord, 'camera pixel length', positionUnit, cameraSignalConversion);
    %z = localizationData_ROI_rotated.z_nm_;

    ROI_parameters_nm = unitConversion.convertROI(ROI.parameters, 'nm', cameraSignalConversion);

    x_min = -0.5 * ROI_parameters_nm.size.x;
    x_max = 0.5 * ROI_parameters_nm.size.x;
    y_min = -0.5 * ROI_parameters_nm.size.y;
    y_max = 0.5 * ROI_parameters_nm.size.y;
    %z_min=-1000;
    %z_max=1000;
    z_min=evaluationParameters.astigmatic3D.settings.zBounds(1);
    z_max=evaluationParameters.astigmatic3D.settings.zBounds(2);

    %% 3D 

    % plotting the 3D structure
    x_projection=ones(size(x))*x_max;
    y_projection=ones(size(y))*y_max;
    z_projection=ones(size(z))*z_min;

    precisonFigure = figure();
    precisonFigure.Position(3:4) = [1120 420];
    
    subplot(1,2,1)
    markerSize=2;
    scatter3(x,y,z,markerSize,z, 'MarkerFaceColor', 'flat');
    colormap(jet);
    colorbar;
    hold on;
    scatter3(x,y,z_projection,markerSize,'MarkerEdgeColor',[0.7 0.7 0.7],'MarkerFaceColor',[0.7 0.7 0.7]);
    hold on;
    scatter3(x,y_projection,z,markerSize,'MarkerEdgeColor',[0.7 0.7 0.7],'MarkerFaceColor',[0.7 0.7 0.7]);
    hold on;
    scatter3(x_projection,y,z,markerSize,'MarkerEdgeColor',[0.7 0.7 0.7],'MarkerFaceColor',[0.7 0.7 0.7]);
    axis([x_min x_max y_min y_max z_min z_max]);
    xlabel("x position [nm]")
    ylabel("y position [nm]")
    zlabel("z position [nm]")

    %view(-45,45);
    view(-45,20);
    %view(90,90);

    std_x = std(x, 'omitnan');
    std_y = std(y, 'omitnan');
    std_z = std(z, 'omitnan');
    disp(['ROI index: ', num2str(idxROI)]);
    disp(['localization number: ', num2str(numel(localizationData_filtered.x_coord))])
    disp(['X position STD within the selected area: ',num2str(std_x), positionUnit] )
    disp(['Y position STD within the selected area: ',num2str(std_y), positionUnit] )
    disp(['Z position STD within the selected area: ',num2str(std_z), positionUnit] )

    subplot(1,2,2)
    binNumber = 20;
    histogram(z, binNumber)
    xlabel("z position [nm]")
    ylabel("localization number")
    text(0.6,0.9, ['STD: ', num2str(std_z, '%0.0f'), ' ', positionUnit], 'Units', 'normalized')
end
