classdef findOperation
% Finds the given operation in the analysis parameters. Useful if one wants
% to know with which settings the given operation was performed.
    
    methods (Static)
    
        function [operation] = processing(analysisParameters, dataType, operationName)

            operation = struct([]);

            analysisparameters_actual = analysisParameters;


            while ~isempty(analysisparameters_actual)

                % if the data type does not match, skip it:
                if ~strcmp(analysisParameters.dataType, dataType)
                    analysisparameters_actual = analysisparameters_actual.derivateDatas{1};
                    continue;
                end

                for operationIndex = 1:numel(analysisparameters_actual.processing)

                    actualOperation = analysisparameters_actual.processing{end - operationIndex + 1};

                    if strcmp(actualOperation.operationType, operationName)
                        operation = actualOperation;
                        break;
                    end

                end

                if ~ isempty(operation)
                   break; 
                end


                if ~isempty(analysisparameters_actual.derivativeDatas)
                    analysisparameters_actual = analysisparameters_actual.derivativeDatas{1};
                else
                    break;
                end

            end
        end

        function [operation] = creation(analysisParameters, dataType, operationName)

            operation = struct([]);

            analysisparameters_actual = analysisParameters;


            while ~isempty(analysisparameters_actual)

                % if the daty type does not match, skip it:
                if ~strcmp(analysisParameters.dataType, dataType)
                    if isempty(analysisparameters_actual.derivativeDatas)
                        break
                    else
                        analysisparameters_actual = analysisparameters_actual.derivativeDatas{1};
                        continue;
                    end
                end

                actualOperation = analysisparameters_actual.creationOperation;

                if strcmp(actualOperation.operationType, operationName)
                    operation = actualOperation;
                    break;
                end

                if ~ isempty(operation)
                   break; 
                end

                if ~isempty(analysisparameters_actual.derivativeDatas)
                    analysisparameters_actual = analysisparameters_actual.derivativeDatas{1};
                else
                    break;
                end

            end
        end
        
    end
end
