function [operationSettings] = loadCameraCalibration(cameraCalibrationPath, cameraCalibrationFile, operationSettings)
% Adds the camera calbration file  to the operation settings. When reading
% an image stack this camera calibration file will be used to determine the
% count/photoelectron, count/photon or the camera signal offset (baseline)
% values for the used camera readout mode and settings.


    cameraPropertiesFullFileName=fullfile(cameraCalibrationPath, cameraCalibrationFile);

    dataType = 'imageStack';
    if isfield(operationSettings, dataType)
        operationSettings.imageStack.creation.reading.settings.cameraCalibrationFile=cameraPropertiesFullFileName;
    else
        warning('The operation settings is missing the "image stack reading" operation. Make sure you you do not want to use this operation.');
    end

end

