classdef runOperation
    %UNTITLED2 Summary of this class goes here
    %   Detailed explanation goes here
    
    methods (Static)
        
        function [analysisParameters_new, varargout] = creation(operations, dataType, operationName, analysisParameters_array, varargin)
        % This function the algorithms settings structure and runs the defined
        % algorithm with the defined settings.

            if ~isfield(operations, dataType)
                error(['Invalid data type given for data creation operation: ', dataType]);
            end

            if ~isfield(operations.(dataType).creation, operationName)
               error(['Invalid operation was given for new data creation: ', operationName]); 
            end
            analysisParameters_new.dataType = dataType;
            analysisParameters_new.note = '';
            analysisParameters_new.derivativeDatas = analysisParameters_array;
            if ~isempty(analysisParameters_array)
                analysisParameters_new.sharedParameters = analysisParameters_array{1}.sharedParameters;
            else
                analysisParameters_new.sharedParameters = struct();
            end

            % the actual operation that should be run:
            operation=operations.(dataType).creation.(operationName);

            % create the function handle for the given algorithm:
            operationHandle=str2func(operation.functionName);

            % link the relevant parameters of the prevoius evaluations to the current
            % operation's settings:
            operation.settings = runOperation.linkSettings(operation.settings, operation.settingsLinking, analysisParameters_new.sharedParameters);

            % run the algorithm with the defined settings:
            outputN=nargout(operationHandle);
            % outputData=cell(1, outputN-1);
            % [outputData{1:end}, metadata] = operationHandle(varargin{:}, operation.settings);

            outputVariables=cell(1, outputN-2);
            [outputVariables{:}, metadata, sharedParameters] = operationHandle(varargin{:}, operation.method, operation.settings);
            varargout=outputVariables;
            %metadata=varargout{end};

            % store the settings of the run algorithms:
            operationParameters = rmfield(operation, 'settingsLinking');
            metadataNames=fieldnames(metadata);
            for idxParameter=1:numel(metadataNames)
                operationParameters.metadata.(metadataNames{idxParameter})=metadata.(metadataNames{idxParameter});
            end
            analysisParameters_new.processingOperations = {};
            analysisParameters_new.creationOperation = operationParameters;

            sharedParameterNames = fieldnames(sharedParameters);
            for idxParameter=1:numel(sharedParameterNames)
                analysisParameters_new.sharedParameters.(sharedParameterNames{idxParameter}) = sharedParameters.(sharedParameterNames{idxParameter});
            end
        
        end
        
        function [analysisParameters, varargout] = processing(operations, operationName, analysisParameters, varargin)
        % This function the algorithms settings structure and runs the defined
        % algorithm with the defined settings.

            dataType = analysisParameters.dataType;

            if ~isfield(operations, dataType)
                error(['Invalid data type given for data processing operation: ', dataType]);
            end

            if ~isfield(operations.(dataType).processing, operationName)
               error(['Invalid operation was given: ', operationName]); 
            end

            % the actual operation that should be run:
            operation=operations.(dataType).processing.(operationName);

            % create the function handle for the given algorithm:
            operationHandle=str2func(operation.functionName);

            % link the relevant parameters of the prevoius evaluations to the current
            % operation's settings:
            operation.settings = runOperation.linkSettings(operation.settings, operation.settingsLinking, analysisParameters.sharedParameters);

            % run the algorithm with the defined settings:
            outputN=nargout(operationHandle);
            % outputData=cell(1, outputN-1);
            % [outputData{1:end}, metadata] = operationHandle(varargin{:}, operation.method, operation.settings);

            outputVariables=cell(1, outputN-2);
            [outputVariables{:}, metadata, sharedParameters] = operationHandle(varargin{:}, operation.method, operation.settings);

            % store the settings of the run algorithms:
            operationParameters = rmfield(operation, 'settingsLinking');
            metadataNames=fieldnames(metadata);
            for idxParameter=1:numel(metadataNames)
                operationParameters.metadata.(metadataNames{idxParameter})=metadata.(metadataNames{idxParameter});
            end
            
            % needed becuase the json import/export removes the empty field
            if ~isfield(analysisParameters, 'processingOperations')
                analysisParameters.processingOperations = {};
            end
            operationIndex = numel(analysisParameters.processingOperations) + 1;
            
            analysisParameters.processingOperations{operationIndex} = operationParameters;

            % return the index of this operation so its paramters can
            % directly be extracted if needed:
            outputVariables{end+1} = operationIndex;
            
            sharedParameterNames = fieldnames(sharedParameters);
            for idxParameter=1:numel(sharedParameterNames)
                analysisParameters.sharedParameters.(sharedParameterNames{idxParameter}) = sharedParameters.(sharedParameterNames{idxParameter});
            end

            varargout=outputVariables;
            %metadata=varargout{end};
            
        end
        
        function operationSettings = linkSettings(operationSettings, settingsLinking, sharedParameters)
        % This function links a previous operation's evaluation parameters to the
        % settings of the actual operation if its settings request it. 

            % go through the linking settings of the actual operation and check the fields:
            for idxSetting=1:numel(settingsLinking)

                if ~isempty(settingsLinking(idxSetting))
                    % if there is anysettings to link to any evaluation parameter

                    % the full name (within parameters structure) of the parameters that should be linked: 
                    sourceStringCell=strsplit((settingsLinking(idxSetting).sourceParameter), '.');

                    % the parameters of the operations that should be linked:
                    operationSettings_toBeLinked=getfield(sharedParameters, sourceStringCell{:});

                    % settings the parameters for the required setting:
                    targetStringCell=strsplit((settingsLinking(idxSetting).target), '.');
                    % https://stackoverflow.com/questions/21145042/nested-structure-access-using-dynamic-fieldnames
                    operationSettings=setfield(operationSettings, targetStringCell{:}, operationSettings_toBeLinked);

                else
                   % do nothing 
                end

            end
        end
        
        
    end
end

