function [pointillisticData, metadata, sharedParameters] = pointillisticDataLoading(dataFileFullName, convention, method, settings)

missingCameraSignalConversionParameterOverwrite = settings.missingCameraSignalConversionParameterOverwrite;


if strcmp(convention, 'rainSTORM')
    [pointillisticData, analysisParameters] = rainSTORM_dataImport(dataFileFullName, missingCameraSignalConversionParameterOverwrite);
elseif strcmp(convention, 'rainSTORM legacy')
    [pointillisticData, analysisParameters] = rainSTORM_legacy_dataImport(dataFileFullName, missingCameraSignalConversionParameterOverwrite);
elseif strcmp(convention, 'rainSTORM scripting version')
    [pointillisticData, analysisParameters] = rainSTORM_scriptingVersion_dataImport(dataFileFullName, missingCameraSignalConversionParameterOverwrite);
elseif strcmp(convention, 'ThunderSTORM')
    [pointillisticData, analysisParameters] = ThunderSTORM_dataImport(dataFileFullName, missingCameraSignalConversionParameterOverwrite);
else
    error('Unknown data convention ("%s") when loading pontillistic data.', convention);
end

metadata.convention = convention;
metadata.originalDataPath = analysisParameters.sharedParameters.originalDataPath;
metadata.originalDataName = analysisParameters.sharedParameters.originalDataName;

sharedParameters = analysisParameters.sharedParameters;


end