% script to run the batch data processing

% change the variables in the first section according to the actual needs

[currentDir,~,~] = fileparts(mfilename('fullpath'));

% change the working directory
cd(currentDir)

addSubfoldersToPath()

% path of the operation settings file relative to the script location:
operationSettingsPath='settings';
% name of the operation settings file to be used:
settingsFile='operationSettings_rainSTORM_GUI_defaults.json';

% path of the camera settings file relative to the script location:
cameraCalibrationPath='settings';
% name of the camera settings file to be used:
cameraCalibrationFile='cameraCalibration_AdOptIm.json';

% save the result in a folder named the same as the data file:
%subfolderFlag=true;
% save the result in the same folder as the data file:
subfolderFlag=false;

% path and the name of the data saving
% leave them empty, so the data will be saved in the same folder as it was imported from 
exportName = '';
exportPath = '';

%% loading the settings and select the datas

% chose multiple image stacks:
[dataFileFullNames, imageType]=imageStack_selection.multipleStacks();

% alternatively, manually set the file name and its type:
%dataFullFileNames={''};
%imageType='TIFF image stack (*.tif)';

% optical magnification beside the nominal one:
additionalMagnification = 1.0;
%additionalMagnification = 1.5;

% The image metadata can be read from ND2 or OME-TIFF file, otherwise set
% these manually (e.g. when reading TIFF file generated with TestSTORM):
% cameraSignalConversionParameters = struct(...
%     'pixelSize', struct('value', 160,'unit', 'nm'),...
%     'exposureTime', struct('value', 30,'unit', 'ms'),...
%     'frameInterval', struct('value', 30.9,'unit', 'ms'),...
%     'countsPerElectron', struct('value', 100/67.8),...
%     'countsPerPhoton', struct('value', 0.92 * 100/67.8),...
%     'baseline', struct('value', 100,'unit', 'camera count')...
%     );
%localizationData.creation.loading.settings.missingCameraSignalConversionParameterOverwrite = cameraSignalConversionParameters;
%imageStack.creation.reading.settings.settings.missingCameraSignalConversionParameterOverwrite = cameraSignalConversionParameters;

%% Data processing

operationSettingsFullFile = fullfile(operationSettingsPath, settingsFile);
cameraCalibrationFullFile = fullfile(cameraCalibrationPath, cameraCalibrationFile);

for idxData=1:numel(dataFileFullNames)

    dataFileFullName = dataFileFullNames{idxData};

    analysisObject = analysisClass();

    % load the settings
    analysisObject.loadOperationSettings(operationSettingsFullFile);
    analysisObject.loadCameraCalibration(cameraCalibrationFullFile);


    % overwrite the additional optical magnification if needed:
    analysisObject.setAdditionalMagnification(additionalMagnification);

    % overwrite the camera signal conversion parameters if needed:
    %analysisObject.setCameraSignaConversionParameters(cameraSignalConversionParameters);

    % read the image stack:
    analysisObject.imageStackImport(dataFileFullName, imageType);

    % remove the quasi-static fluorescent background from the image stack:
    %analysisObject.removeBackground();

    % localize spots on the image stack:
    analysisObject.localize();
    dataIndex = 1;
    analysisObject.pointillisticDatas(dataIndex).estimatePrecision();

    % filter the localizations:
    filteringOperation = analysisObject.operations.localizationData.processing.filtering;
%     % update the filtering thresholds, if needed:
%     filteringOperation.settings.thresholds = [...
%             struct('field', 'std', 'bounds', [0, 25], 'unit', 'nm'),...
%             struct('field', 'res', 'bounds', [0, 0.5], 'unit', ''),...
%             ];
    dataIndex = 1;
    analysisObject.filter(dataIndex, filteringOperation);

    % run the drift correction:
    driftCorrectionOperation = analysisObject.operations.localizationData.processing.driftCorrection;
    analysisObject.pointillisticDatas(dataIndex).correctDrift(driftCorrectionOperation);

    % save the localization data and the figures
    dataIndex = 1;
    convention_output = 'rainSTORM';
    analysisObject.dataExport(dataIndex, exportPath, exportName, subfolderFlag, convention_output);
    analysisObject.figuresExport(dataIndex, exportPath, exportName, subfolderFlag);
    prevSF = []; % leave it empty, so it will be calculated
    analysisObject.saveSumImage(dataIndex, prevSF, exportPath, exportName, subfolderFlag);

    delete(analysisObject);
    
end

% removing the directories added for the script
removeSubfoldersFromPath()