function [] = cameraCalibration_AdOptIm()

cameraPropertiesFileName='cameraCalibration_AdOptIm.json';

% for EMCCD:
camera{1}.manufacturer='Andor';
camera{1}.model='iXon3 897';
camera{1}.serialNumber='X-9384';
camera{1}.properties.baseline=100;
camera{1}.properties.quantumEfficiency.value=0.9;
camera{1}.properties.quantumEfficiency.wavelength_nm=550;
camera{1}.properties.electronsPerADCount=cell(18,1);

camera{1}.properties.electronsPerADCount{1}.settings.readOutRate='10 MHz';
camera{1}.properties.electronsPerADCount{1}.settings.conversionGain=1;
camera{1}.properties.electronsPerADCount{1}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{1}.value=67.8;

camera{1}.properties.electronsPerADCount{2}.settings.readOutRate='10 MHz';
camera{1}.properties.electronsPerADCount{2}.settings.conversionGain=2.4;
camera{1}.properties.electronsPerADCount{2}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{2}.value=26.76;

camera{1}.properties.electronsPerADCount{3}.settings.readOutRate='10 MHz';
camera{1}.properties.electronsPerADCount{3}.settings.conversionGain=5;
camera{1}.properties.electronsPerADCount{3}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{3}.value=12.77;

camera{1}.properties.electronsPerADCount{4}.settings.readOutRate='5 MHz';
camera{1}.properties.electronsPerADCount{4}.settings.conversionGain=1;
camera{1}.properties.electronsPerADCount{4}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{4}.value=58.9;

camera{1}.properties.electronsPerADCount{5}.settings.readOutRate='5 MHz';
camera{1}.properties.electronsPerADCount{5}.settings.conversionGain=2.4;
camera{1}.properties.electronsPerADCount{5}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{5}.value=28.85;

camera{1}.properties.electronsPerADCount{6}.settings.readOutRate='5 MHz';
camera{1}.properties.electronsPerADCount{6}.settings.conversionGain=5;
camera{1}.properties.electronsPerADCount{6}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{6}.value=10.86;

camera{1}.properties.electronsPerADCount{7}.settings.readOutRate='3 MHz';
camera{1}.properties.electronsPerADCount{7}.settings.conversionGain=1;
camera{1}.properties.electronsPerADCount{7}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{7}.value=59.7;

camera{1}.properties.electronsPerADCount{8}.settings.readOutRate='3 MHz';
camera{1}.properties.electronsPerADCount{8}.settings.conversionGain=2.4;
camera{1}.properties.electronsPerADCount{8}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{8}.value=23.86;

camera{1}.properties.electronsPerADCount{9}.settings.readOutRate='3 MHz';
camera{1}.properties.electronsPerADCount{9}.settings.conversionGain=5;
camera{1}.properties.electronsPerADCount{9}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{9}.value=10.75;

camera{1}.properties.electronsPerADCount{10}.settings.readOutRate='1 MHz';
camera{1}.properties.electronsPerADCount{10}.settings.conversionGain=1;
camera{1}.properties.electronsPerADCount{10}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{10}.value=23.26;

camera{1}.properties.electronsPerADCount{11}.settings.readOutRate='1 MHz';
camera{1}.properties.electronsPerADCount{11}.settings.conversionGain=2.4;
camera{1}.properties.electronsPerADCount{11}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{11}.value=9.15;

camera{1}.properties.electronsPerADCount{12}.settings.readOutRate='1 MHz';
camera{1}.properties.electronsPerADCount{12}.settings.conversionGain=5;
camera{1}.properties.electronsPerADCount{12}.settings.emMultiplication=true;
camera{1}.properties.electronsPerADCount{12}.value=4.19;

camera{1}.properties.electronsPerADCount{13}.settings.readOutRate='3 MHz';
camera{1}.properties.electronsPerADCount{13}.settings.conversionGain=1;
camera{1}.properties.electronsPerADCount{13}.settings.emMultiplication=false;
camera{1}.properties.electronsPerADCount{13}.value=10.73;

camera{1}.properties.electronsPerADCount{14}.settings.readOutRate='3 MHz';
camera{1}.properties.electronsPerADCount{14}.settings.conversionGain=2.4;
camera{1}.properties.electronsPerADCount{14}.settings.emMultiplication=false;
camera{1}.properties.electronsPerADCount{14}.value=4.28;

camera{1}.properties.electronsPerADCount{15}.settings.readOutRate='3 MHz';
camera{1}.properties.electronsPerADCount{15}.settings.conversionGain=5;
camera{1}.properties.electronsPerADCount{15}.settings.emMultiplication=false;
camera{1}.properties.electronsPerADCount{15}.value=1.91;

camera{1}.properties.electronsPerADCount{16}.settings.readOutRate='1 MHz';
camera{1}.properties.electronsPerADCount{16}.settings.conversionGain=1;
camera{1}.properties.electronsPerADCount{16}.settings.emMultiplication=false;
camera{1}.properties.electronsPerADCount{16}.value=3.745;

camera{1}.properties.electronsPerADCount{17}.settings.readOutRate='1 MHz';
camera{1}.properties.electronsPerADCount{17}.settings.conversionGain=2.4;
camera{1}.properties.electronsPerADCount{17}.settings.emMultiplication=false;
camera{1}.properties.electronsPerADCount{17}.value=1.59;

camera{1}.properties.electronsPerADCount{18}.settings.readOutRate='1 MHz';
camera{1}.properties.electronsPerADCount{18}.settings.conversionGain=5;
camera{1}.properties.electronsPerADCount{18}.settings.emMultiplication=false;
camera{1}.properties.electronsPerADCount{18}.value=0.69;


% for sCMOS:
camera{2}.manufacturer='Andor';
camera{2}.model='Zyla';
camera{2}.serialNumber='VSC-06628';
camera{2}.properties.baseline=100;
camera{2}.properties.quantumEfficiency.value=0.82;
camera{2}.properties.quantumEfficiency.wavelength_nm=550;
camera{2}.properties.electronsPerADCount=cell(2,1);

camera{2}.properties.electronsPerADCount{1}.settings.readOutRate='540 MHz';
camera{2}.properties.electronsPerADCount{1}.settings.conversionGain=4;
camera{2}.properties.electronsPerADCount{1}.settings.emMultiplication=false;
camera{2}.properties.electronsPerADCount{1}.value=0.29;

camera{2}.properties.electronsPerADCount{2}.settings.readOutRate='200 MHz';
camera{2}.properties.electronsPerADCount{2}.settings.conversionGain=4;
camera{2}.properties.electronsPerADCount{2}.settings.emMultiplication=false;
camera{2}.properties.electronsPerADCount{2}.value=0.26;


% get the path of this settings file creation function:
callerFunctionPath=fileparts(mfilename('fullpath'));

% create a full path fot the settings file exporting:
calibrationFileFullName=fullfile(callerFunctionPath, cameraPropertiesFileName);

jsonManagement.export(camera, calibrationFileFullName)


end

