function [] = operationSettings_ThunderSTORM_defaults()
% note: Running ThunderSTORm this way has not been tested for a while, so
% some things might not work without debugging!!

settingsNameFile='operationSettings_ThunderSTORM_defaults.json';

%% operation of the "imageStack" data type
imageStack = {};
imageStack.note = 'AdOptIm group''s ThunderSTORM image stack handling settings';

imageReading.operationType = 'image stack loading';
imageReading.note = 'load image stack and infer the used camera and its properties';
imageReading.functionName='TunderSTORM_imageStackReading.read';
imageReading.method = '';
imageReading.settings.cameraPropertiesFile=struct(...
    'name', 'camera calibration file', 'value', '', 'description', 'File that stores the count/photoelectron convertions for the different readout modes of the camera that was used.');
imageReading.settings.additionalMagnification=struct(...
    'name', 'additional magnification', 'value', 1.0, 'description', 'Additional magnification in the optical system, beside the nominal one.');
imageReading.settingsLinking=struct([]);
imageReading.settings.missingCameraSignalConversionParameterOverwrite = ...
    rainSTORM_settings_cameraSignalConversion('iXon897');

% the image stack creation operations:
imageStack.creation.reading = imageReading;


backgroundRemoval.operationType = 'background removal';
backgroundRemoval.note = 'quasi-static fluorescent background removal';
backgroundRemoval.functionName='rainSTORM_backgroundRemoval';
backgroundRemoval.method = 'moving median';
backgroundRemoval.settings.frameRange=struct(...
    'name', 'frame range', 'value', 50, 'description', 'Frame range of the moving filter, i.e. width of the moving window: 2 * Frame range + 1');
backgroundRemoval.settings.stackBaseline=struct(...
    'name', 'srack baseline', 'value', 0, 'description', 'This baseline value is subtracted before the background removal, and added after that.');
backgroundRemoval.settingsLinking(1).target='stackBaseline';
backgroundRemoval.settingsLinking(1).sourceParameter='cameraSignalConversion.baseline_count';

% the image stack processing operations:
imageStack.processing.backgroundRemoval = backgroundRemoval;

%% ThunderSTORM specific settings end here

% operation of the "localization" data type
localizationData.note = 'AdOptIm group''s ThunderSTORM localization data analysis settings';

localization.operationType='localization';
localization.note='ThunderSTORM''s default localization';
localization.functionName='ThunderSTORM_localization.localize';
localization.method='';
localization.settingsLinking=struct([]);
localization.settingsLinking(1).target='cameraSignalConversion';
localization.settingsLinking(1).sourceParameter='cameraSignalConversion';

imageFiltering.filter='[Wavelet filter (B-Spline)]';
imageFiltering.scale=2.0;
imageFiltering.order=3;

% imageFiltering.filter='[Averaging (Box) filter]';
% imageFiltering.size=3;

localization.settings.imageFiltering = imageFiltering;

approximateLocalizationOfMolecules.detector='[Local maximum]';
approximateLocalizationOfMolecules.connectivity='8-neighbourhood';
approximateLocalizationOfMolecules.threshold='std(Wave.F1)';

% approximateLocalizationOfMolecules.detector='[Centroid of connected components]';
% approximateLocalizationOfMolecules.watershed='false';
% approximateLocalizationOfMolecules.threshold='std(Wave.F1)';

localization.settings.approximateLocalizationOfMolecules = approximateLocalizationOfMolecules;

subPixelLocalizationOfMolecules.estimator='[PSF: Integrated Gaussian]';
subPixelLocalizationOfMolecules.sigma=1.6;
subPixelLocalizationOfMolecules.fitradius=3;
%subPixelLocalizationOfMolecules.method='[Weighted Least squares]';
subPixelLocalizationOfMolecules.method='[Maximum likelihood]';
subPixelLocalizationOfMolecules.full_image_fitting='false';
subPixelLocalizationOfMolecules.mfaenabled='false';

% subPixelLocalizationOfMolecules.estimator='[PSF: Gaussian]';
% subPixelLocalizationOfMolecules.sigma=1.6;
% subPixelLocalizationOfMolecules.fitradius=3;
% subPixelLocalizationOfMolecules.method='[Maximum likelihood]';
% subPixelLocalizationOfMolecules.full_image_fitting='false';
% subPixelLocalizationOfMolecules.mfaenabled=true;
% subPixelLocalizationOfMolecules.keep_same_intensity='false';
% subPixelLocalizationOfMolecules.nmax=5;
% subPixelLocalizationOfMolecules.fixed_intensity='true';
% subPixelLocalizationOfMolecules.expected_intensity='500:2500';
% subPixelLocalizationOfMolecules.pvalue=1.0E-6;

% subPixelLocalizationOfMolecules.estimator='[PSF: Elliptical Gaussian (3D astigmatism)]';
% subPixelLocalizationOfMolecules.sigma=1.6;
% subPixelLocalizationOfMolecules.fitradius=3;
% subPixelLocalizationOfMolecules.method='[Maximum likelihood]';
% subPixelLocalizationOfMolecules.full_image_fitting='false';
% subPixelLocalizationOfMolecules.mfaenabled='false';
% subPixelLocalizationOfMolecules.calibrationpath='algorithms/ThunderSTORM/3D_calib_dummy';

localization.settings.subPixelLocalizationOfMolecules = subPixelLocalizationOfMolecules;

visualizationOfTheResults.renderer='[Averaged shifted histograms]';
visualizationOfTheResults.magnification=5.0;
visualizationOfTheResults.colorizez='false';
visualizationOfTheResults.threed='false';
visualizationOfTheResults.shifts=2;
visualizationOfTheResults.repaint=50;

% visualizationOfTheResults.renderer='[Averaged shifted histograms]';
% visualizationOfTheResults.magnification=5.0;
% visualizationOfTheResults.colorizez='false';
% visualizationOfTheResults.threed='false';
% visualizationOfTheResults.shifts=2;
% visualizationOfTheResults.repaint=50;

localization.settings.visualizationOfTheResults = visualizationOfTheResults;
localization.settingsLinking=struct([]);

%% ThunderSTORM specific settings end here

dataLoading.operationType='localization data loading';
dataLoading.note='tabular data loading';
dataLoading.functionName='pointillisticDataLoading';
dataLoading.method='';
dataLoading.settings = struct();
dataLoading.settings.missingCameraSignalConversionParameterOverwrite = imageReading.settings.missingCameraSignalConversionParameterOverwrite;
dataLoading.settingsLinking=struct([]);

% the localization data creation operations:
localizationData.creation.localization = localization;
localizationData.creation.loading = dataLoading;


precisionEstimation = rainSTORM_GUIsettings_precision.settings('Mortensen, Gaussian mask estimation');

filtering = rainSTORM_GUIsettings_filtering.settings('rainSTORM default');

driftCorrection=rainSTORM_GUIsettings_driftCorrection.settings('rainSTORM cross correlation');

astigmatic3D=rainSTORM_GUIsettings_astigmatic3D.settings('sigma squared error');

clusterization=rainSTORM_GUIsettings_clusterization.settings('DBSCAN');

locPixelization=rainSTORM_GUIsettings_pixelization.settings('Simple Histogram');
locVisualization=rainSTORM_GUIsettings_visualization.settings('percentile of non-zeros saturation');

% the localization data processing operations:
localizationData.processing.precisionEstimation = precisionEstimation;
localizationData.processing.filtering = filtering;
localizationData.processing.driftCorrection = driftCorrection;
localizationData.processing.astigmatic3D = astigmatic3D;
localizationData.processing.pixelization = locPixelization;
localizationData.processing.visualization = locVisualization;
localizationData.processing.clusterization = clusterization;

%% operation of the "concatenated" data type
concatenatedData.note = 'AdOptIm group''s standard concatenated/trajectory data analysis settings';

concatenation=rainSTORM_GUIsettings_concatenation.settings('branching trajectories');

% the localization data creation operations:
concatenatedData.creation.concatenation = concatenation;
concatenatedData.creation.loading = dataLoading;

trajPixelization=rainSTORM_GUIsettings_pixelization.settings('Simple Histogram');
trajVisualization=rainSTORM_GUIsettings_visualization.settings('percentile of non-zeros saturation');

% the concatenated data processing operations:
concatenatedData.processing.pixelization = trajPixelization;
concatenatedData.processing.visualization = trajVisualization;
concatenatedData.processing.clusterization = clusterization;

%% finalize and export the operations

operationSettings.imageStack = imageStack;
operationSettings.localizationData = localizationData;
operationSettings.concatenatedData = concatenatedData;

% get the path of this settings file creation function:
callerFunctionPath=fileparts(mfilename('fullpath'));

% create a full path fot the settings file exporting:
settingsFileFullName=fullfile(callerFunctionPath, settingsNameFile);

% export the settings file:
jsonManagement.export(operationSettings, settingsFileFullName);

end

