function [] = operationSettings_rainSTORM_defaults()

settingsNameFile='operationSettings_rainSTORM_GUI_defaults.json';

%% operation of the "imageStack" data type
imageStack = {};
imageStack.note = 'AdOptIm group''s standard image stack handling settings';

imageReading.operationType = 'image stack loading';
imageReading.note = 'load image stack and infer the used camera and its properties';
imageReading.functionName='imageStackReading.read';
imageReading.method = '';
imageReading.settings.cameraPropertiesFile=struct(...
    'name', 'camera calibration file', 'value', '', 'description', 'File that stores the count/photoelectron convertions for the different readout modes of the camera that was used.');
imageReading.settings.additionalMagnification=struct(...
    'name', 'additional magnification', 'value', 1.0, 'description', 'Additional magnification in the optical system, beside the nominal one.');
imageReading.settingsLinking=struct([]);
imageReading.settings.missingCameraSignalConversionParameterOverwrite = ...
    rainSTORM_settings_cameraSignalConversion('iXon897');

% the image stack creation operations:
imageStack.creation.reading = imageReading;


backgroundRemoval.operationType = 'background removal';
backgroundRemoval.note = 'quasi-static fluorescent background removal';
backgroundRemoval.functionName='rainSTORM_backgroundRemoval';
backgroundRemoval.method = 'moving median';
backgroundRemoval.settings.frameRange=struct(...
    'name', 'frame range', 'value', 50, 'description', 'Frame range of the moving filter, i.e. width of the moving window: 2 * Frame range + 1');
backgroundRemoval.settings.stackBaseline=struct(...
    'name', 'srack baseline', 'value', 0, 'description', 'This baseline value is subtracted before the background removal, and added after that.');
backgroundRemoval.settingsLinking(1).target='stackBaseline';
backgroundRemoval.settingsLinking(1).sourceParameter='cameraSignalConversion.baseline_count';

% the image stack processing operations:
imageStack.processing.backgroundRemoval = backgroundRemoval;


%% operation of the "localization" data type
localizationData.note = 'AdOptIm group''s standard localization data analysis settings';

localization = rainSTORM_GUIsettings_localization.settings('LS Gaussian 2D linear Bg');

dataLoading.operationType='localization data loading';
dataLoading.note='tabular data loading';
dataLoading.functionName='pointillisticDataLoading';
dataLoading.method='';
dataLoading.settings = struct();
dataLoading.settings.missingCameraSignalConversionParameterOverwrite = imageReading.settings.missingCameraSignalConversionParameterOverwrite;
dataLoading.settingsLinking=struct([]);

% the localization data creation operations:
localizationData.creation.localization = localization;
localizationData.creation.loading = dataLoading;


precisionEstimation = rainSTORM_GUIsettings_precision.settings('Mortensen, Gaussian mask estimation');

filtering = rainSTORM_GUIsettings_filtering.settings('rainSTORM default');

driftCorrection=rainSTORM_GUIsettings_driftCorrection.settings('rainSTORM cross correlation');

astigmatic3D=rainSTORM_GUIsettings_astigmatic3D.settings('sigma squared error');

clusterization=rainSTORM_GUIsettings_clusterization.settings('DBSCAN');

locPixelization=rainSTORM_GUIsettings_pixelization.settings('Simple Histogram');
locVisualization=rainSTORM_GUIsettings_visualization.settings('percentile of non-zeros saturation');

% the localization data processing operations:
localizationData.processing.precisionEstimation = precisionEstimation;
localizationData.processing.filtering = filtering;
localizationData.processing.driftCorrection = driftCorrection;
localizationData.processing.astigmatic3D = astigmatic3D;
localizationData.processing.pixelization = locPixelization;
localizationData.processing.visualization = locVisualization;
localizationData.processing.clusterization = clusterization;

%% operation of the "concatenated" data type
concatenatedData.note = 'AdOptIm group''s standard concatenated/trajectory data analysis settings';

concatenation=rainSTORM_GUIsettings_concatenation.settings('branching trajectories');

% the localization data creation operations:
concatenatedData.creation.concatenation = concatenation;
concatenatedData.creation.loading = dataLoading;

trajPixelization=rainSTORM_GUIsettings_pixelization.settings('Simple Histogram');
trajVisualization=rainSTORM_GUIsettings_visualization.settings('percentile of non-zeros saturation');

% the concatenated data processing operations:
concatenatedData.processing.pixelization = trajPixelization;
concatenatedData.processing.visualization = trajVisualization;
concatenatedData.processing.clusterization = clusterization;


%% finalize and export the operations

operationSettings.imageStack = imageStack;
operationSettings.localizationData = localizationData;
operationSettings.concatenatedData = concatenatedData;

% get the path of this settings file creation function:
callerFunctionPath=fileparts(mfilename('fullpath'));

% create a full path fot the settings file exporting:
settingsFileFullName=fullfile(callerFunctionPath, settingsNameFile);

% export the settings file:
jsonManagement.export(operationSettings, settingsFileFullName);

end

