function ThunderSTORM_dataExport(directoryPath, originalDataName, pointillisticData_accepted, analysisParameters, varargin)

    [~, name, ~] = fileparts(originalDataName);
    
    infoFileName = [name, '-protocol.txt'];
    
    infoStructFileName = [name, '_info.json'];
    
    dataFileName = [name, '.csv'];

    infoText = createInfoText(analysisParameters);

    definitionFunction = @conversion_definitions_rainSTORM;
    cameraSignalConversion = analysisParameters.imageStackReading.metadata.cameraSignalConversion;
    [dataMatrix, headerList] = convertDataToExport(pointillisticData_accepted, fitting_method, measured_quantity, analysis, definitionFunction, cameraSignalConversion);
    
    pointillisticData_save.csv(directoryPath, dataFileName, headerList, dataMatrix);
    
    pointillisticData_save.infoStruct(directoryPath, infoStructFileName, analysisParameters);
    
    pointillisticData_save.infoText(directoryPath, infoFileName, infoText);

end

function infoText = createInfoText(analysisParameters)

% TODO: use the "PrettyPrint" option for the json text to be more human
% readable
% jsonencode(data, "PrettyPrint", true);
% it requires Matlab 2021 or above

infoText = sprintf('ThunderSTORM (unknown version, called via Matlab MIJ)\n\n');

infoText = [infoText, sprintf('Input:\n')];
inputStruct.title = imageStackReading.settings.dataFullFileName;
try
    inputText = jsonencode(inputStruct.title, 'PrettyPrint', true);
    % it requires Matlab 2021 or above
catch
    inputText = jsonencode(inputStruct.title);
end
infoText = [infoText, sprintf('%s\n', inputText)];


imageStackReading_operation = findOpration.creation(analysisParameters, 'imageStack', 'reading');
cameraSettings = struct();
if ~isempty(imageStackReading_operation)
    cameraSettings = imageStackReading_operation.metadata.cameraSettings.settings;
end
cameraSignalConversion = analysisParameters.sharedParameters.cameraSignalConversion;
cameraSettings_TS.offset = cameraSignalConversion.baseline_count;
cameraSettings_TS.pixelSize = cameraSignalConversion.pixelSize_nm;
if ~isempty(cameraSettings)
    electronsPerCount_withoutEMGAIN = cameraSettings.amplificationGain/cameraSignalConversion.countsPerElectron;
    cameraSettings_TS.photons2ADU = electronsPerCount_withoutEMGAIN;
    cameraSettings_TS.isEmGain = cameraSettings.emMultiplication;
    cameraSettings_TS.gain = cameraSettings.amplificationGain;
else
    % add parameters with gain=1, the photoelectron <-> ADU conversion will
    % be right....
    cameraSettings_TS.photons2ADU = 1/cameraSignalConversion.countsPerElectron;
    cameraSettings_TS.isEmGain = False; % it might be needed for the noise model, so it might not be correct!!!!
    cameraSettings_TS.gain = 1;
end

infoText = [infoText, sprintf('Camera settings:\n')];
try
    cameraSettingsText = jsonencode(cameraSettings_TS, 'PrettyPrint', true);
    % it requires Matlab 2021 or above
catch
    cameraSettingsText = jsonencode(cameraSettings_TS);
end
infoText = [infoText, sprintf('%s\n', cameraSettingsText)];

localization_operation = findOpration.creation(analysisParameters, 'localizationData', 'localization');
localizationSettings = localization_operation.settings;

infoText = [infoText, sprintf('Analysis:\n')];
if isfield(localizationSettings, 'imageFiltering')
    try
        imageFilteringText = jsonencode(localization.settings.imageFiltering, 'PrettyPrint', true);
        % it requires Matlab 2021 or above
    catch
        imageFilteringText = jsonencode(localization.settings.imageFiltering);
    end
else
    imageFilteringText = '{The saved information misses the "image filtering" part. The data might have not been processed with the ThunderSTORM algorithm.}';
end
infoText = [infoText, sprintf('%s\n', imageFilteringText)];
if isfield(localizationSettings, 'approximateLocalizationOfMolecules')
    try
        approximateLocalizationOfMoleculesText = jsonencode(localization.settings.approximateLocalizationOfMolecules, 'PrettyPrint', true);
        % it requires Matlab 2021 or above
    catch
        approximateLocalizationOfMoleculesText = jsonencode(localization.settings.approximateLocalizationOfMolecules);
    end
else
    approximateLocalizationOfMoleculesText = '{The saved information misses the "approximate localization of molecules" part. The data might have not been processed with the ThunderSTORM algorithm.}';
end
infoText = [infoText, sprintf('%s\n', approximateLocalizationOfMoleculesText)];
if isfield(localizationSettings, 'subPixelLocalizationOfMolecules')
    try
        subPixelLocalizationOfMoleculesText = jsonencode(localization.settings.subPixelLocalizationOfMolecules, 'PrettyPrint', true);
        % it requires Matlab 2021 or above
    catch
        subPixelLocalizationOfMoleculesText = jsonencode(localization.settings.subPixelLocalizationOfMolecules);
    end
else
    subPixelLocalizationOfMoleculesText = '{The saved information misses the "subpixel localization of molecules" part. The data might have not been processed with the ThunderSTORM algorithm.}';
end
infoText = [infoText, sprintf('%s\n', subPixelLocalizationOfMoleculesText)];

% it seems not to be saved:
% localization.settings.visualizationOfTheResults

% save empty data for the post processing for simplicity (ThunderSTORM also doesn't save anything without any postprocessing)
infoText = [infoText, sprintf('Post-processing:\n')];
try
    postprocessingText = jsonencode({'this data is not saved'}, 'PrettyPrint', true);
    % it requires Matlab 2021 or above
catch
    postprocessingText = jsonencode({'this data is not saved'});
end
infoText = [infoText, sprintf('%s\n', postprocessingText)];


end
