classdef ThunderSTORM_localization
    
    methods (Static)

        function [accepted, rejected, metadata, sharedParameters] = localize(imageStack, localizationSettings)

            % decide where should it be:
            %MIJ.createImage(imageStack)

            % TODO. finish properly
            metadata = struct(...
                            'type', 'localizations',...
                            'method', 'least squares',...
                            'measuredQuantity', 'conventional'...
                            );
            
            runAnalysisString = ThunderSTORM_createSettingsString(localizationSettings);
            % TODO: there is some problem with the runAnalysisString string, the thunderstorm does not run, using fixed tettings instead
            %MIJ.run('Run analysis', runAnalysisString);
            % example:
            % MIJ.run('Run analysis', 'filter=[Wavelet filter (B-Spline)] scale=2.0 order=3 detector=[Local maximum] connectivity=8-neighbourhood threshold=std(Wave.F1) estimator=[PSF: Integrated Gaussian] sigma=1.6 fitradius=3 method=[Weighted Least squares] full_image_fitting=false mfaenabled=false renderer=[Averaged shifted histograms] magnification=5.0 colorizez=false threed=false shifts=2 repaint=50');
            MIJ.run('Run analysis', 'filter=[Wavelet filter (B-Spline)] scale=2.0 order=3 detector=[Local maximum] connectivity=8-neighbourhood threshold=std(Wave.F1) estimator=[PSF: Integrated Gaussian] sigma=1.6 fitradius=3 method=[Weighted Least squares] full_image_fitting=false mfaenabled=true renderer=[Averaged shifted histograms] magnification=5.0 colorizez=false threed=false shifts=2 repaint=50');

            MIJ.run("Show results table", "action=duplicates distformula=uncertainty");

            
            MIJ.run('Export results', 'filepath=ThunderSTORM_results_temp.csv fileformat=[CSV (comma separated)] sigma=true intensity=true chi2=true offset=true saveprotocol=true x=true y=true bkgstd=true id=false uncertainty=true frame=true');
            fileName_csv = 'ThunderSTORM_results_temp.csv';
            fileName_protocol = 'ThunderSTORM_results_temp-protocol.txt';
            
            csv_dataConvention = 'ThunderSTORM';
            accepted = pointillisticData_load.csv_noInfo(fileName_csv, csv_dataConvention);
            fileID = fopen(fileName_protocol, 'rt');
            metadata.protocol = fscanf(fileID, '%c');
            fclose(fileID);
            delete(fileName_csv)
            delete(fileName_protocol)

            rejected=pointillisticData_fieldManagement.createEmptyData(accepted);

            metadata.convention = struct();
            metadata.convention.name = 'rainSTORM';
            metadata.convention.algorithm = method;
            metadata.convention.analyses = {};
            
            metadata.ROI.x=[0, size(imageStack, 1)];
            metadata.ROI.y=[0, size(imageStack, 2)];
            metadata.ROI.unit='camera pixel length';

            metadata.frameRange=[0, size(imageStack, 3)];
            
            sharedParameters.frameRange = metadata.frameRange;
            sharedParameters.ROI = metadata.ROI;
            sharedParameters.convention = metadata.convention;
            
            % TODO: could not find a way to extreact the ThunderSTORm
            % version
            % it is impossible to get the title of the about page, or close
            % it with macro command....
            %MIJ.run("About ThunderSTORM...");
            %aboutPageTitle = MIJ.getTitle();

        end

    end
    
end
