function [imageStack, originalMetadata, omeMetadata, metadata, sharedParameters] = TunderSTORM_imageStackReading(imageStackReadingSettings)

    [imageStack, originalMetadata, omeMetadata, metadata, sharedParameters] = imageStackReading.read(imageStackReadingSettings);

    MIJ.createImage(imageStack);
    
    cameraSetup(metadata, sharedParameters);

end

function cameraSetup(metadata, sharedParameters)

    cameraSettings = metadata.cameraSettings;
    cameraSignalConversion = sharedParameters.cameraSignalConversion;


    amplificationGain = cameraSettings.settings.amplificationGain;
    emMultiplication = cameraSettings.settings.emMultiplication;
    countsPerElectron = cameraSignalConversion.countsPerElectron;

    camera.offset = imageStackReadingParameters.metadata.cameraSignalConversion.baseline_count;
    if emMultiplication
        camera.isemgain = 'true';
        camera.gainem = amplificationGain;
        camera.photons2adu = 1 / (countsPerElectron / amplificationGain);
    else
        camera.isemgain = 'false';
        camera.gainem = 0;
        camera.photons2adu = 1 / (countsPerElectron);
    end
    camera.pixelsize = cameraSignalConversion.pixelSize_nm;

    cameraSetupString = ThunderSTORM_createSettingsString(camera);
    MIJ.run('Camera setup', cameraSetupString);
    %MIJ.run("Camera setup", "offset=33.0 isemgain=true photons2adu=66.0 gainem=111.0 pixelsize=99.0");
    pause(0.1)
end

% code in ThunderSTORM for the photon/ADU conversion:
%     public static double digitalCountsToPhotons(double intensity) {
%         if(getIsEmGain()) {
%             return intensity * getPhotons2ADU() / getQuantumEfficiency() / getGain();
%         } else {
%             return intensity * getPhotons2ADU() / getQuantumEfficiency();
%         }
%     }
% 
%     public static double photonsToDigitalCounts(double photons) {
%         if(getIsEmGain()) {
%             return photons * getGain() / getPhotons2ADU() * getQuantumEfficiency();
%         } else {
%             return photons / getPhotons2ADU() * getQuantumEfficiency();
%         }
%     }
