function varargout = rainSTORM(varargin)
% RAINSTORM MATLAB code for rainSTORM.fig
%      RAINSTORM, by itself, creates a new RAINSTORM or raises the existing
%      singleton*.
%
%      H = RAINSTORM returns the handle to a new RAINSTORM or the handle to
%      the existing singleton*.
%
%      RAINSTORM('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RAINSTORM.M with the given input arguments.
%
%      RAINSTORM('Property','Value',...) creates a new RAINSTORM or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before rainSTORM_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to rainSTORM_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help rainSTORM

% Last Modified by GUIDE v2.5 05-Jan-2026 13:36:09

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @rainSTORM_OpeningFcn, ...
    'gui_OutputFcn',  @rainSTORM_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before rainSTORM is made visible.
function rainSTORM_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to rainSTORM (see VARARGIN)

% Choose default command line output for rainSTORM
handles.output = hObject;

% path of the evaluation codes relative to the script location:
codePath='./';

% adding the directories containing the required functions
run(fullfile(codePath, 'addSubfoldersToPath.m'));

rainSTORM_GUI_path = fileparts(fullfile(mfilename('fullpath')));
last_image_dir_filename = fullfile(rainSTORM_GUI_path, 'last_image_dir.txt');
if exist(last_image_dir_filename, 'file')
    handles.last_image_dir = fileread(last_image_dir_filename);
else
    handles.last_image_dir = pwd;
end

handles.analysisObjects = analysisClass.empty;

handles.dataset_GUI_settings = struct([]);

handles.Dataset_Select_Radiobutton_h = matlab.ui.control.UIControl.empty;

defaultSettings_file = 'settings/operationSettings_rainSTORM_GUI_defaults.json';
[operationSettingsPath, settingsFile_name, settingsFile_ext] = fileparts(defaultSettings_file);
settingsFile = [settingsFile_name, settingsFile_ext];
importedDefaultSettings = loadOperations(operationSettingsPath, settingsFile);

% default localization algorithm:
locAlgoName = importedDefaultSettings.localizationData.creation.localization.method;
locSettings = importedDefaultSettings.localizationData.creation.localization.settings;

% keep only the relevant settings:
handles.defaultOperations.imageStack = rainSTORM_GUI_settings_extract.data(importedDefaultSettings.imageStack);
handles.defaultOperations.localizationData.creation.localization = rainSTORM_GUI_settings_extract.operation(importedDefaultSettings.localizationData.creation.localization);

handles.default_GUI_settings = struct();

handles.default_GUI_settings.imageStackName = {'', ''};
handles.default_GUI_settings.datasetName = '';

handles.default_GUI_settings.processingMethod = struct();
handles.default_GUI_settings.processingMethod.cameraCalibrationFile = 'settings/cameraCalibration_AdOptIm.json';
handles.default_GUI_settings.processingMethod.additionalMagnification = 1.0;
handles.default_GUI_settings.processingMethod.locAlgoName = locAlgoName;
handles.default_GUI_settings.processingMethod.backgroundRemoval = struct('frameRange', 50, 'isRequested', false);
handles.default_GUI_settings.processingMethod.cameraSignalConversionOverwrite = struct(...
    'parameters', rainSTORM_settings_cameraSignalConversion('iXon897'),...
    'isRequested', false);

handles.default_GUI_settings.locAlgoSettings = struct(...
    'algorithmName', locAlgoName,...
    'settings', locSettings);

handles.default_GUI_settings.optoff_info = struct([]);

% initialize the "dataset_GUI_settings" as empty
handles.dataset_GUI_settings = struct([]);

updateGUI(hObject, eventdata, handles)

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes rainSTORM wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = rainSTORM_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

%%
% USER DEFINED FUNCTIONS

function updateGUI(hObject, eventdata, handles)
% Updates the GUI according to the chosen dataset.

    if isempty(handles.dataset_GUI_settings)
        GUI_settings = handles.default_GUI_settings;
    else
        selected_channel = get_selected_dataset(handles);
        GUI_settings = handles.dataset_GUI_settings(selected_channel);
    end

    datasetName = GUI_settings.datasetName;

    fullFileName = GUI_settings.imageStackName{1};
    [filePath, fileName, fileExtension] = fileparts(fullFileName);
    set(handles.selectedImage_text,'String',fullFileName,'TooltipString',['path: ' filePath, newline, 'name: ', [fileName, fileExtension]]);

    set_Algo_Settings_panel(hObject, eventdata, handles);
    set_Processing_Method_panel(hObject, eventdata, handles, GUI_settings);
	set_Optical_Offset_Calibration_Panel(hObject, eventdata, handles, GUI_settings);
    
    set(handles.Dataset_name, 'String', datasetName);

    
function selected_dataset = get_selected_dataset(handles)

if ~isfield(handles,'Dataset_Select_Radiobutton_h')
    selected_dataset=1;
    return
end
for selected_dataset=1:length(handles.Dataset_Select_Radiobutton_h)
    if get(handles.Dataset_Select_Radiobutton_h(selected_dataset),'Value')==1
        break
    end
end

% until there is no data loaded, let it be:
if isempty(selected_dataset)
   selected_dataset = 1; 
end


function rearrange_radiobuttons(hObject, eventdata, handles)

num_of_channels=length(handles.Dataset_Select_Radiobutton_h);
panel_pos = get(handles.Dataset_Select_Button_Group,'Position');
for idx_radiobutton=1:num_of_channels
    new_y_position = panel_pos(4)-45-(idx_radiobutton-1)*30;
    old_position = get(handles.Dataset_Select_Radiobutton_h(idx_radiobutton), 'Position');
    new_position = old_position;
    new_position(2) = new_y_position;
    set(handles.Dataset_Select_Radiobutton_h(idx_radiobutton),...
        'Position', new_position...
        );
end

guidata(hObject, handles);


function set_Algo_Settings_value(hObject, eventdata, algo_param_name, idx, type, style)

switch style
    case 'popup'
        contents = get(hObject,'String'); 
        data_to_write = contents{get(hObject,'Value')};
    otherwise
        data_to_write = get(hObject,'String');
end

switch type
    case 'number'
        data_to_write = str2double(data_to_write);
end

handles = guidata(gcbo);
selected_dataset = get_selected_dataset(handles);

switch style
    case 'popup'
        handles.dataset_GUI_settings(selected_dataset).locAlgoSettings.settings.(algo_param_name{1}).value = data_to_write;
    otherwise
        handles.dataset_GUI_settings(selected_dataset).locAlgoSettings.settings.(algo_param_name{1}).value(idx) = data_to_write;
end        

guidata(hObject, handles);


function set_Optical_Offset_Calibration_Panel(hObject, eventdata, handles, GUI_settings)

if ~isempty(GUI_settings.optoff_info)
    fullfilename = GUI_settings.optoff_info.fullfilename;
    set(handles.Select_Calibration_File,'String',fullfilename,'TooltipString',fullfilename);
    set(handles.popupmenu_Optical_Offset_Calibration,...
        'String',[{GUI_settings.optoff_info.optoff.Name}';'None'],...
        'Value',GUI_settings.optoff_info.selected);
else
    set(handles.Select_Calibration_File,'String',' ','TooltipString','Calibration file is not specified.');
    set(handles.popupmenu_Optical_Offset_Calibration,...
        'String','None',...
        'Value',1);
end

guidata(hObject, handles);

function set_Processing_Method_panel(hObject, eventdata, handles, GUI_settings)

cameraCalibrationFile_full = GUI_settings.processingMethod.cameraCalibrationFile;
[filePath, fileName, fileExtension] = fileparts(cameraCalibrationFile_full);
cameraCalibrationFile = [fileName, fileExtension];
set(handles.chosen_camera_properties_file_text, 'String', cameraCalibrationFile);
set(handles.chosen_camera_properties_file_text, 'Tooltip', ['path: ', filePath, newline, 'name: ', cameraCalibrationFile]);

additionalMagnification = GUI_settings.processingMethod.additionalMagnification;
set(handles.additional_magnification_edit , 'String', num2str(additionalMagnification));

setCameraSignalConversionParameters(hObject, eventdata, handles, GUI_settings)
isRequested = GUI_settings.processingMethod.cameraSignalConversionOverwrite.isRequested;
set(handles.manual_camera_parameter_checkbox, 'Value',  isRequested);


locAlgoList = cellstr(get(handles.Select_Image_Processing_Algo,'String'));
locAlgoName = GUI_settings.processingMethod.locAlgoName;
algoIndex = find(strcmp(locAlgoList, locAlgoName));
if ~isempty(algoIndex)
    set(handles.Select_Image_Processing_Algo, 'Value',  algoIndex);
else
    warning('Could not find the localization algorithm ("%s") among the rainSTORM algorithm list.', locAlgoName );
end

frameRange = GUI_settings.processingMethod.backgroundRemoval.frameRange;
isRequested = GUI_settings.processingMethod.backgroundRemoval.isRequested;
set(handles.background_removal_checkbox, 'Value',  isRequested);
set(handles.background_removal_edit, 'String', num2str(frameRange));

guidata(hObject, handles);

function set_Algo_Settings_panel(hObject, eventdata, handles, GUI_settings)

% Clean up
h = get(handles.Algo_Settings_Panel,'Children');
h(h == handles.Algo_Settings_slider) = [];
delete(h);

handles.Algo_Settings_handles=[];

if isempty(handles.dataset_GUI_settings)
    algo_gui_params = handles.default_GUI_settings.locAlgoSettings.settings;
else
    selected_dataset = get_selected_dataset(handles);
    algo_gui_params = handles.dataset_GUI_settings(selected_dataset).locAlgoSettings.settings;
end

panel_pos = get(handles.Algo_Settings_Panel,'Position');
panel_unit = get(handles.Algo_Settings_Panel,'Unit');

panel_line_space = 30;
panel_first_line_pos = panel_pos(4)-panel_line_space/2;
panel_max_lines = floor(panel_pos(4) / panel_line_space)-1;
algo_param_names = fieldnames(algo_gui_params);
num_of_params = length(algo_param_names);

for idx_param = 1:num_of_params
    if idx_param > panel_max_lines
        visibility='off';
    else
        visibility='on';
    end
    % descriptions
    if isfield(algo_gui_params.(algo_param_names{idx_param}), 'unit')
        unitString = algo_gui_params.(algo_param_names{idx_param}).unit;
        fieldNameString = sprintf('%s [%s]', algo_gui_params.(algo_param_names{idx_param}).name, unitString);
        tooltipString = sprintf('%s [%s]', algo_gui_params.(algo_param_names{idx_param}).description, unitString);
    else
        fieldNameString = sprintf('%s', algo_gui_params.(algo_param_names{idx_param}).name);
        tooltipString = sprintf('%s', algo_gui_params.(algo_param_names{idx_param}).description);
    end

    handles.Algo_Settings_handles(idx_param).h(1) = uicontrol(...
        handles.Algo_Settings_Panel,...
        'Style','text',...
        'String',fieldNameString,...
        'HorizontalAlignment','left',...
        'BackgroundColor',[0.8 0.8 0.8],...
        'TooltipString',tooltipString,...
        'Units',panel_unit,...
        'Visible',visibility,...
        'Position', [10 panel_first_line_pos-idx_param*panel_line_space panel_pos(3)-150 20]);
    
    % input uicontrols
    
    %if ~isfield( algo_gui_params.(algo_param_names{idx_param}), 'style' )
    %    algo_gui_params.(algo_param_names{idx_param}).style = 'edit';
    %end
    
    
    switch algo_gui_params.(algo_param_names{idx_param}).style
        case 'popup'
            nInputs = 1;
        otherwise
            nInputs = length(algo_gui_params.(algo_param_names{idx_param}).value);
    end
    
    for i = 1:nInputs
        switch algo_gui_params.(algo_param_names{idx_param}).style
            case 'popup'
                string = algo_gui_params.(algo_param_names{idx_param}).options;
                for ix = 1:length(string)
                    if strcmp( string{ix}, algo_gui_params.(algo_param_names{idx_param}).value )
                        value = ix;
                        break
                    end
                end
                position =  [panel_pos(3)-140  panel_first_line_pos-idx_param*panel_line_space 110 20];
            otherwise
                string = algo_gui_params.(algo_param_names{idx_param}).value(i);
                value = 1;
                position =  [panel_pos(3)-80-(nInputs-i)*60  panel_first_line_pos-idx_param*panel_line_space 50 20];
        end
        handles.Algo_Settings_handles(idx_param).h(1+i) = uicontrol(...
            handles.Algo_Settings_Panel,...
            'Callback',{@set_Algo_Settings_value, algo_param_names(idx_param), i, algo_gui_params.(algo_param_names{idx_param}).type, algo_gui_params.(algo_param_names{idx_param}).style},...
            'Style', algo_gui_params.(algo_param_names{idx_param}).style,...
            'String',string,...
            'Value', value,...
            'HorizontalAlignment','center',...
            'Units',panel_unit,...
            'Visible',visibility,...
            'Position', position);
    end
        
end

if num_of_params<=panel_max_lines
    set(handles.Algo_Settings_slider,...
        'Visible','off');
else
    set(handles.Algo_Settings_slider,...
        'Visible','on',...
        'Min',0,'Max',(num_of_params-panel_max_lines),...
        'Value',(num_of_params-panel_max_lines),...
        'Callback',{@slider_callback1, handles, panel_first_line_pos, panel_max_lines, panel_line_space},...
        'SliderStep',[1 1]./(num_of_params-panel_max_lines));
end

guidata(hObject, handles);

function processDataset(datasetIndex, handles)
% This function is not a "callback" of a certain GUI elements. Rather its
% code is used the the "Process Selected" and "Process All" button
% callbacks.

if isempty(handles.analysisObjects)
   warning('Open an image stack before processing!')
    return
end

analysisObject = handles.analysisObjects(datasetIndex);

cameraCalibrationFullFile = handles.dataset_GUI_settings(datasetIndex).processingMethod.cameraCalibrationFile;
analysisObject.loadCameraCalibration(cameraCalibrationFullFile);

additionalMagnification = handles.dataset_GUI_settings(datasetIndex).processingMethod.additionalMagnification;
analysisObject.setAdditionalMagnification(additionalMagnification);
% update camera signal conversion parameters for the missing parameter overwrite during the image stack import :
[~, definedCameraSignalConversion] = readCameraSignalConversionParameters(handles);
analysisObject.setCameraSignaConversionParameters(definedCameraSignalConversion);

imageStackFullName = handles.dataset_GUI_settings(datasetIndex).imageStackName{1};
imageSTackType = handles.dataset_GUI_settings(datasetIndex).imageStackName{2};
analysisObject.imageStackImport(imageStackFullName, imageSTackType);

% make a missing camera signal conversion parameters overwrite here:
if handles.dataset_GUI_settings(datasetIndex).processingMethod.cameraSignalConversionOverwrite.isRequested
    extractedCameraSignalConversion = analysisObject.imageStackData.analysisParameters.sharedParameters.cameraSignalConversion;
    missingOnlyBoolean = false;
    finalParameters = imageStack_getConversionFactors.overwriteParameters(extractedCameraSignalConversion, definedCameraSignalConversion, missingOnlyBoolean);
    analysisObject.imageStackData.analysisParameters.sharedParameters.cameraSignalConversion = finalParameters;
end

backgroundRemovalFlag = handles.dataset_GUI_settings(datasetIndex).processingMethod.backgroundRemoval.isRequested;

if backgroundRemovalFlag
   
    % set up the "background removal" operation
    backgroundSubtraction.type = 'background removal';
    backgroundSubtraction.note = 'quasi-static fluorescent background removal';
    backgroundSubtraction.functionName='rainSTORM_backgroundRemoval';
    backgroundSubtraction.method = 'moving median';
    backgroundSubtraction.settings.frameRange=handles.dataset_GUI_settings(datasetIndex).processingMethod.backgroundRemoval.frameRange;
    backgroundSubtraction.settings.stackBaseline=[];
    backgroundSubtraction.settingsLinking(1).target='stackBaseline';
    backgroundSubtraction.settingsLinking(1).sourceParameter='cameraSignalConversion.baseline_count';
    
    analysisObject.operations.imageStack.processing.backgroundSubtraction = backgroundSubtraction;
    analysisObject.removeBackground()
    
    disp('Median background removal was applied.')
    
end


% set up the "localization" operation
localizationData.dataType = 'localizationData';
localizationData.note = 'rainSTORM localization data';
algorithmName = handles.dataset_GUI_settings(datasetIndex).locAlgoSettings.algorithmName;
localizationData.creation.localization=rainSTORM_GUIsettings_localization.settings(algorithmName);
stripped_GUI_settings = rainSTORM_GUI_settings_extract.operation(handles.dataset_GUI_settings(datasetIndex).locAlgoSettings);
localizationData.creation.localization.settings=stripped_GUI_settings.settings;

analysisObject.operations.localizationData = localizationData; 
analysisObject.localize();

% Do offset correction if it is specified.
% if isfield(ch_data, 'optoff_info') && ~isempty(ch_data.optoff_info)
%     if ch_data.optoff_info.selected <= length(ch_data.optoff_info.optoff)
%         settings_optoff.TFORM = ch_data.optoff_info.optoff(ch_data.optoff_info.selected).TFORM;
%         SupResParams = rainSTORM_unOffset(SupResParams,settings_optoff);
%         disp('Offset Correction was applied.')
%     end
% end

flagSum = get(handles.Display_Sum_Image, 'Value');
if flagSum
    prevSF = str2double(get(handles.prevSF_edit, 'String'));
    [sumImageFigure, ~] = analysisObject.createSumImage(prevSF);
    figure(sumImageFigure)
end

% it worth to be considered to place a checkbox for it...
flagMemorySaving = true;
if flagMemorySaving
    
    analysisObject.imageStackData.imageStack=[];
    analysisObject.imageStackData.backgroundStack=[];
    
end

flagAutosave = get(handles.autosave_checkbox, 'Value');
if flagAutosave

    %exportPath = handles.last_image_dir;
    exportPath = analysisObject.datasetPath;
    
    saveDataset(datasetIndex, exportPath, handles)
    
end


function saveDataset(datasetIndex, exportPath, handles)

analysisObject = handles.analysisObjects(datasetIndex);

if isempty(exportPath)
    return
end

% dataIndex should always be 1 when using the rainSTORM GUI (the localization part, not the Reviewer)
dataIndex = 1;

subfolderFlag = get(handles.save_into_subfolder_checkbox, 'Value');

convention = 'rainSTORM';

% save tha data with the original name, without numbering
exportName = analysisObject.datasetName;

analysisObject.dataExport(dataIndex, exportPath, exportName, subfolderFlag, convention);

prevSF = str2double(get(handles.prevSF_edit, 'String'));
analysisObject.saveSumImage(dataIndex, prevSF, exportPath, exportName, subfolderFlag);


function slider_callback1(hObject, eventdata, handles, panel_first_line_pos, panel_max_lines, panel_line_space)

value = get(hObject,'Value');

num_of_params = length(handles.Algo_Settings_handles);
for idx_setting = 1:num_of_params
    for idx_component = 1:length(handles.Algo_Settings_handles(idx_setting).h)
        h = handles.Algo_Settings_handles(idx_setting).h(idx_component);
        pos = get(h,'Position');
        pos_new = panel_first_line_pos - idx_setting * panel_line_space + (num_of_params-panel_max_lines - value) * panel_line_space;
        pos(2) = pos_new;
        if (pos_new < panel_first_line_pos - panel_max_lines * panel_line_space) || (pos_new > panel_first_line_pos - panel_line_space)
            visibility='off';
        else
            visibility='on';
        end
        set(h,...
            'Position',pos,...
            'Visible',visibility);
    end
end

guidata(hObject, handles);

function setCameraSignalConversionParameters(hObject, eventdata, handles, GUI_settings)

cameraSignalConversion = GUI_settings.processingMethod.cameraSignalConversionOverwrite.parameters;

pixel_size_edit_obj = findobj('Tag', 'pixel_size_edit');
pixel_size_text_obj = findobj('Tag', 'pixel_size_text');

exposure_edit_obj = findobj('Tag', 'exposure_edit');
exposure_text_obj = findobj('Tag', 'exposure_text');

frame_interval_edit_obj = findobj('Tag', 'frame_interval_edit');
frame_interval_text_obj = findobj('Tag', 'frame_interval_text');

counts_per_photon_edit_obj = findobj('Tag', 'counts_per_photon_edit');
counts_per_photon_text_obj = findobj('Tag', 'counts_per_photon_text');

counts_per_electron_edit_obj = findobj('Tag', 'counts_per_electron_edit');
counts_per_electron_text_obj = findobj('Tag', 'counts_per_electron_text');

baseline_edit_obj = findobj('Tag', 'baseline_edit');
baseline_text_obj = findobj('Tag', 'baseline_text');

pixelSize_value = cameraSignalConversion.pixelSize.value;
pixelSize_fieldname = sprintf('%s [%s]:', cameraSignalConversion.pixelSize.name, cameraSignalConversion.pixelSize.unit);
pixelSize_tooltip = sprintf('%s [%s]:', cameraSignalConversion.pixelSize.description, cameraSignalConversion.pixelSize.unit);
set(pixel_size_text_obj, 'String', pixelSize_fieldname);
set(pixel_size_text_obj, 'Tooltip', pixelSize_tooltip);
set(pixel_size_edit_obj, 'String', num2str(pixelSize_value));

exposureTime_value = cameraSignalConversion.exposureTime.value;
exposureTime_fieldname = sprintf('%s [%s]:', cameraSignalConversion.exposureTime.name, cameraSignalConversion.exposureTime.unit);
exposureTime_tooltip = sprintf('%s [%s]:', cameraSignalConversion.exposureTime.description, cameraSignalConversion.exposureTime.unit);
set(exposure_text_obj, 'String', exposureTime_fieldname);
set(exposure_text_obj, 'Tooltip', exposureTime_tooltip);
set(exposure_edit_obj, 'String', num2str(exposureTime_value));

frameInterval_value = cameraSignalConversion.frameInterval.value;
frameInterval_fieldname = sprintf('%s [%s]:', cameraSignalConversion.frameInterval.name, cameraSignalConversion.frameInterval.unit);
frameInterval_tooltip = sprintf('%s [%s]:', cameraSignalConversion.frameInterval.description, cameraSignalConversion.frameInterval.unit);
set(frame_interval_text_obj, 'String', frameInterval_fieldname);
set(frame_interval_text_obj, 'Tooltip', frameInterval_tooltip);
set(frame_interval_edit_obj, 'String', num2str(frameInterval_value));

countsPerPhoton_value = cameraSignalConversion.countsPerPhoton.value;
countsPerPhoton_fieldname = cameraSignalConversion.countsPerPhoton.name;
countsPerPhoton_tooltip = cameraSignalConversion.countsPerPhoton.description;
set(counts_per_photon_text_obj, 'String', countsPerPhoton_fieldname);
set(counts_per_photon_text_obj, 'Tooltip', countsPerPhoton_tooltip);
set(counts_per_photon_edit_obj, 'String', num2str(countsPerPhoton_value));

countsPerElectron_value = cameraSignalConversion.countsPerElectron.value;
countsPerElectron_fieldname = cameraSignalConversion.countsPerElectron.name;
countsPerElectron_tooltip = cameraSignalConversion.countsPerElectron.description;
set(counts_per_electron_text_obj, 'String', countsPerElectron_fieldname);
set(counts_per_electron_text_obj, 'Tooltip', countsPerElectron_tooltip);
set(counts_per_electron_edit_obj, 'String', num2str(countsPerElectron_value));

baseline_value = cameraSignalConversion.baseline.value;
baseline_fieldname = sprintf('%s [%s]:', cameraSignalConversion.baseline.name, cameraSignalConversion.baseline.unit);
baseline_tooltip = sprintf('%s [%s]:', cameraSignalConversion.baseline.description, cameraSignalConversion.baseline.unit);
set(baseline_text_obj, 'String', baseline_fieldname);
set(baseline_text_obj, 'Tooltip', baseline_tooltip);
set(baseline_edit_obj, 'String', num2str(baseline_value));


guidata(hObject, handles);


function [handles, cameraSignalConversion] = readCameraSignalConversionParameters(handles)
    % Reads the unmodified or user modified camera signal conversion
    % parameters from thr GUI.
    % Beware! The units of these quantities should not change as no unit conversion is handled here!
    

    if isempty(handles.dataset_GUI_settings)
        GUI_settings = handles.default_GUI_settings;
    else
        selected_channel = get_selected_dataset(handles);
        GUI_settings = handles.dataset_GUI_settings(selected_channel);
    end
    
cameraSignalConversion = GUI_settings.processingMethod.cameraSignalConversionOverwrite.parameters;
    
pixel_size_edit_obj = findobj('Tag', 'pixel_size_edit');
exposure_edit_obj = findobj('Tag', 'exposure_edit');
frame_interval_edit_obj = findobj('Tag', 'frame_interval_edit');
counts_per_photon_edit_obj = findobj('Tag', 'counts_per_photon_edit');
counts_per_electron_edit_obj = findobj('Tag', 'counts_per_electron_edit');
baseline_edit_obj = findobj('Tag', 'baseline_edit');

pixelSize_value = str2double(get(pixel_size_edit_obj, 'String'));
cameraSignalConversion.pixelSize.value = pixelSize_value;

exposureTime_value = str2double(get(exposure_edit_obj, 'String'));
cameraSignalConversion.exposureTime.value = exposureTime_value;

frameInterval_value = str2double(get(frame_interval_edit_obj, 'String'));
cameraSignalConversion.frameInterval.value = frameInterval_value;

countsPerPhoton_value = str2double(get(counts_per_photon_edit_obj, 'String'));
cameraSignalConversion.countsPerPhoton.value = countsPerPhoton_value;

countsPerElectron_value = str2double(get(counts_per_electron_edit_obj, 'String'));
cameraSignalConversion.countsPerElectron.value = countsPerElectron_value;

baseline_value = str2double(get(baseline_edit_obj, 'String'));
cameraSignalConversion.baseline.value = baseline_value;

% update with the read values
GUI_settings.processingMethod.cameraSignalConversionOverwrite.parameters = cameraSignalConversion;
    if isempty(handles.dataset_GUI_settings)
        handles.default_GUI_settings = GUI_settings;
    else
        selected_channel = get_selected_dataset(handles);
        handles.dataset_GUI_settings(selected_channel) = GUI_settings;
    end
    
%% MATLAB DEFINED GUI OBJECT FUNCTIONS

% --- Executes on button press in Select_Image_Button.
function Select_Image_Button_Callback(hObject, eventdata, handles)
% hObject    handle to Select_Image_Button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[imageFileFullNames, imageType]=imageStack_selection.multipleStacks(handles.last_image_dir);

if isempty(imageFileFullNames)
   return 
end

previousDatasetNumber = numel(handles.analysisObjects);
importedDataNumber = numel(imageFileFullNames);
for idxFile = 1:importedDataNumber
    
    datasetIndex = previousDatasetNumber + idxFile;

    analysisObject = analysisClass();
    analysisObject.operations = handles.defaultOperations;
    
    handles.analysisObjects(datasetIndex) = analysisObject;

    if isempty(handles.dataset_GUI_settings)
        handles.dataset_GUI_settings = handles.default_GUI_settings;
    else
        handles.dataset_GUI_settings(datasetIndex) = handles.dataset_GUI_settings(end);
    end
    handles.dataset_GUI_settings(datasetIndex).imageStackName = {imageFileFullNames{idxFile}, imageType};
    % the analysis object does not yet have a datasetname, but that would
    % be the correct solution
    [~, datasetName, ~] = fileparts(imageFileFullNames{idxFile});
    %datasetName = handles.analysisObjects(datasetIndex).datasetName;
    handles.dataset_GUI_settings(datasetIndex).datasetName = datasetName;
    
    handles.Dataset_Select_Radiobutton_h(datasetIndex) =...
    Add_dataset_radio_button(hObject, eventdata, handles, datasetName);

end

% switch to the first of newly added files:
set(handles.Dataset_Select_Radiobutton_h(previousDatasetNumber+1),'Value',1);

set(handles.Dataset_name, 'Enable', 'on')

updateGUI(hObject, eventdata, handles);

handles.last_image_dir = fileparts(imageFileFullNames{end});
rainSTORM_GUI_path = fileparts(fullfile(mfilename('fullpath')));
fileID = fopen(fullfile(rainSTORM_GUI_path, 'last_image_dir.txt'),'w+');
fprintf(fileID,'%s\n',handles.last_image_dir);
fclose(fileID);

guidata(hObject, handles);


% --- Executes on button press in Add_channel.
function h = Add_dataset_radio_button(hObject, eventdata, handles, datasetName)
% hObject    handle to Add_channel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

num_of_datasets = numel(handles.Dataset_Select_Radiobutton_h);

panel_pos = get(handles.Dataset_Select_Button_Group,'Position');
panel_unit = get(handles.Dataset_Select_Button_Group,'Unit');
h = uicontrol(...
    handles.Dataset_Select_Button_Group,...
    'BackgroundColor',[0.8 0.8 0.8],...
    'Style','radiobutton',...
    'String', datasetName,...
    'Tooltip', datasetName,...
    'HorizontalAlignment','left',...
    'Units',panel_unit,...
    'Position', [20 panel_pos(4)-45-num_of_datasets*30 panel_pos(3)-40 20]);

guidata(hObject, handles);


function Dataset_name_Callback(hObject, eventdata, handles)
% hObject    handle to Dataset_name (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Dataset_name as text
%        str2double(get(hObject,'String')) returns contents of Dataset_name as a double

new_datasetName = get(hObject,'String');

selected_dataset = get_selected_dataset(handles);

if ~isempty(selected_dataset)
    handles.analysisObjects(selected_dataset).datasetName = new_datasetName;
    if ~isempty(handles.analysisObjects(selected_dataset).pointillisticDatas)
        dataIndex = 1;
        handles.analysisObjects(selected_dataset).pointillisticDatas(dataIndex).dataName = new_datasetName;
    end
    handles.dataset_GUI_settings(selected_dataset).datasetName = new_datasetName;
    set(handles.Dataset_Select_Radiobutton_h(selected_dataset), 'String', new_datasetName);
end

guidata(hObject, handles);


function Dataset_name_KeyPressFcn(hObject, eventdata, handles)

Dataset_name_Callback(hObject, eventdata, handles)

guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function Dataset_name_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Dataset_name (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Remove_Dataset_Button.
function Remove_Dataset_Button_Callback(hObject, eventdata, handles)
% hObject    handle to Remove_Dataset_Button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_dataset = get_selected_dataset(handles);

if ~isempty(handles.Dataset_Select_Radiobutton_h)
    
    try
        delete(handles.Dataset_Select_Radiobutton_h(selected_dataset));
        delete(handles.analysisObjects(selected_dataset))
    catch
    end
    handles.Dataset_Select_Radiobutton_h(selected_dataset)=[];
    handles.analysisObjects(selected_dataset) = [];
    handles.dataset_GUI_settings(selected_dataset) = [];
    
    rearrange_radiobuttons(hObject, eventdata, handles);
else
    return
end

% if there are any data left after the deletion:
if ~isempty(handles.Dataset_Select_Radiobutton_h)
    
    datasetNumber = numel(handles.Dataset_Select_Radiobutton_h);
    
    selectedRadioButton = min(selected_dataset, datasetNumber);
    selectedRadioButton = max(selectedRadioButton, 1);
    
    set(handles.Dataset_Select_Radiobutton_h(selectedRadioButton),'Value',1);
else
    set(handles.Dataset_name, 'Enable', 'off')
end

Dataset_Select_Button_Group_SelectionChangeFcn(hObject, eventdata, handles);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Dataset_Select_Button_Group_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Dataset_Select_Button_Group (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

set(hObject,'Units','pixels');

guidata(hObject, handles);


% --- Executes on selection change in Select_Image_Processing_Algo.
function Select_Image_Processing_Algo_Callback(hObject, eventdata, handles)
% hObject    handle to Select_Image_Processing_Algo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Select_Image_Processing_Algo contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Select_Image_Processing_Algo

selected_dataset = get_selected_dataset(handles);

contents = cellstr(get(hObject,'String'));
algo_name = contents{get(hObject,'Value')};

handles.dataset_GUI_settings(selected_dataset).processingMethod.locAlgoName = algo_name;

localizatioSettings = rainSTORM_GUIsettings_localization.settings(algo_name);
handles.dataset_GUI_settings(selected_dataset).locAlgoSettings.algorithmName = algo_name;
% load the default settings of the algorithm
handles.dataset_GUI_settings(selected_dataset).locAlgoSettings.settings = localizatioSettings.settings;

set_Algo_Settings_panel(hObject, eventdata, handles)

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Select_Image_Processing_Algo_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Select_Image_Processing_Algo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% % % handles.algo_names_and_handles_loc = rainSTORM_default_settings_loc_algos;
% % % set(hObject,'String',handles.algo_names_and_handles_loc.names);
guidata(hObject, handles);


function Select_Calibration_File_Callback(hObject, eventdata, handles)
% hObject    handle to Select_Calibration_File (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Select_Calibration_File as text
%        str2double(get(hObject,'String')) returns contents of Select_Calibration_File as a double

fullfilename = get(hObject,'String');
if ~exist(fullfilename, 'file')
    set(handles.Select_Calibration_File,'String','File does not exist!!!');
    pause(1)
    set(handles.Select_Calibration_File,'String','');
    return;
end

selected_dataset = get_selected_dataset(handles);
handles.dataset_GUI_settings(selected_dataset).optoff_info.fullfilename = fullfilename;
load_struct = load(fullfilename,'optoff');
handles.dataset_GUI_settings(selected_dataset).optoff_info.optoff = load_struct.optoff;
set(handles.popupmenu_Optical_Offset_Calibration,'String',[{handles.dataset_GUI_settings(selected_dataset).optoff_info.optoff.Name}';'None'])
handles.dataset_GUI_settings(selected_dataset).optoff_info.selected = get(handles.popupmenu_Optical_Offset_Calibration,'Value');

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Select_Calibration_File_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Select_Calibration_File (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
% %       See ISPC and COMPUTER
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in popupmenu_Optical_Offset_Calibration.
function popupmenu_Optical_Offset_Calibration_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_Optical_Offset_Calibration (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_optoff = get(hObject,'Value');

if isempty(selected_optoff) || isempty(handles.dataset_GUI_settings.optoff_info)
    return
end

selected_dataset = get_selected_dataset(handles);
handles.dataset_GUI_settings(selected_dataset).optoff_info.selected = selected_optoff;
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenu_Optical_Offset_Calibration_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_Optical_Offset_Calibration (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes on button press in pushbutton_Select_Calibration_File.
function pushbutton_Select_Calibration_File_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Select_Calibration_File (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_dataset = get_selected_dataset(handles);
[FileName,PathName]=uigetfile(...
    {'*.mat' 'Matlab files (*.mat)';...
    '*.*' 'All files (*.*)'},...
    'Select a file');
if ~isequal(FileName, 0) && ~isequal(PathName, 0)
    fullfilename = fullfile(PathName,FileName);
    load_struct = load(fullfilename,'optoff');
    
    optinfo_struct = struct('fullfilename', fullfilename, 'selected', [], 'optoff', load_struct.optoff);
    handles.dataset_GUI_settings(selected_dataset).optoff_info = optinfo_struct;
    
    set(handles.Select_Calibration_File,'String',fullfilename,'TooltipString',fullfilename);
    set(handles.popupmenu_Optical_Offset_Calibration,'String',[{handles.dataset_GUI_settings(selected_dataset).optoff_info.optoff.Name}';'None'])
    
    handles.dataset_GUI_settings(selected_dataset).optoff_info.selected = get(handles.popupmenu_Optical_Offset_Calibration,'Value');
end

guidata(hObject, handles);


% --- Executes on button press in Display_Sum_Image.
function Display_Sum_Image_Callback(hObject, eventdata, handles)
% hObject    handle to Display_Sum_Image (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Display_Sum_Image


% --- Executes during object creation, after setting all properties.
function Algo_Settings_Panel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Algo_Settings_Panel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

handles.Algo_Settings_slider = uicontrol('Style','Slider','Parent',hObject,...
    'Units','normalized','Position',[0.95 0 0.05 1],...
    'Visible','on',...
    'BackgroundColor',[0.8 0.8 0.8],...
    'Value',1);

guidata(hObject, handles);


% --- Executes when selected object is changed in Dataset_Select_Button_Group.
function Dataset_Select_Button_Group_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in Dataset_Select_Button_Group
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)


updateGUI(hObject, eventdata, handles)

guidata(hObject, handles);


% --- Executes on button press in camera_properties_pushbutton.
function camera_properties_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to camera_properties_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_dataset = get_selected_dataset(handles);

previous_file = handles.dataset_GUI_settings(selected_dataset).processingMethod.cameraCalibrationFile;

if ~isempty(previous_file)
    defaultFile = previous_file;
else
    defaultFile = fileparts(fullfile(mfilename('fullpath')));
end

[cameraCalibrationFile, filePath] = uigetfile( ...
       {'*.json;', 'JSON Files (*.json)';
        '*.*',  'All Files (*.*)'}, ...
        'Select a camera properties file', defaultFile);

if cameraCalibrationFile ~= 0
    
    handles.dataset_GUI_settings(selected_dataset).processingMethod.cameraCalibrationFile = fullfile(filePath, cameraCalibrationFile);

    set(handles.chosen_camera_properties_file_text, 'String', cameraCalibrationFile);
    set(handles.chosen_camera_properties_file_text, 'Tooltip', ['path: ', filePath, newline, 'name: ', cameraCalibrationFile]);
end

guidata(hObject, handles);


% --- Executes on selection change in background_removal_popupmenu.
function background_removal_popupmenu_Callback(hObject, eventdata, handles)
% hObject    handle to background_removal_popupmenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns background_removal_popupmenu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from background_removal_popupmenu


% --- Executes during object creation, after setting all properties.
function background_removal_popupmenu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to background_removal_popupmenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function background_removal_edit_Callback(hObject, eventdata, handles)
% hObject    handle to background_removal_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of background_removal_edit as text
%        str2double(get(hObject,'String')) returns contents of background_removal_edit as a double

selected_dataset = get_selected_dataset(handles);

frameRange = str2double(get(hObject,'String'));
handles.dataset_GUI_settings(selected_dataset).processingMethod.backgroundRemoval.frameRange = frameRange;

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function background_removal_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to background_removal_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in background_removal_checkbox.
function background_removal_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to background_removal_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of background_removal_checkbox

datasetIndex =  get_selected_dataset(handles);

if get(hObject,'Value')
    state = 'on';
    isRequested = true;
else
    state = 'off';
    isRequested = false;
end

handles.dataset_GUI_settings(datasetIndex).processingMethod.backgroundRemoval.isRequested = isRequested;

set(handles.background_removal_edit, 'Enable', state);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Display_Sum_Image_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Display_Sum_Image (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


function additional_magnification_edit_Callback(hObject, eventdata, handles)
% hObject    handle to additional_magnification_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of additional_magnification_edit as text
%        str2double(get(hObject,'String')) returns contents of additional_magnification_edit as a double

selected_dataset = get_selected_dataset(handles);

additionalMagnification = str2double(get(hObject,'String'));
handles.dataset_GUI_settings(selected_dataset).processingMethod.additionalMagnification = additionalMagnification;

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function additional_magnification_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to additional_magnification_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function prevSF_edit_Callback(hObject, eventdata, handles)
% hObject    handle to prevSF_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of prevSF_edit as text
%        str2double(get(hObject,'String')) returns contents of prevSF_edit as a double


% --- Executes during object creation, after setting all properties.
function prevSF_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to prevSF_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in autosave_checkbox.
function autosave_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to autosave_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of autosave_checkbox


% --- Executes on button press in memorySaving_checkbox.
function memorySaving_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to memorySaving_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of memorySaving_checkbox

% --- Executes on button press in Process_All_Channels.
function Process_All_Channels_Callback(hObject, eventdata, handles)
% hObject    handle to Process_All_Channels (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

for channelIndex = 1:length(handles.analysisObjects)
    
    processDataset(channelIndex, handles)

end

guidata(hObject, handles);


% --- Executes on button press in Process_Current_Channel.
function Process_Current_Channel_Callback(hObject, eventdata, handles)
% hObject    handle to Process_Current_Channel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_dataset = get_selected_dataset(handles);

processDataset(selected_dataset, handles)

guidata(hObject, handles);


% --- Executes on button press in Save.
function Save_Callback(hObject, eventdata, handles)
% hObject    handle to Save (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

datasetIndex =  get_selected_dataset(handles);

%defaultPath = handles.last_image_dir;
defaultPath = handles.analysisObjects(datasetIndex).datasetPath;

exportPath = uigetdir(defaultPath, 'Select path to Save Processed Data');

if exportPath == 0
    return
end

saveDataset(datasetIndex, exportPath, handles);
    

% --- Executes on button press in save_all_pushbutton.
function save_all_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to save_all_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%defaultPath = handles.last_image_dir;

% let the default path be that of the last data
defaultPath = handles.analysisObjects(end).datasetPath;

exportPath = uigetdir(defaultPath, 'Select path to Save Processed Data');

if exportPath == 0
    return
end

for datasetIndex = 1:length(handles.analysisObjects)

    saveDataset(datasetIndex, exportPath, handles);

end


% --- Executes on button press in save_into_subfolder_checkbox.
function save_into_subfolder_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to save_into_subfolder_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of save_into_subfolder_checkbox



function pixel_size_edit_Callback(hObject, eventdata, handles)
% hObject    handle to pixel_size_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of pixel_size_edit as text
%        str2double(get(hObject,'String')) returns contents of pixel_size_edit as a double

[handles, ~] = readCameraSignalConversionParameters(handles);

guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function pixel_size_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pixel_size_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function exposure_edit_Callback(hObject, eventdata, handles)
% hObject    handle to exposure_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of exposure_edit as text
%        str2double(get(hObject,'String')) returns contents of exposure_edit as a double

[handles, ~] = readCameraSignalConversionParameters(handles);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function exposure_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to exposure_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function frame_interval_edit_Callback(hObject, eventdata, handles)
% hObject    handle to frame_interval_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of frame_interval_edit as text
%        str2double(get(hObject,'String')) returns contents of frame_interval_edit as a double

[handles, ~] = readCameraSignalConversionParameters(handles);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function frame_interval_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to frame_interval_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function baseline_edit_Callback(hObject, eventdata, handles)
% hObject    handle to baseline_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of baseline_edit as text
%        str2double(get(hObject,'String')) returns contents of baseline_edit as a double

[handles, ~] = readCameraSignalConversionParameters(handles);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function baseline_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to baseline_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function counts_per_photon_edit_Callback(hObject, eventdata, handles)
% hObject    handle to counts_per_photon_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of counts_per_photon_edit as text
%        str2double(get(hObject,'String')) returns contents of counts_per_photon_edit as a double

[handles, ~] = readCameraSignalConversionParameters(handles);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function counts_per_photon_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to counts_per_photon_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function counts_per_electron_edit_Callback(hObject, eventdata, handles)
% hObject    handle to counts_per_electron_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of counts_per_electron_edit as text
%        str2double(get(hObject,'String')) returns contents of counts_per_electron_edit as a double

[handles, ~] = readCameraSignalConversionParameters(handles);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function counts_per_electron_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to counts_per_electron_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in manual_camera_parameter_checkbox.
function manual_camera_parameter_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to manual_camera_parameter_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of manual_camera_parameter_checkbox

datasetIndex =  get_selected_dataset(handles);

if get(hObject,'Value')
    isRequested = true;
else
    isRequested = false;
end

handles.dataset_GUI_settings(datasetIndex).processingMethod.cameraSignalConversionOverwrite.isRequested = isRequested;

guidata(hObject, handles);

% --- Executes on button press in image_viewer_pushbutton.
function image_viewer_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to image_viewer_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

guidata(hObject, handles);

processedDataset = analysisClass.empty;
for datasetIndex = 1:numel(handles.analysisObjects)
    analysisObject = handles.analysisObjects(datasetIndex);

    if ~isempty(analysisObject.pointillisticDatas)
        processedDataset(end+1) = analysisObject;
    end
    
end

if ~isempty(processedDataset)
    if numel(processedDataset) ~= numel(handles.analysisObjects)
        warning('Not all datasets were processed. Process them and reopen the Image Viewer if every dataset is needed!');
    end
    rainSTORM_Image_Viewer(processedDataset);
else
   warning('Process the datasets before opening the Image Viewer!');
end
