function rainSTORM_GUI_astigmatic3D_calibration(pointillisticDataObject)

rowNumber = 3;

margin = 0.05;

rowheight = (1-margin)/rowNumber;
rowPositios = ((1:7)-1)*rowheight + margin;
elementHeight = (1-(rowNumber+1)*margin)/rowNumber;
elementHeight_edit = elementHeight/2;

pointillisticData = pointillisticDataObject.accepted;
pixelSize_nm = pointillisticDataObject.analysisParameters.sharedParameters.cameraSignalConversion.pixelSize_nm;
frameRange = pointillisticDataObject.analysisParameters.sharedParameters.frameRange;
originalDataPath = pointillisticDataObject.analysisParameters.sharedParameters.originalDataPath;
originalDataName = pointillisticDataObject.analysisParameters.sharedParameters.originalDataName;


% calculate the calibration data, first with dummy "z" values:
firstFrameZ_nm = 0;
lastFrameZ_nm = 1;
calibrationData = rainSTORM_astigmatic3D_calibration.calibrate(pointillisticData, frameRange, firstFrameZ_nm, lastFrameZ_nm, pixelSize_nm);


windowObject = dialog();

uicontrol('Style','text','Parent',windowObject,...
    'String', 'First frame''s Z position [nm]:',....
    'HorizontalAlignment', 'left',...
    'Units', 'normal',...
    'Position', [0.05 rowPositios(3) 0.4 elementHeight_edit]);

firstFramePosition_edit = uicontrol('Style','edit','Parent',windowObject,...
    'Tag', 'firstFramePosition_edit',...
    'String', num2str(-500),....
    'Tooltip', 'First frame''s axial (Z) position in nanometers. Make sure the frames'' axial positions are equidistant.',...
    'Units', 'normal',...
    'Position', [0.55 rowPositios(3) 0.2 elementHeight_edit]);


uicontrol('Style','text','Parent',windowObject,...
    'String', 'Last frame''s Z position [nm]:',....
    'HorizontalAlignment', 'left',...
    'Units', 'normal',...
    'Position', [0.05 rowPositios(2) 0.4 elementHeight_edit]);

lastFramePosition_edit = uicontrol('Style','edit','Parent',windowObject,...
    'Tag', 'lastFramePosition_edit',...
    'String', num2str(500),....
    'Tooltip', 'Last frame''s axial (Z) position in nanometers. Make sure the frames'' axial positions are equidistant.',...
    'Units', 'normal',...
    'Position', [0.55 rowPositios(2) 0.2 elementHeight_edit]);



 uicontrol('Style','pushbutton','Parent',windowObject,...
    'Tag', 'show_button',...
    'Callback',@(ObjH, EventData) show_callback(firstFramePosition_edit, lastFramePosition_edit, calibrationData),...
    'String', 'Show',....
    'Tooltip', 'Visualize the astigmatic 3D calibration data.',...
    'Units', 'normal',...
    'Position', [0.05 rowPositios(1) 0.3 elementHeight]);



uicontrol('Style','pushbutton','Parent',windowObject,...
    'Tag', 'cancel_button',...
    'Callback','delete(gcf)',...
    'String', 'Cancel',....
    'Tooltip', 'Cancel the astigmatic 3D calculation.',...
    'Units', 'normal',...
    'Position', [0.35 rowPositios(1) 0.3 elementHeight]);

uicontrol('Style','pushbutton','Parent',windowObject,...
    'Tag', 'save_button',...
    'Callback',@(ObjH, EventData) save_callback(firstFramePosition_edit, lastFramePosition_edit, calibrationData, originalDataPath, originalDataName),...
    'String', 'Save',....
    'Tooltip', 'Save the astigmatic calibration data.',...
    'Units', 'normal',...
    'Position', [0.65 rowPositios(1) 0.3 elementHeight]);

uiwait(windowObject);

end


function show_callback(firstFramePosition_edit, lastFramePosition_edit, calibrationData)

  firstFrameZ_nm = str2double(get(firstFramePosition_edit, 'String'));
  lastFrameZ_nm = str2double(get(lastFramePosition_edit, 'String'));
  
  % update the "z" position of the calibration data
  
  calibrationData.z_nm(:) = linspace(firstFrameZ_nm, lastFrameZ_nm, numel(calibrationData.z_nm));
  
  rainSTORM_astigmatic3D_calibration.visualize(calibrationData);
  
end

function save_callback(firstFramePosition_edit, lastFramePosition_edit, calibrationData, originalFilePath, originalFileName)

  firstFrameZ_nm = str2double(get(firstFramePosition_edit, 'String'));
  lastFrameZ_nm = str2double(get(lastFramePosition_edit, 'String'));
  
  % update the "z" position of the calibration data
  
  calibrationData.z_nm(:) = linspace(firstFrameZ_nm, lastFrameZ_nm, numel(calibrationData.z_nm));
  
  [~, name, ~] = fileparts(originalFileName);
  new_name = [name, '_calibration_ast3D', '.csv'];
  newFullFileName = fullfile(originalFilePath, new_name);
  
  [outputName, outputPath] = uiputfile(...
      {'*.csv', 'CSV files (*.csv)';
        '*.*',  'All Files (*.*)'}, ...
        'Save the astigmatic 3D calibration data as',...
        newFullFileName);
    if outputName == 0
       return; 
    end
    
    outputFullFileName = fullfile(outputPath, outputName);
    
    writetable(calibrationData, outputFullFileName);
    
   delete(gcf)
end
