classdef rainSTORM_GUI_clusterAnalysis < handle
    
    properties
        
        specificElements
        
        pointillisticDataObject
        clusterProperties
        
        methodList
        availableSettings
        chosenMethod
        appliedSettings
        
        rowPositios
        elementHeight
        
        windowObject
        
    end
    
    methods

        function pointillisticDataObject = create(someStoringHandleObject, pointillisticDataObject, clusterizationSettings)

            rowNumber = 7;

            margin = 0.05;

            rowheight = (1-margin)/rowNumber;
            rowPositios = ((1:rowNumber)-1)*rowheight + margin;
            elementHeight = (1-(rowNumber+1)*margin)/rowNumber;

            someStoringHandleObject.rowPositios = rowPositios;
            someStoringHandleObject.elementHeight = elementHeight;
            
            windowObject = dialog();
            % for debugging:
            %windowObject = figure();
            
            someStoringHandleObject.windowObject = windowObject;

            someStoringHandleObject.pointillisticDataObject = pointillisticDataObject;

            someStoringHandleObject.methodList = rainSTORM_GUIsettings_clusterization.methods();
            someStoringHandleObject.availableSettings = {};
            someStoringHandleObject.chosenMethod = clusterizationSettings.method;

            for idxMethod = 1:numel(someStoringHandleObject.methodList)

              method = someStoringHandleObject.methodList{idxMethod};

              if strcmp(method, clusterizationSettings)
                someStoringHandleObject.availableSettings{idxMethod} = clusterizationSettings.settings;
              else
                temp_settings = rainSTORM_GUIsettings_clusterization.settings(method);
                someStoringHandleObject.availableSettings{idxMethod} = temp_settings;
              end

            end


            uicontrol('Style','text','Parent',windowObject,...
                'String', 'Method:',...
                'HorizontalAlignment', 'left',...
                'Units', 'normal',...
                'Position', [0.05 rowPositios(7) 0.4 elementHeight]);

            uicontrol('Style','popupmenu','Parent',windowObject,...
                'String', someStoringHandleObject.methodList,....
                'Value', find(strcmp(someStoringHandleObject.chosenMethod, someStoringHandleObject.methodList)),...
                'CreateFcn', @(ObjH, EventData) method_createfcn(windowObject, someStoringHandleObject),...
                'Callback', @(ObjH, EventData) method_callback(windowObject, someStoringHandleObject),...
                'HorizontalAlignment', 'left',...
                'Units', 'normal',...
                'Position', [0.55 rowPositios(7) 0.4 elementHeight]);

            
            uicontrol('Style','pushbutton','Parent',windowObject,...
                'Tag', 'calculate_button',...
                'Callback',@(ObjH, EventData) calculate_callback(someStoringHandleObject),...
                'String', 'Calculate',...
                'Tooltip', 'Clusterize the data.',...
                'Units', 'normal',...
                'Position', [0.05 rowPositios(2) 0.23 elementHeight]);
            
            uicontrol('Style','pushbutton','Parent',windowObject,...
                'Tag', 'showClusters_button',...
                'Callback',@(ObjH, EventData) showClusters_callback(someStoringHandleObject),...
                'String', 'Show Clusters',...
                'Enable', 'Off',...
                'Tooltip', 'Visualize the clusterized pointillistic data.',...
                'Units', 'normal',...
                'Position', [0.28 rowPositios(2) 0.23 elementHeight]);

            uicontrol('Style','pushbutton','Parent',windowObject,...
                'Tag', 'showHistograms_button',...
                'Callback',@(ObjH, EventData) showHistograms_callback(someStoringHandleObject),...
                'String', 'Show Histograms',...
                'Enable', 'Off',...
                'Tooltip', 'Shows the histograms of the cluster properties.',...
                'Units', 'normal',...
                'Position', [0.51 rowPositios(2) 0.23 elementHeight]);

            uicontrol('Style','pushbutton','Parent',windowObject,...
                'Tag', 'remove_button',...
                'Callback',@(ObjH, EventData) remove_callback(someStoringHandleObject),...
                'String', 'Remove',...
                'Tooltip', 'Remove the cluster indices field from the data.',...
                'Units', 'normal',...
                'Position', [0.74 rowPositios(2) 0.23 elementHeight]);

            
            uicontrol('Style','pushbutton','Parent',windowObject,...
                'Tag', 'save_button',...
                'Callback',@(ObjH, EventData) save_callback(someStoringHandleObject),...
                'String', 'Save',...
                'Enable', 'Off',...
                'Tooltip', 'Save the cluster properties data.',...
                'Units', 'normal',...
                'Position', [0.05 rowPositios(1) 0.3 elementHeight]);
            

            uicontrol('Style','pushbutton','Parent',windowObject,...
                'Tag', 'cancel_button',...
                'Callback',@(ObjH, EventData) cancel_callback(someStoringHandleObject, windowObject),...
                'String', 'Cancel',...
                'Tooltip', 'Cancel the astigmatic 3D calculation.',...
                'Units', 'normal',...
                'Position', [0.35 rowPositios(1) 0.3 elementHeight]);

            uicontrol('Style','pushbutton','Parent',windowObject,...
                'Tag', 'ok_button',...
                'Callback','delete(gcf)',...
                'String', 'Ok',...
                'Tooltip', 'Apply the astigmatic 3D calculation.',...
                'Units', 'normal',...
                'Position', [0.65 rowPositios(1) 0.3 elementHeight]);


            uiwait(windowObject);

            %  place it in the calling function
            % xx.pointillistidDataObject = somesStoringHandleObject.pointillistidDataObject;

            %end

        end

    end
    
end


function method_elements(windowObject, someStoringHandleObject, chosenMethod)

rowPositios = someStoringHandleObject.rowPositios;
elementHeight = someStoringHandleObject.elementHeight;

  for i = 1:numel(someStoringHandleObject.specificElements)
    delete(someStoringHandleObject.specificElements{i});
  end
  % create the GUI elements for the method settings:
  switch chosenMethod
    case 'DBSCAN'

        someStoringHandleObject.specificElements{1} = uicontrol('Style','text','Parent',windowObject,...
            'String', ['epsilon [', get_settingsField_text(someStoringHandleObject, 'epsilon.unit'), ']:'],....
            'HorizontalAlignment', 'left',...
            'Units', 'normal',...
            'Position', [0.05 rowPositios(6) 0.4 elementHeight]);

        someStoringHandleObject.specificElements{2} = uicontrol('Style','edit','Parent',windowObject,...
            'String', get_settingsField_numeric(someStoringHandleObject, 'epsilon.value', 1),....
            'Callback', @(ObjH, EventData)  set_settingsField_numeric(someStoringHandleObject, 'epsilon.value', 1),...
            'Tooltip', 'Neighbour searching radius of DBSCAN (epsilon).',...
            'Units', 'normal',...
            'Position', [0.55 rowPositios(6) 0.2 elementHeight]);


        someStoringHandleObject.specificElements{3} = uicontrol('Style','text','Parent',windowObject,...
            'String', 'Minimal neighbour number:',....
            'HorizontalAlignment', 'left',...
            'Units', 'normal',...
            'Position', [0.05 rowPositios(5) 0.4 elementHeight]);

        someStoringHandleObject.specificElements{4} = uicontrol('Style','edit','Parent',windowObject,...
            'String', get_settingsField_numeric(someStoringHandleObject, 'minPts.value', 1),....
            'Callback', @(ObjH, EventData) set_settingsField_numeric(someStoringHandleObject, 'minPts.value', 1),...
            'Tooltip', 'Minimal neighbour number within epsilon to be a core cluster element.',...
            'Units', 'normal',...
            'Position', [0.55 rowPositios(5) 0.2 elementHeight]);
        
        
          someStoringHandleObject.specificElements{5} = uicontrol('Style','checkbox','Parent',windowObject,...
              'String', '3 dimensional clusterization',....
              'Value', get_settingsField_boolean(someStoringHandleObject, 'threeDimFlag.value'),...
              'Callback', @(ObjH, EventData) set_settingsField_boolean(someStoringHandleObject, 'threeDimFlag.value'),...
              'Tooltip', 'Scaling for the axial postion (z) to account for the decreased localization precision.',...
              'Units', 'normal',...
              'Position', [0.05 rowPositios(4) 0.4 elementHeight]);
        
        
      someStoringHandleObject.specificElements{6} = uicontrol('Style','text','Parent',windowObject,...
          'String', 'z axis scaling:',....
          'HorizontalAlignment', 'left',...
          'Units', 'normal',...
          'Position', [0.05 rowPositios(3) 0.4 elementHeight]);

      someStoringHandleObject.specificElements{7} = uicontrol('Style','edit','Parent',windowObject,...
          'String', get_settingsField_numeric(someStoringHandleObject, 'zScaleFactor.value', 1),....
          'Callback', @(ObjH, EventData) set_settingsField_numeric(someStoringHandleObject, 'zScaleFactor.value', 1),...
          'Tooltip', 'Scaling for the axial postion (z) to account for the decreased localization precision.',...
          'Units', 'normal',...
          'Position', [0.55 rowPositios(3) 0.2 elementHeight]);

    otherwise
      error('Unknown clusterization method: %s', chosenMethod)
  end
    
end


function text = get_settingsField_text(someStoringHandleObject, fieldNames)

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  fieldName_list = strsplit(fieldNames, '.');
  
  text = getfield(someStoringHandleObject.availableSettings{idxMethod}.settings, fieldName_list{:});

end


function value = get_settingsField_boolean(someStoringHandleObject, fieldNames)

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  fieldName_list = strsplit(fieldNames, '.');
  
  value = getfield(someStoringHandleObject.availableSettings{idxMethod}.settings, fieldName_list{:});

end


function set_settingsField_boolean(someStoringHandleObject, fieldNames)
    
  settingsValue = get(gcbo, 'Value');

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  fieldName_list = strsplit(fieldNames, '.');
  
  % the "setfield"doues not changes the handle object, but converts it to
  % struct...
  modifiedSettings = setfield(someStoringHandleObject.availableSettings{idxMethod}.settings, fieldName_list{:}, settingsValue);
  someStoringHandleObject.availableSettings{idxMethod}.settings = modifiedSettings;
end



function valueText = get_settingsField_numeric(someStoringHandleObject, fieldNames, index)

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  fieldName_list = strsplit(fieldNames, '.');
  
  value = getfield(someStoringHandleObject.availableSettings{idxMethod}.settings, fieldName_list{:});

  valueText = num2str(value(index));

end


function set_settingsField_numeric(someStoringHandleObject, fieldNames, index)
    
  value = str2double(get(gcbo, 'String'));

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  fieldName_list = strsplit(fieldNames, '.');
  
  % get the original value and modify one of its element:
  settingsValue = getfield(someStoringHandleObject.availableSettings{idxMethod}.settings, fieldName_list{:});
  settingsValue(index) = value;
  
  % the "setfield"doues not changes the handle object, but converts it to
  % struct...
  modifiedSettings = setfield(someStoringHandleObject.availableSettings{idxMethod}.settings, fieldName_list{:}, settingsValue);
  someStoringHandleObject.availableSettings{idxMethod}.settings = modifiedSettings;
end

function index = get_settingsField_list(someStoringHandleObject, list, fieldName)

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  index = find(strcmp(list, someStoringHandleObject.availableSettings{idxMethod}.settings.(fieldName)));

end


function set_settingsField_list(someStoringHandleObject, fieldName)

  contents = cellstr(get(gcbo,'String'));
  chosenElement = contents{get(gcbo,'Value')};

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  someStoringHandleObject.availableSettings{idxMethod}.settings.(fieldName) = chosenElement;

end

function method_createfcn(windowObject, someStoringHandleObject)

    chosenMethod = someStoringHandleObject.chosenMethod;
    
    method_elements(windowObject, someStoringHandleObject, chosenMethod);
    
end

function method_callback(windowObject, someStoringHandleObject)

    contents = cellstr(get(gcbo,'String'));
    chosenMethod = contents{get(gcbo,'Value')};

    someStoringHandleObject.chosenMethod = chosenMethod;

    method_elements(windowObject, someStoringHandleObject, chosenMethod);

end


function calculate_callback(someStoringHandleObject)

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  clusterizationSettings_GUI = someStoringHandleObject.availableSettings{idxMethod};
  clusterizationSettings_stripped = rainSTORM_GUI_settings_extract.operation(clusterizationSettings_GUI);

  [clusterProperties, appliedSettings] = someStoringHandleObject.pointillisticDataObject.clusterize(clusterizationSettings_stripped);
  
  someStoringHandleObject.clusterProperties = clusterProperties;
  
  someStoringHandleObject.appliedSettings = appliedSettings;
  
  showClusters_button = findobj(someStoringHandleObject.windowObject, 'Tag', 'showClusters_button');
  set(showClusters_button, 'Enable', 'on');
  showHistograms_button = findobj(someStoringHandleObject.windowObject, 'Tag', 'showHistograms_button');
  set(showHistograms_button, 'Enable', 'on');
  save_button = findobj(someStoringHandleObject.windowObject, 'Tag', 'save_button');
  set(save_button, 'Enable', 'on');
  
end


function showClusters_callback(someStoringHandleObject)

  if isempty(someStoringHandleObject.clusterProperties)

    warning('Cannot visualize the clusters. Run the clusterization first.');
    return
  end

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  processingOperations = someStoringHandleObject.pointillisticDataObject.analysisParameters.processingOperations;
  
  appliedSettings = someStoringHandleObject.appliedSettings;
  
  clusterProperties = someStoringHandleObject.clusterProperties;

  clusterFig = rainSTORM_clusterAnalysis.plotClusters(someStoringHandleObject.pointillisticDataObject.accepted, clusterProperties.centers, appliedSettings);
  if ~ isempty(clusterFig)
    figure(clusterFig)
  else
    % do nothing
  end
  
end


function showHistograms_callback(someStoringHandleObject)

  if isempty(someStoringHandleObject.clusterProperties)

    warning('Cannot visualize the clusters. Run the clusterization first.');
    return
  end

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  processingOperations = someStoringHandleObject.pointillisticDataObject.analysisParameters.processingOperations;
  
  appliedSettings = someStoringHandleObject.appliedSettings;
  
  clusterProperties = someStoringHandleObject.clusterProperties;

  clusterPropFig = rainSTORM_clusterAnalysis.plotClusterProperties(clusterProperties, appliedSettings);
  figure(clusterPropFig)
  
end


function remove_callback(someStoringHandleObject)

  someStoringHandleObject.pointillisticDataObject.undoClusterization();

  showClusters_button = findobj(someStoringHandleObject.windowObject, 'Tag', 'showClusters_button');
  set(showClusters_button, 'Enable', 'off');
  showHistograms_button = findobj(someStoringHandleObject.windowObject, 'Tag', 'showHistograms_button');
  set(showHistograms_button, 'Enable', 'off');
  save_button = findobj(someStoringHandleObject.windowObject, 'Tag', 'save_button');
  set(save_button, 'Enable', 'off');
  
end


function save_callback(someStoringHandleObject)

  if isempty(someStoringHandleObject.clusterProperties)

    warning('Cannot save the clusters. Run the clusterization first.');
    return
  end

  idxMethod = find(strcmp(someStoringHandleObject.methodList, someStoringHandleObject.chosenMethod));

  processingOperations = someStoringHandleObject.pointillisticDataObject.analysisParameters.processingOperations;
  
  appliedSettings = someStoringHandleObject.appliedSettings;
  
  clusterProperties = someStoringHandleObject.clusterProperties;

  exportPath = someStoringHandleObject.pointillisticDataObject.analysisParameters.sharedParameters.originalDataPath;
  exportName = someStoringHandleObject.pointillisticDataObject.analysisParameters.sharedParameters.originalDataName;
  rainSTORM_clusterAnalysis.xlsWrite(clusterProperties, appliedSettings, exportPath, exportName);
  
end


function cancel_callback(someStoringHandleObject, windowObject)

% check if there were any calculations performed:
save_button = findobj(someStoringHandleObject.windowObject, 'Tag', 'save_button');
save_button_state = get(save_button, 'Enable');
if strcmp(save_button_state, 'on')
    someStoringHandleObject.pointillisticDataObject.undoClusterization()
end

delete(windowObject)

end
