classdef rainSTORM_GUI_settings_extract
    
    methods(Static)
        
        function extractedSettings = operation(GUI_settings_operation)
        % Extracts the "value" and "unit" field from the given operation GUI settings as only it is needed for
        % the algorithms, the other fields only required by the GUI. Otherwise it
        % maintaines the settings field names.


            extractedSettings = GUI_settings_operation;
            extractedSettings.settings = struct();

            fieldNames = fieldnames(GUI_settings_operation.settings);

            for idxField = 1:numel(fieldNames)

                fieldName = fieldNames{idxField};

                settings = GUI_settings_operation.settings.(fieldName);

                if isstruct(settings)
                    if isfield(settings, 'value')
                        if isfield(settings, 'unit')
                            extractedSettings.settings.(fieldName).value = settings.value;
                            extractedSettings.settings.(fieldName).unit = settings.unit;
                        else
                            extractedSettings.settings.(fieldName) = settings.value;
                        end
                    else
                        extractedSettings.settings.(fieldName) = settings;
                    end
                else
                    extractedSettings.settings.(fieldName) = settings;
                end

            end

        end
        
        function extractedSettings = data(GUI_settings_data)
            % Does the same for a chosen "data" part of the settings
            % structure (e.g. "imageStack", "localizationData")
            
            extractedSettings = GUI_settings_data;
            if isfield(GUI_settings_data, 'creation')
                extractedSettings.creation = struct();
                operationNames = fieldnames(GUI_settings_data.creation);
                for idxOperation = 1:numel(operationNames)
                    operationName = operationNames{idxOperation};
                    GUI_settings_operation = GUI_settings_data.creation.(operationName);
                    extractedSettings.creation.(operationName) = rainSTORM_GUI_settings_extract.operation(GUI_settings_operation);
                end
            end
            
            if isfield(GUI_settings_data, 'processing')
                extractedSettings.processing = struct();
                operationNames = fieldnames(GUI_settings_data.processing);
                for idxOperation = 1:numel(operationNames)
                    operationName = operationNames{idxOperation};
                    GUI_settings_operation = GUI_settings_data.processing.(operationName);
                    extractedSettings.processing.(operationName) = rainSTORM_GUI_settings_extract.operation(GUI_settings_operation);
                end
            end
            
        end
        
        function extractedSettings = full(GUI_settings)
            % Does the same for the full settings structure
            
            extractedSettings = struct();
            dataNames = fieldnames(GUI_settings);
            for idxData = 1:numel(dataNames)
                dataName = dataNames{idxData};
                GUI_settings_data = GUI_settings.(dataName);
                extractedSettings.(dataName) = rainSTORM_GUI_settings_extract.data(GUI_settings_data);
            end
        end
        
    end
    
end



