function varargout = rainSTORM_Image_Viewer(varargin)
% RAINSTORM_IMAGE_VIEWER MATLAB code for rainSTORM_Image_Viewer.fig
%      RAINSTORM_IMAGE_VIEWER, by itself, creates a new RAINSTORM_IMAGE_VIEWER or raises the existing
%      singleton*.
%
%      H = RAINSTORM_IMAGE_VIEWER returns the handle to a new RAINSTORM_IMAGE_VIEWER or the handle to
%      the existing singleton*.
%
%      RAINSTORM_IMAGE_VIEWER('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RAINSTORM_IMAGE_VIEWER.M with the given input arguments.
%
%      RAINSTORM_IMAGE_VIEWER('Property','Value',...) creates a new RAINSTORM_IMAGE_VIEWER or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before rainSTORM_Image_Viewer_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to rainSTORM_Image_Viewer_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help rainSTORM_Image_Viewer

% Last Modified by GUIDE v2.5 06-Jan-2026 10:25:39

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @rainSTORM_Image_Viewer_OpeningFcn, ...
    'gui_OutputFcn',  @rainSTORM_Image_Viewer_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before rainSTORM_Image_Viewer is made visible.
function rainSTORM_Image_Viewer_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to rainSTORM_Image_Viewer (see VARARGIN)

% path of the evaluation codes relative to the script location:
codePath='./';

% adding the directories containing the required functions
run(fullfile(codePath, 'addSubfoldersToPath.m'));

defaultSettings_file = 'settings/operationSettings_rainSTORM_GUI_defaults.json';
importedDefaultSettings = importSettings(defaultSettings_file);

if isempty(varargin)
    handles.analysisObjects = analysisClass.empty();

    handles.defaultSettings(1).settingsFile = defaultSettings_file;
    handles.defaultSettings(1).exportPath = '';

    handles.defaultSettings(1).dataProcessing = importedDefaultSettings;
    
    handles.selectedFilter = {};
    
else
    
    if ~isa(varargin{1}, 'analysisClass')
       error('The Image Viewer can only be initialized with "analysisClass".') 
    end
    
    handles.analysisObjects = varargin{1};
    
    handles.defaultSettings = struct();
    for idxDataset = 1:numel(handles.analysisObjects)
        handles.defaultSettings(idxDataset).settingsFile = defaultSettings_file;
        handles.defaultSettings(idxDataset).exportPath = '';

        handles.defaultSettings(idxDataset).dataProcessing = importedDefaultSettings;
        
        %  calculate the precision
        for idxData = 1:numel(handles.analysisObjects(idxDataset).pointillisticDatas)
            handles.analysisObjects(idxDataset).pointillisticDatas(idxData).estimatePrecision();
            
            handles.selectedFilter{idxDataset}{idxData} = 1;
        end
    end
    
end


% initialize the "datasetSettings" even there is no dataset defined
% this way the settings on the GUI can be adjusted before loading any
% dataset, these adjustment will pertain to the first dataset
handles.datasetSettings = handles.defaultSettings;


handles.pixelizationMethods = rainSTORM_GUIsettings_pixelization.methods();
set(handles.popupmenu_Recon_Algo_Select, 'String', handles.pixelizationMethods);

handles.filteringNames = rainSTORM_GUIsettings_filtering.methods();
for idxMethod = 1:numel(handles.filteringNames)
    handles.filteringSettings{idxMethod} = rainSTORM_GUIsettings_filtering.settings(handles.filteringNames{idxMethod});
end
% add the last as an optin to show the data convetion's every field with unset thresholds
handles.filteringNames{end+1} = 'Data Fields';
% initialize it as empty as it needs to adopted to the actual data
handles.filteringSettings{end+1} = struct();

set(handles.popupmenu_Add_Filter, 'String', handles.filteringNames);

handles.colormapNames = customColormap.getDefinitionNames();

set(handles.popupmenu_Colormap_Select, 'String', handles.colormapNames);

handles.driftCorrectionMethods = rainSTORM_GUIsettings_driftCorrection.methods();
set(handles.Drift_Algorithm_Selection_popupmenu, 'String', handles.driftCorrectionMethods);

handles = updateSettingsFileText(hObject, eventdata, handles);
handles = updateExportPathText(hObject, eventdata, handles);

handles = setup_Channel_Select_Panel(hObject, eventdata, handles);

handles = setup_Select_Recon_Panel(hObject, eventdata, handles);

handles = setup_Recon_Algo_Settings_Panel(hObject, eventdata, handles);

handles = setup_Drift_Correction_Settings(hObject, eventdata, handles);

handles = setup_Select_Filter_Panel(hObject, eventdata, handles);

handles = setup_Filter_Settings_Panel(hObject, eventdata, handles);

handles = resetExportPathFunc(hObject, eventdata, handles);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes rainSTORM_Image_Viewer wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = rainSTORM_Image_Viewer_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
% % % varargout{1} = handles.output;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function importedDataProcessing = importSettings(settingsFile)
importedFullSettings = jsonManagement.import(settingsFile);

importedDataProcessing = struct();
importedDataProcessing = importedFullSettings.localizationData.processing;
% until a better solution:
importedDataProcessing.concatenation = importedFullSettings.concatenatedData.creation.concatenation;
    

function handles = updateSettingsFileText(hObject, eventdata, handles)

selected_channel = get_selected_channel(handles);

settingsFileFullName = handles.defaultSettings(selected_channel).settingsFile;

[~, settingsName, ~] = fileparts(settingsFileFullName);
set(handles.imported_settings_text, 'String', settingsName);
set(handles.imported_settings_text, 'Tooltip', settingsFileFullName);
    
guidata(hObject, handles);

    
function handles = updateExportPathText(hObject, eventdata, handles)
    
selected_channel = get_selected_channel(handles);

exportPath = handles.datasetSettings(selected_channel).exportPath;

if ~isempty(exportPath)
    subdirectories = split(exportPath, filesep);

    set(handles.exportPath_text, 'String', subdirectories{end});
    set(handles.exportPath_text, 'Tooltip', exportPath);
else
   resetExportPathFunc(hObject, eventdata, handles);
end
    
guidata(hObject, handles);


function handles = setup_Recon_Algo_Settings_Panel(hObject, eventdata, handles)
% This function creates the GUI elements on the reconstruction settings panel

h = get(handles.uipanel_Recon_Algo_Settings,'Children');
h(h == handles.uipanel_Recon_Algo_Settings_slider) = [];
delete(h);
handles.Recon_Algo_Settings_h = [];     % for the uicontrols

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

recon_settings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization.settings;

recon_settings_names = fieldnames(recon_settings);

num_of_params = length(recon_settings_names);

% getting the name of the actual pixelization algorithm
chosenMethod=handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization.method;


panel_pos = get(handles.uipanel_Recon_Algo_Settings,'Position');
panel_unit = get(handles.uipanel_Recon_Algo_Settings,'Unit');

panel_line_space = 30;
panel_first_line_pos = panel_pos(4)-panel_line_space/2;
panel_max_lines = floor(panel_pos(4) / panel_line_space)-1;

Recon_Algo_Settings_h = reconParamsInputFieldsfunc(handles.uipanel_Recon_Algo_Settings, handles.uipanel_Recon_Algo_Settings_slider, num_of_params, panel_max_lines, recon_settings, recon_settings_names, panel_line_space, panel_first_line_pos, panel_unit);
handles.Recon_Algo_Settings_h = Recon_Algo_Settings_h;


% update selection button
set(handles.popupmenu_Recon_Algo_Select,'Value',...
    find(strcmp(handles.pixelizationMethods, chosenMethod))...
    );

% update the colormap too
selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
visualizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).visualization;
selectedColormap = visualizationOperationSettings.settings.colormapName.value;
colormapIndex = find(strcmp(handles.colormapNames, selectedColormap));
set(handles.popupmenu_Colormap_Select,'Value', colormapIndex);

guidata(hObject, handles);


function handles = setup_Drift_Correction_Settings(hObject, eventdata, handles)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

chosenMethod=handles.datasetSettings(selected_channel).dataProcessing(selected_recon).driftCorrection.method;

% update selection button
set(handles.Drift_Algorithm_Selection_popupmenu,'Value',...
    find(strcmp(handles.driftCorrectionMethods, chosenMethod))...
    );

guidata(hObject, handles);



function handles = setup_Filter_Settings_Panel(hObject, eventdata, handles)

h = get(handles.uipanel_Filter_Settings,'Children');
h(h == handles.uipanel_Filter_Settings_slider) = [];
delete(h);
handles.Filter_Settings_h = [];

if isempty(handles.analysisObjects)
   return 
end

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
selected_filter = get_selected_Filter(handles);

filteringSetting = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter);

if isempty(filteringSetting)
   return 
end

dataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);
dataConvention = dataObject.analysisParameters.sharedParameters.convention;
convention = dataConvention.name;
analyses = dataConvention.analyses;
algorithm = dataConvention.algorithm;

dataFieldNames = pointillisticData_fieldNameManagement.getFieldNames(dataObject.accepted);

%adjust the filtering settings to the actual data
filteringSetting = filteringOperation.adjustFilteringSettings(filteringSetting, dataObject.analysisParameters.sharedParameters);
handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter) = filteringSetting;

filteringThresholds = filteringSetting.settings.thresholds;

% discard the thresholding fields names that are not part of the data:
filteringThresholds = pointillisticData_filtering.stripFilteringThresholds(filteringThresholds, dataFieldNames);


analysisParameters = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon).analysisParameters;


[algorithmFields, analysesFields] = conventionFunctions.conventionFields(convention, algorithm, analyses);
jointFields = [algorithmFields, analysesFields{:}];
convention_field = {jointFields.fieldname};
convention_description = {jointFields.description};

panel_pos = get(handles.uipanel_Filter_Settings,'Position');
panel_unit = get(handles.uipanel_Filter_Settings,'Unit');

panel_line_space = 30;
panel_first_line_pos = panel_pos(4)-panel_line_space/2;
panel_max_lines = floor(panel_pos(4) / panel_line_space)-1;

num_of_params = numel(filteringThresholds);

for idx_param = 1:num_of_params
    if idx_param > panel_max_lines
        visibility='off';
    else
        visibility='on';
    end

    param_name = filteringThresholds(idx_param).field;
    param_value = filteringThresholds(idx_param).bounds;
    param_unit = filteringThresholds(idx_param).unit;
    
    % get the first matching index with the field definitions 
    fieldIndex = min(find(strcmp(convention_field, param_name)));
    
    tooltip = '';
    if fieldIndex ~= 0
        tooltip = sprintf('data field: %s\nunit: %s\ndescription: %s', param_name, param_unit, convention_description{fieldIndex});
    else
        tooltip = sprintf('data field: %s\nunit: %s', param_name, param_unit);
    end

    % descriptions
    handles.Filter_Settings_h(idx_param).h(1) = uicontrol(...
        handles.uipanel_Filter_Settings,...
        'Style','text',...
        'String', [param_name, ' [', param_unit, ']:'],...
        'HorizontalAlignment','left',...
        'BackgroundColor',[0.8 0.8 0.8],...
        'TooltipString',tooltip,...
        'Units',panel_unit,...
        'Visible',visibility,...
        'Position', [10 panel_first_line_pos-idx_param*panel_line_space 150 20]);

    % input uicontrols
    filterType = 'number';

    if numel(param_value) == 1
        handles.Filter_Settings_h(idx_param).h(2) = uicontrol(...
            handles.uipanel_Filter_Settings,...
            'Callback',{@set_Filter_Settings_value, param_name, 1, filterType},...
            'Style','edit',...
            'String',num2str(param_value),...
            'HorizontalAlignment','center',...
            'Units',panel_unit,...
            'Visible',visibility,...
            'Position', [220  panel_first_line_pos-idx_param*panel_line_space 50 20]);
    elseif numel(param_value) == 2
        handles.Filter_Settings_h(idx_param).h(2) = uicontrol(...
            handles.uipanel_Filter_Settings,...
            'Callback',{@set_Filter_Settings_value, param_name, 1, filterType},...
            'Style','edit',...
            'String',num2str(param_value(1)),...
            'HorizontalAlignment','center',...
            'Units',panel_unit,...
            'Visible',visibility,...
            'Position', [160  panel_first_line_pos-idx_param*panel_line_space 50 20]);
        handles.Filter_Settings_h(idx_param).h(3) = uicontrol(...
            handles.uipanel_Filter_Settings,...
            'Callback',{@set_Filter_Settings_value, param_name, 2, filterType},...
            'Style','edit',...
            'String',num2str(param_value(2)),...
            'HorizontalAlignment','center',...
            'Units',panel_unit,...
            'Visible',visibility,...
            'Position', [220  panel_first_line_pos-idx_param*panel_line_space 50 20]);
    else
        error(['The filtering thresholds of the', fieldName, 'contains too many values...'])
    end
end

if num_of_params<=panel_max_lines
    set(handles.uipanel_Filter_Settings_slider,...
        'Visible','off');
else
    set(handles.uipanel_Filter_Settings_slider,...
        'Visible','on',...
        'Min',0,'Max',(num_of_params-panel_max_lines),...
        'Value',(num_of_params-panel_max_lines),...
        'Callback',{@uipanel_Filter_Settings_slider_callback,...
        panel_first_line_pos, panel_max_lines, panel_line_space},...
        'SliderStep',[1 1]./(num_of_params-panel_max_lines));

% "handles" as an input is wrong, modified by NT on 2017.12.19.
% see the comment in the "uipanel_Filter_Settings_slider_callback"
%        'Callback',{@uipanel_Filter_Settings_slider_callback,...
%        handles, panel_first_line_pos, panel_max_lines, panel_line_space},...
end

guidata(hObject, handles);



function handles = setup_Channel_Select_Panel(hObject, eventdata, handles)

selected_channel_original = get_selected_channel(handles);

if isempty(handles.analysisObjects)
   return 
end

num_of_channels = numel(handles.analysisObjects);
for idx_ch = 1:num_of_channels
    dataName = handles.analysisObjects(idx_ch).datasetName;
    panel_pos = get(handles.uipanel_Select_Channel,'Position');
    panel_unit = get(handles.uipanel_Select_Channel,'Unit');
    handles.Channel_Settings_Radiobutton_h(idx_ch) = uicontrol(...
        handles.uipanel_Select_Channel,...
        'BackgroundColor',[0.8 0.8 0.8],...
        'Style','radiobutton',...
        'String', dataName,...['Ch ', num2str(idx_ch),': ',handles.params.ch_data{idx_ch,1}.channel_name]
        'TooltipString', dataName,....
        'HorizontalAlignment','left',...
        'Units',panel_unit,...
        'Position', [10 panel_pos(4)-45-(idx_ch-1)*30 panel_pos(3)-20 20]);

end
set(handles.uipanel_Select_Channel,...
    'SelectionChangeFcn',@SelectionChangeFcn_Channel_select);

% switch to the first of the newly added datasets:
selected_channel_new = min([selected_channel_original+1, numel(handles.Channel_Settings_Radiobutton_h)]);
set(handles.Channel_Settings_Radiobutton_h(selected_channel_new), 'Value', 1);


guidata(hObject, handles);


function handles = setup_Select_Recon_Panel(hObject, eventdata, handles)


h = get(handles.select_data_uipanel,'Children');
h(h == handles.uipanel_Select_Recon_Slider) = [];
delete(h);
handles.Recon_Select_Radiobutton_h = matlab.ui.control.UIControl.empty();

if isempty(handles.analysisObjects)
    return
end

selected_channel = get_selected_channel(handles);

panel_pos = get(handles.select_data_uipanel,'Position');
panel_unit = get(handles.select_data_uipanel,'Unit');

panel_line_space = 30;
panel_first_line_pos = panel_pos(4)-panel_line_space/2;
panel_max_lines = floor(panel_pos(4) / panel_line_space)-1;

analysisObject = handles.analysisObjects(selected_channel);
dataNumber = numel(analysisObject.pointillisticDatas);

for dataIndex = 1:dataNumber
    dataName = analysisObject.pointillisticDatas(dataIndex).dataName;

    if dataIndex > panel_max_lines
        visibility='off';
    else
        visibility='on';
    end
    handles.Recon_Select_Radiobutton_h(dataIndex) = uicontrol(...
        handles.select_data_uipanel,...
        'BackgroundColor',[0.8 0.8 0.8],...
        'Style','radiobutton',...
        'String',[num2str(dataIndex), '-', dataName],...
        'HorizontalAlignment','left',...
        'Units',panel_unit,...
        'Visible',visibility,...
        'Position', [10 panel_pos(4)-15-dataIndex*30 panel_pos(3)-25 20]);
end

set(handles.select_data_uipanel,...
    'SelectionChangeFcn',@SelectionChangeFcn_Recon_select);

if dataNumber<=panel_max_lines
    set(handles.uipanel_Select_Recon_Slider,...
        'Visible','off');
else
    set(handles.uipanel_Select_Recon_Slider,...
        'Visible','on',...
        'Min',0,'Max',(dataNumber-panel_max_lines),...
        'Value',(dataNumber-panel_max_lines),...
        'Callback',{@uipanel_Select_Recon_slider_callback,...
        handles, panel_first_line_pos, panel_max_lines, panel_line_space},...
        'SliderStep',[1 1]./(dataNumber-panel_max_lines));
end

guidata(hObject, handles);


function Recon_Algo_Settings_h = reconParamsInputFieldsfunc(parent, slider, num_of_params, panel_max_lines, recon_settings, recon_settings_names, panel_line_space, panel_first_line_pos, panel_unit)

Recon_Algo_Settings_h=repmat(struct('h', matlab.ui.control.UIControl.empty()), [num_of_params, 1]);      % initializing struct array

for idx_param = 1:num_of_params
    if idx_param > panel_max_lines
        visibility='off';
    else
        visibility='on';
    end
    % descriptions
    Recon_Algo_Settings_h(idx_param).h = uicontrol(...
        parent,...
        'Style','text',...
        'String',recon_settings.(recon_settings_names{idx_param}).name,...
        'HorizontalAlignment','left',...
        'BackgroundColor',[0.8 0.8 0.8],...
        'TooltipString',recon_settings.(recon_settings_names{idx_param}).description,...
        'Units',panel_unit,...
        'Visible',visibility,...
        'Position', [10 panel_first_line_pos-idx_param*panel_line_space 150 20]);
    
    % input uicontrols
    if numel(recon_settings.(recon_settings_names{idx_param}).value) == 1
        Recon_Algo_Settings_h(idx_param).h(2) = uicontrol(...
            parent,...
            'Callback',{@set_Recon_Algo_Settings_value, recon_settings_names(idx_param), 1},...
            'Style','edit',...
            'String',num2str(recon_settings.(recon_settings_names{idx_param}).value),...
            'HorizontalAlignment','center',...
            'Units',panel_unit,...
            'Visible',visibility,...
            'Position', [220  panel_first_line_pos-idx_param*panel_line_space 50 20]);
    else
        Recon_Algo_Settings_h(idx_param).h(2) = uicontrol(...
            parent,...
            'Callback',{@set_Recon_Algo_Settings_value, recon_settings_names(idx_param), 1},...
            'Style','edit',...
            'String',num2str(recon_settings.(recon_settings_names{idx_param}).value(1)),...
            'HorizontalAlignment','center',...
            'Units',panel_unit,...
            'Visible',visibility,...
            'Position', [160  panel_first_line_pos-idx_param*panel_line_space 50 20]);
        Recon_Algo_Settings_h(idx_param).h(3) = uicontrol(...
            parent,...
            'Callback',{@set_Recon_Algo_Settings_value, recon_settings_names(idx_param), 2},...
            'Style','edit',...
            'String',num2str(recon_settings.(recon_settings_names{idx_param}).value(end)),...
            'HorizontalAlignment','center',...
            'Units',panel_unit,...
            'Visible',visibility,...
            'Position', [220  panel_first_line_pos-idx_param*panel_line_space 50 20]);
    end
end

if num_of_params<=panel_max_lines
    set(slider,...
        'Visible','off');
else
    set(slider,...
        'Visible','on',...
        'Min',0,'Max',(num_of_params-panel_max_lines),...
        'Value',(num_of_params-panel_max_lines),...
        'Callback',{@uipanel_Recon_Algo_Settings_slider_callback,...
        panel_first_line_pos, panel_max_lines, panel_line_space},...
        'SliderStep',[1 1]./(num_of_params-panel_max_lines));

% "handles" as an input is wrong, modified by NT on 1017.12.19.
%        'Callback',{@uipanel_Recon_Algo_Settings_slider_callback,...
%        handles, panel_first_line_pos, panel_max_lines, panel_line_space},...

end



function handles = setup_Select_Filter_Panel(hObject, eventdata, handles)

h = get(handles.uipanel_Select_Filter,'Children');
h(h == handles.uipanel_Select_Filter_Slider) = [];
delete(h);
handles.Filter_Select_Radiobutton_h = [];

if isempty(handles.analysisObjects)
   return 
end

panel_pos = get(handles.uipanel_Select_Filter,'Position');
panel_unit = get(handles.uipanel_Select_Filter,'Unit');

panel_line_space = 30;
panel_first_line_pos = panel_pos(4)-panel_line_space/2;
panel_max_lines = floor(panel_pos(4) / panel_line_space)-1;

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

% get all the filters
filteringSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering;
filterNames  = {filteringSettings.method};

num_of_filters = numel(filterNames);

if num_of_filters == 0
   return 
end

for idx_filter = 1:num_of_filters
    if idx_filter > panel_max_lines
        visibility='off';
    else
        visibility='on';
    end
    handles.Filter_Select_Radiobutton_h(idx_filter) = uicontrol(...
        handles.uipanel_Select_Filter,...
        'BackgroundColor',[0.8 0.8 0.8],...
        'Style','radiobutton',...
        'String',[num2str(idx_filter), ' - ', filterNames{idx_filter}],...
        'HorizontalAlignment','left',...
        'Units',panel_unit,...
        'Visible',visibility,...
        'Position', [10 panel_pos(4)-15-idx_filter*30 panel_pos(3)-25 20]);
end

set(handles.Filter_Select_Radiobutton_h(end), 'Value', 1)

set(handles.uipanel_Select_Filter,...
    'SelectionChangeFcn',@SelectionChangeFcn_Select_Filter);

if num_of_filters<=panel_max_lines
    set(handles.uipanel_Select_Filter_Slider,...
        'Visible','off');
else
    set(handles.uipanel_Select_Filter_Slider,...
        'Visible','on',...
        'Min',0,'Max',(num_of_filters-panel_max_lines),...
        'Value',(num_of_filters-panel_max_lines),...
        'Callback',{@uipanel_Select_Filter_Slider_callback,...
        handles, panel_first_line_pos, panel_max_lines, panel_line_space},...
        'SliderStep',[1 1]./(num_of_filters-panel_max_lines));
end

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

filterIndex = handles.selectedFilter{selected_channel}{selected_recon};
set(handles.Filter_Select_Radiobutton_h(filterIndex),'Value', 1);

guidata(hObject, handles);


function set_Filter_Settings_value(hObject, eventdata, param_name, idx, type)

handles = guidata(gcbo);

switch type
    case 'number'
        data_to_write = str2num(get(hObject,'String'));
    case 'text'
        data_to_write = get(hObject,'String');
    otherwise
        data_to_write = get(hObject,'String');
end

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
selected_filter = get_selected_Filter(handles);

param_fields_cell = {handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter).settings.thresholds.field};
param_idx = strcmp(param_name, param_fields_cell);
handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter).settings.thresholds(param_idx).bounds(idx) = data_to_write;

guidata(hObject, handles);


function set_Recon_Algo_Settings_value(hObject, eventdata, param_name, idx)

handles = guidata(gcbo);

data_to_write = str2double(get(hObject,'String'));

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization.settings.(param_name{1}).value(idx) = data_to_write;

guidata(hObject, handles);



function selected_filter = get_selected_Filter(handles)

if ~isfield(handles,'Filter_Select_Radiobutton_h')
    selected_filter=0;
    return
end
for selected_filter=1:numel(handles.Filter_Select_Radiobutton_h)
    if get(handles.Filter_Select_Radiobutton_h(selected_filter),'Value')==1
        break
    end
end


function selected_recon = get_selected_Recon(handles)

if ~isfield(handles,'Channel_Settings_Radiobutton_h')
    selected_recon=1;
    return
end
for selected_recon=1:numel(handles.Recon_Select_Radiobutton_h)
    if get(handles.Recon_Select_Radiobutton_h(selected_recon),'Value')==1
        break
    end
end
if isempty(selected_recon)
   selected_recon = 1; 
end


function selected_channel = get_selected_channel(handles)

if ~isfield(handles,'Channel_Settings_Radiobutton_h')
    selected_channel=1;
    return
end
for selected_channel=1:numel(handles.Channel_Settings_Radiobutton_h)
    if get(handles.Channel_Settings_Radiobutton_h(selected_channel),'Value')==1
        break
    end
end
if isempty(selected_channel)
   selected_channel = 1; 
end


function handles = resetExportPathFunc(hObject, eventdata, handles)
% hObject    handle to resetExportPath_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

handles.datasetSettings(selected_channel).exportPath = '';

set(handles.exportPath_text, 'String', '<dataset path>')

if isempty(handles.analysisObjects)
   return 
end

datasetPath = handles.analysisObjects(selected_channel).datasetPath;

set(handles.exportPath_text, 'Tooltip', datasetPath)

guidata(hObject, handles);


function ShowSupResImageFunc(hObject, eventdata, handles)
% hObject    handle to pushbutton_Show_SupRes_Image (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
selected_filter = get_selected_Filter(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

filteringOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter);
pointillisticDataObject.filter(filteringOperationSettings)

pixelizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization;
pixelizationOperationSettings = rainSTORM_GUI_settings_extract.operation(pixelizationOperationSettings);

visualizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).visualization;
visualizationOperationSettings = rainSTORM_GUI_settings_extract.operation(visualizationOperationSettings);

[localizationFigure, ~, ~] = pointillisticDataObject.pixelize_accepted(pixelizationOperationSettings, visualizationOperationSettings);

figure(localizationFigure);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% --- Executes during object creation, after setting all properties.
function popupmenu_Recon_Algo_Select_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_Recon_Algo_Select (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% disp('popupmenu1_CreateFcn')

% TODO1 sup-res image creation methods
% % %handles.algo_names_and_handles_recon = rainSTORM_default_settings_recon_algo;
% % %set(hObject,'String',handles.algo_names_and_handles_recon.names);

guidata(hObject, handles);


% --- Executes on button press in duplicate_data_pushbutton.
function duplicate_data_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to duplicate_data_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

analysisObject = handles.analysisObjects(selected_channel);

if isempty(analysisObject)
    return;
end

% duplicate the object of the pointillistic data within the dataset:
analysisObject.duplicatePointillisticData(selected_recon)
% duplicate the GUI settings too:
handles.datasetSettings(selected_channel).dataProcessing(end+1) = handles.datasetSettings(selected_channel).dataProcessing(selected_recon);

handles.selectedFilter{selected_channel}{end+1} = 1;

handles = updateSettingsFileText(hObject, eventdata, handles);
handles = updateExportPathText(hObject, eventdata, handles);

handles = setup_Select_Recon_Panel(hObject, eventdata, handles);

handles = setup_Select_Filter_Panel(hObject, eventdata, handles);

handles = setup_Filter_Settings_Panel(hObject, eventdata, handles);

guidata(hObject, handles);


% --- Executes on button press in remove_data_pushbutton.
function remove_data_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to remove_data_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

number_of_recons = numel(handles.Recon_Select_Radiobutton_h);
if number_of_recons>1

    analysisObject = handles.analysisObjects(selected_channel);
    
    delete(analysisObject.pointillisticDatas(selected_recon));
    
    analysisObject.pointillisticDatas(selected_recon) = [];
    analysisObject.deleteData(selected_recon, 'pointillisticData');
    
    handles.datasetSettings(selected_channel).dataProcessing(selected_recon) = [];
    
    delete(handles.Recon_Select_Radiobutton_h(selected_recon));
    handles.Recon_Select_Radiobutton_h(selected_recon) = [];
    guidata(hObject, handles);
else
    delete(handles.analysisObjects(selected_channel));
    handles.analysisObjects(selected_channel) = [];
    
    delete(handles.Channel_Settings_Radiobutton_h(selected_channel));
    handles.Channel_Settings_Radiobutton_h(selected_channel) = [];
    guidata(hObject, handles);
end

handles = setup_Select_Recon_Panel(hObject, eventdata, handles);

handles = setup_Select_Filter_Panel(hObject, eventdata, handles);

handles = setup_Filter_Settings_Panel(hObject, eventdata, handles);

guidata(hObject, handles);


% --- Executes on button press in pushbutton_Add_Filter.
function pushbutton_Add_Filter_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Add_Filter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon( handles);

if isempty(handles.analysisObjects)
    warning('Import some data first!')
   return 
end

contents = cellstr(get(handles.popupmenu_Add_Filter,'String'));
selectedFilterName = contents{get(handles.popupmenu_Add_Filter,'Value')};

chosenIndex = strcmp(handles.filteringNames, selectedFilterName);

if strcmp(selectedFilterName, 'Data Fields')
    % create filtering settings based on the convention definition
    % fields of the actual data:

    dataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);
    dataFieldNames = pointillisticData_fieldNameManagement.getFieldNames(dataObject.accepted);

    filteringSettings = filteringOperation.initializeFilteringSettings(dataFieldNames);

    handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(end+1) = filteringSettings;

else
    % add the filtering settings from the loaded settings
    chosenSettings = handles.filteringSettings{chosenIndex};

    handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(end+1) = chosenSettings;
end

handles = setup_Select_Filter_Panel(hObject, eventdata, handles);

handles = setup_Filter_Settings_Panel(hObject, eventdata, handles);

guidata(hObject, handles);


% --- Executes on button press in pushbutton_Remove_Filter.
function pushbutton_Remove_Filter_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Remove_Filter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

number_filters = numel(handles.Filter_Select_Radiobutton_h);

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
selected_filter = get_selected_Filter(handles);

handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter) = [];
handles.selectedFilter{selected_channel}{selected_recon} = max(selected_filter-1, 1);

handles = setup_Select_Filter_Panel(hObject, eventdata, handles);

handles = setup_Filter_Settings_Panel(hObject, eventdata, handles);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenu_Add_Filter_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_Add_Filter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

guidata(hObject, handles);


function popupmenu_Add_Filter_Callback(hObject, eventdata, handles)

guidata(hObject, handles);


% --- Executes on selection change in popupmenu_Recon_Algo_Select.
function popupmenu_Recon_Algo_Select_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_Recon_Algo_Select (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu_Recon_Algo_Select contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_Recon_Algo_Select

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

contents = cellstr(get(hObject,'String'));
chosenMethod = contents{get(hObject,'Value')};

handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization = rainSTORM_GUIsettings_pixelization.settings(chosenMethod);

handles = setup_Recon_Algo_Settings_Panel(hObject, eventdata, handles);

guidata(hObject, handles);


function SelectionChangeFcn_Channel_select(hObject, eventdata)

handles = guidata(gcbo);

handles = updateSettingsFileText(hObject, eventdata, handles);
handles = updateExportPathText(hObject, eventdata, handles);

handles = setup_Select_Recon_Panel(hObject, eventdata, handles);

handles = setup_Recon_Algo_Settings_Panel(hObject, eventdata, handles);

handles = setup_Drift_Correction_Settings(hObject, eventdata, handles);

handles = setup_Select_Filter_Panel(hObject, eventdata, handles);

handles = setup_Filter_Settings_Panel(hObject, eventdata, handles);

guidata(hObject, handles);


function SelectionChangeFcn_Recon_select(hObject, eventdata)

handles = guidata(gcbo);

handles = updateExportPathText(hObject, eventdata, handles);

handles = setup_Recon_Algo_Settings_Panel(hObject, eventdata, handles);

handles = setup_Drift_Correction_Settings(hObject, eventdata, handles);

handles = setup_Select_Filter_Panel(hObject, eventdata, handles);

handles = setup_Filter_Settings_Panel(hObject, eventdata, handles);

guidata(hObject, handles);


function uipanel_Select_Recon_slider_callback(hObject, eventdata, handles, panel_first_line_pos, panel_max_lines, panel_line_space)

val = get(hObject,'Value');

num_of_params = length(handles.Recon_Select_Radiobutton_h);
for idx_setting = 1:num_of_params
    %     for idx_component = 1:length(handles.Filter_Select_Radiobutton_h(idx_setting).h)
    h = handles.Recon_Select_Radiobutton_h(idx_setting);%.h(idx_component);
    pos = get(h,'Position');
    pos_new = panel_first_line_pos - idx_setting * panel_line_space + (num_of_params-panel_max_lines - val) * panel_line_space;
    pos(2) = pos_new;
    if (pos_new < panel_first_line_pos - panel_max_lines * panel_line_space) || (pos_new > panel_first_line_pos - panel_line_space)
        visibility='off';
    else
        visibility='on';
    end
    set(h,...
        'Position',pos,...
        'Visible',visibility);
    %     end
end

guidata(hObject, handles);


function SelectionChangeFcn_Select_Filter(hObject, eventdata)

handles = guidata(gcbo);

handles = setup_Filter_Settings_Panel(hObject, eventdata, handles);
guidata(hObject, handles);


function uipanel_Select_Filter_Slider_callback(hObject, eventdata, handles, panel_first_line_pos, panel_max_lines, panel_line_space)

val = get(hObject,'Value');

num_of_params = length(handles.Filter_Select_Radiobutton_h);
for idx_setting = 1:num_of_params
    %     for idx_component = 1:length(handles.Filter_Select_Radiobutton_h(idx_setting).h)
    h = handles.Filter_Select_Radiobutton_h(idx_setting);%.h(idx_component);
    pos = get(h,'Position');
    pos_new = panel_first_line_pos - idx_setting * panel_line_space + (num_of_params-panel_max_lines - val) * panel_line_space;
    pos(2) = pos_new;
    if (pos_new < panel_first_line_pos - panel_max_lines * panel_line_space) || (pos_new > panel_first_line_pos - panel_line_space)
        visibility='off';
    else
        visibility='on';
    end
    set(h,...
        'Position',pos,...
        'Visible',visibility);
    %     end
end

guidata(hObject, handles);


%function uipanel_Filter_Settings_slider_callback(hObject, eventdata, handles, panel_first_line_pos, panel_max_lines, panel_line_space)
% "handles" as an input is wrong, modified by NT on 2017.12.19.
function uipanel_Filter_Settings_slider_callback(hObject, eventdata, panel_first_line_pos, panel_max_lines, panel_line_space)

% the "handles" structure needs to be extracted this way, instead of
% passing as a function argument
% otherwise the manually set values overwritten by the original ones
% everytine one uses the slider, fuck it....
handles = guidata(gcbo);

% position of the slider
val = get(hObject,'Value');

% change the position of the elements
num_of_params = numel(handles.Filter_Settings_h);
for idx_setting = 1:num_of_params
    for idx_component = 1:numel(handles.Filter_Settings_h(idx_setting).h)
        h = handles.Filter_Settings_h(idx_setting).h(idx_component);
        pos = get(h,'Position');
        pos_new = panel_first_line_pos - idx_setting * panel_line_space + (num_of_params-panel_max_lines - val) * panel_line_space;
        pos(2) = pos_new;
        if (pos_new < panel_first_line_pos - panel_max_lines * panel_line_space) || (pos_new > panel_first_line_pos - panel_line_space)
            visibility='off';
        else
            visibility='on';
        end
        set(h,...
            'Position',pos,...
            'Visible',visibility);
    end
end

guidata(hObject, handles);


function uipanel_Recon_Algo_Settings_slider_callback(hObject, eventdata, panel_first_line_pos, panel_max_lines, panel_line_space)

% the "handles" structure needs to be extracted this way, instead of
% passing as a function argument
% otherwise the manually set values overwritten by the original ones
% everytine one uses the slider, fuck it....
handles = guidata(gcbo);

val = get(hObject,'Value');

num_of_params = numel(handles.Recon_Algo_Settings_h);
for idx_setting = 1:num_of_params
    for idx_component = 1:numel(handles.Recon_Algo_Settings_h(idx_setting).h)
        h = handles.Recon_Algo_Settings_h(idx_setting).h(idx_component);
        pos = get(h,'Position');
        pos_new = panel_first_line_pos - idx_setting * panel_line_space + (num_of_params-panel_max_lines - val) * panel_line_space;
        pos(2) = pos_new;
        if (pos_new < panel_first_line_pos - panel_max_lines * panel_line_space) || (pos_new > panel_first_line_pos - panel_line_space)
            visibility='off';
        else
            visibility='on';
        end
        set(h,...
            'Position',pos,...
            'Visible',visibility);
    end
end

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function select_data_uipanel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to select_data_uipanel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
% disp('uipanel_Select_Recon_CreateFcn')
handles.uipanel_Select_Recon_Slider = uicontrol('Style','Slider','Parent',hObject,...
    'Units','normalized','Position',[0.95 0 0.05 1],...
    'Visible','off',...
    'BackgroundColor',[0.8 0.8 0.8],...
    'Value',1);

guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function uipanel_Filter_Settings_CreateFcn(hObject, eventdata, handles)
% hObject    handle to uipanel_Filter_Settings (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
% disp(['uipanel_Filter_Settings_CreateFcn'])
handles.uipanel_Filter_Settings_slider = uicontrol('Style','Slider','Parent',hObject,...
    'Units','normalized','Position',[0.95 0 0.05 1],...
    'Visible','off',...
    'BackgroundColor',[0.8 0.8 0.8],...
    'Value',1);

guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function uipanel_Select_Filter_CreateFcn(hObject, eventdata, handles)
% hObject    handle to uipanel_Select_Filter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
% disp('uipanel_Select_Filter_CreateFcn')
handles.uipanel_Select_Filter_Slider = uicontrol('Style','Slider','Parent',hObject,...
    'Units','normalized','Position',[0.95 0 0.05 1],...
    'Visible','off',...
    'BackgroundColor',[0.8 0.8 0.8],...
    'Value',1);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function uipanel_Recon_Algo_Settings_CreateFcn(hObject, eventdata, handles)
% hObject    handle to uipanel_Recon_Algo_Settings (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
% disp('uipanel_Algo_Settings_CreateFcn')
handles.uipanel_Recon_Algo_Settings_slider = uicontrol('Style','Slider','Parent',hObject,...
    'Units','normalized','Position',[0.95 0 0.05 1],...
    'Visible','off',...
    'BackgroundColor',[0.8 0.8 0.8],...
    'Value',1);

guidata(hObject, handles);


% --- Executes on button press in pushbutton_Export_to_base.
function pushbutton_Export_to_base_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Export_to_base (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

assignin('base','analysisObjects',handles.analysisObjects);

guidata(hObject, handles);


% --- Executes on button press in pushbutton_Show_SupRes_Image.
function pushbutton_Show_SupRes_Image_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Show_SupRes_Image (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

ShowSupResImageFunc(hObject, eventdata, handles);

guidata(hObject,handles);


% --- Executes on button press in pushShowrejSupIm.
function pushShowrejSupIm_Callback(hObject, eventdata, handles)
% hObject    handle to pushShowrejSupIm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
selected_filter = get_selected_Filter(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

filteringOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter);
pointillisticDataObject.filter(filteringOperationSettings)

pixelizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization;
pixelizationOperationSettings = rainSTORM_GUI_settings_extract.operation(pixelizationOperationSettings);

visualizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).visualization;
visualizationOperationSettings = rainSTORM_GUI_settings_extract.operation(visualizationOperationSettings);

[localizationFigure, ~, ~] = pointillisticDataObject.pixelize_rejected(pixelizationOperationSettings, visualizationOperationSettings);

figure(localizationFigure);

guidata(hObject,handles);


% --- Executes on button press in pushbutton_Adjust_Contrast.
function pushbutton_Adjust_Contrast_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Adjust_Contrast (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Open imcontrast for figure.
h = imgcf;
try
    imcontrast(h);
catch
    ShowSupResImageFunc(hObject, eventdata, handles);
    h = imgcf;
    imcontrast(h);
end


% --- Executes on selection change in popupmenu_Colormap_Select.
function popupmenu_Colormap_Select_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_Colormap_Select (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu_Colormap_Select contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_Colormap_Select

% change to the selected colormaap:
contents = cellstr(get(hObject,'String'));
selectedColormap = contents{get(hObject,'Value')};

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
handles.datasetSettings(selected_channel).dataProcessing(selected_recon).visualization.settings.colormapName.value = selectedColormap;

guidata(hObject,handles);


% --- Executes during object creation, after setting all properties.
function popupmenu_Colormap_Select_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_Colormap_Select (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_View_Histograms.
function pushbutton_View_Histograms_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_View_Histograms (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
selected_filter = get_selected_Filter(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

filteringOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter);
pointillisticDataObject.filter(filteringOperationSettings);

histogramsFigure = pointillisticDataObject.createHistograms();

figure(histogramsFigure)

guidata(hObject,handles);


% --- Executes on button press in pushbutton_Remove_Drift_Correction.
function pushbutton_Remove_Drift_Correction_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Remove_Drift_Correction (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

pointillisticDataObject.undoDriftCorrection();

guidata(hObject,handles);



% --- Executes on button press in pushbutton_Report_Current_Recon.
function pushbutton_Report_Current_Recon_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Report_Current_Recon (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

convention = 'rainSTORM';

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
selected_filter = get_selected_Filter(handles);

subfolderFlag = get(handles.createSubfolder_checkbox,'Value');
processFlag = get(handles.processBeforeExport_checkbox,'Value');

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);


defaultExportPath = handles.datasetSettings(selected_channel).exportPath;
if isempty(defaultExportPath)
    defaultExportPath = handles.analysisObjects(selected_channel).datasetPath;
end
dataName = pointillisticDataObject.dataName;
defaultFullFile = fullfile(defaultExportPath, [dataName, '.csv']);

% let the user choose the name to save the data
[exportName, exportPath, ~] = uiputfile({'*.csv', 'Coma Separated Value file'}, 'Save selected data', defaultFullFile);
% reomve the extension:
[~, exportName, ~] = fileparts(exportName);


% in case the user pressed the "cancel" button
if ~ischar(exportName)
    if exportName == 0
        return
    end  
end
if ~ischar(exportPath)
    if exportPath == 0
        return
    end  
end

filteringOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter);

driftCorrectionOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).driftCorrection;
driftCorrectionOperationSettings = rainSTORM_GUI_settings_extract.operation(driftCorrectionOperationSettings);

pixelizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization;
pixelizationOperationSettings = rainSTORM_GUI_settings_extract.operation(pixelizationOperationSettings);

visualizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).visualization;
visualizationOperationSettings = rainSTORM_GUI_settings_extract.operation(visualizationOperationSettings);

if processFlag
    pointillisticDataObject.filter(filteringOperationSettings);
    pointillisticDataObject.correctDrift(driftCorrectionOperationSettings);
end

handles.analysisObjects(selected_channel).dataExport(selected_recon, exportPath, exportName, subfolderFlag, convention);

handles.analysisObjects(selected_channel).operations.localizationData.processing.pixelization = pixelizationOperationSettings;
handles.analysisObjects(selected_channel).operations.localizationData.processing.visualization = visualizationOperationSettings;
handles.analysisObjects(selected_channel).figuresExport(selected_recon, exportPath, exportName, subfolderFlag);

% save the sum image, if it exist, with pixel size corresponding to that
% of the super-resolved image
prevSF = [];
handles.analysisObjects(selected_channel).saveSumImage(selected_recon, prevSF, exportPath, exportName, subfolderFlag)

% --- Executes on button press in pushbutton_Report_All_Recons.
function pushbutton_Report_All_Recons_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Report_All_Recons (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

convention = 'rainSTORM';

selected_channel = get_selected_channel(handles);

subfolderFlag = get(handles.createSubfolder_checkbox,'Value');
processFlag = get(handles.processBeforeExport_checkbox,'Value');

for dataIndex = 1:numel(handles.analysisObjects(selected_channel).pointillisticDatas)
    
    filterIndex = handles.selectedFilter{selected_channel}{dataIndex};
    
    pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(dataIndex);
    
    filteringOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(dataIndex).filtering(filterIndex);

    driftCorrectionOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(dataIndex).driftCorrection;
    driftCorrectionOperationSettings = rainSTORM_GUI_settings_extract.operation(driftCorrectionOperationSettings);

    pixelizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(dataIndex).pixelization;
    pixelizationOperationSettings = rainSTORM_GUI_settings_extract.operation(pixelizationOperationSettings);

    visualizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(dataIndex).visualization;
    visualizationOperationSettings = rainSTORM_GUI_settings_extract.operation(visualizationOperationSettings);

    if processFlag
        pointillisticDataObject.filter(filteringOperationSettings);
        pointillisticDataObject.correctDrift(driftCorrectionOperationSettings);
    end

    exportPath = handles.datasetSettings(selected_channel).exportPath;
    
    % give an empty name, so the analysisObjects will name it 
    exportName = '';
    % this way the saved data should be numbered to prevent overwrite
    
    handles.analysisObjects(selected_channel).dataExport(dataIndex, exportPath, exportName, subfolderFlag, convention);
    
    handles.analysisObjects(selected_channel).operations.localizationData.processing.pixelization = pixelizationOperationSettings;
    handles.analysisObjects(selected_channel).operations.localizationData.processing.visualization = visualizationOperationSettings;
    handles.analysisObjects(selected_channel).figuresExport(dataIndex, exportPath, exportName, subfolderFlag);
    
    % save the sum image, if it exist, with pixel size corresponding to that
    % of the super-resolved image
    prevSF = [];
    handles.analysisObjects(selected_channel).saveSumImage(dataIndex, prevSF, exportPath, exportName, subfolderFlag)
    
end


% --- Executes on button press in exportAllChannel_pushbutton.
function exportAllChannel_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to exportAllChannel_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

convention = 'rainSTORM';

subfolderFlag = get(handles.createSubfolder_checkbox,'Value');
processFlag = get(handles.processBeforeExport_checkbox,'Value');

for idxChannel = 1:numel(handles.Channel_Settings_Radiobutton_h)
    for dataIndex = 1:numel(handles.analysisObjects(idxChannel).pointillisticDatas)
        
        filterIndex = handles.selectedFilter{idxChannel}{dataIndex};
        
        pointillisticDataObject = handles.analysisObjects(idxChannel).pointillisticDatas(dataIndex);
        
        filteringOperationSettings = handles.datasetSettings(idxChannel).dataProcessing(dataIndex).filtering(filterIndex);

        driftCorrectionOperationSettings = handles.datasetSettings(idxChannel).dataProcessing(dataIndex).driftCorrection;
        driftCorrectionOperationSettings = rainSTORM_GUI_settings_extract.operation(driftCorrectionOperationSettings);

        pixelizationOperationSettings = handles.datasetSettings(idxChannel).dataProcessing(dataIndex).pixelization;
        pixelizationOperationSettings = rainSTORM_GUI_settings_extract.operation(pixelizationOperationSettings);

        visualizationOperationSettings = handles.datasetSettings(idxChannel).dataProcessing(dataIndex).visualization;
        visualizationOperationSettings = rainSTORM_GUI_settings_extract.operation(visualizationOperationSettings);

        if processFlag
            pointillisticDataObject.filter(filteringOperationSettings);
            pointillisticDataObject.correctDrift(driftCorrectionOperationSettings);
        end

        exportPath = handles.datasetSettings(idxChannel).exportPath;
        
        % give an empty name, so the analysisObjects will name it 
        exportName = '';
        % this way the saved data should be numbered to prevent overwrite
        
        handles.analysisObjects(idxChannel).dataExport(dataIndex, exportPath, exportName, subfolderFlag, convention);
        
        handles.analysisObjects(idxChannel).operations.localizationData.processing.pixelization = pixelizationOperationSettings;
        handles.analysisObjects(idxChannel).operations.localizationData.processing.visualization = visualizationOperationSettings;
        handles.analysisObjects(idxChannel).figuresExport(dataIndex, exportPath, exportName, subfolderFlag);
        
        % save the sum image, if it exist, with pixel size corresponding to that
        % of the super-resolved image
        prevSF = [];
        handles.analysisObjects(idxChannel).saveSumImage(dataIndex, prevSF, exportPath, exportName, subfolderFlag)
    end
end


% --- Executes on button press in pushbutton_Open_Merge_Tool.
function pushbutton_Open_Merge_Tool_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Open_Merge_Tool (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% merges the gray scale super resolved image of two color channel into an
% RGB one
% TODO: keep it????
rainSTORM_Merge_Tool(handles.params);


% --- Executes on button press in pushbutton_Correct_Drift.
function pushbutton_Correct_Drift_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Correct_Drift (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

driftCorrectionOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).driftCorrection;
driftCorrectionOperationSettings = rainSTORM_GUI_settings_extract.operation(driftCorrectionOperationSettings);

driftTrajectory = pointillisticDataObject.correctDrift(driftCorrectionOperationSettings);

driftFigure = driftCorrection.visualize(driftTrajectory);

figure(driftFigure);

guidata(hObject, handles);


% --- Executes on button press in show_total_drift_pushbutton.
function show_total_drift_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to show_total_drift_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

driftFigure = pointillisticDataObject.driftVisualization();
if ~isempty(driftFigure)
    % The "figure" function cannot handle empty figure object, it throws an
    % error....
    figure(driftFigure);
end

% --- Executes on button press in bridgeTracker.
function bridgeTracker_Callback(hObject, eventdata, handles)
% hObject    handle to bridgeTracker (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

pixelizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization;
pixelizationOperationSettings = rainSTORM_GUI_settings_extract.operation(pixelizationOperationSettings);
visualizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).visualization;
visualizationOperationSettings = rainSTORM_GUI_settings_extract.operation(visualizationOperationSettings);

pointillisticData = pointillisticDataObject.accepted;
supResFigHandle = pointillisticDataObject.visualize_accepted(pixelizationOperationSettings, visualizationOperationSettings);
cameraSignalConversion = pointillisticDataObject.analysisParameters.sharedParameters.cameraSignalConversion;
rainSTORM_bridgeTracker(pointillisticData, supResFigHandle, cameraSignalConversion)

guidata(hObject, handles);


% --- Executes on button press in histtracker.
function histtracker_Callback(hObject, eventdata, handles)
% hObject    handle to histtracker (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

pixelizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization;
pixelizationOperationSettings = rainSTORM_GUI_settings_extract.operation(pixelizationOperationSettings);
visualizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).visualization;
visualizationOperationSettings = rainSTORM_GUI_settings_extract.operation(visualizationOperationSettings);

pointillisticData = pointillisticDataObject.accepted;
supResFigHandle = pointillisticDataObject.visualize_accepted(pixelizationOperationSettings, visualizationOperationSettings);
cameraSignalConversion = pointillisticDataObject.analysisParameters.sharedParameters.cameraSignalConversion;

rainSTORM_histogramTracker(pointillisticData, supResFigHandle, cameraSignalConversion)

guidata(hObject, handles);


% --- Executes on button press in pushSectionExport.
function pushSectionExport_Callback(hObject, eventdata, handles)
% hObject    handle to pushSectionExport (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

pixelizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization;
pixelizationOperationSettings = rainSTORM_GUI_settings_extract.operation(pixelizationOperationSettings);
visualizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).visualization;
visualizationOperationSettings = rainSTORM_GUI_settings_extract.operation(visualizationOperationSettings);

pointillisticData = pointillisticDataObject.accepted;
supResFigHandle = pointillisticDataObject.visualize_accepted(pixelizationOperationSettings, visualizationOperationSettings);
cameraSignalConversion = pointillisticDataObject.analysisParameters.sharedParameters.cameraSignalConversion;

exportPath = handles.analysisObjects(selected_channel).datasetPath;
exportName = pointillisticDataObject.dataName;
rawData_fullFilename = fullfile(exportPath, exportName);
rainSTORM_exportTracker(pointillisticData, rawData_fullFilename, supResFigHandle, cameraSignalConversion)

guidata(hObject, handles);



% --- Executes on button press in dataImport_pushbutton.
function dataImport_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to dataImport_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

contents = cellstr(get(handles.dataImport_popupmenu,'String'));
selectedConvention = contents{get(handles.dataImport_popupmenu,'Value')};

dataFileFullNameList = pointillisticData_selection.multiple();


defaultSettings_file = get(handles.imported_settings_text, 'Tooltip');

if ~isempty(defaultSettings_file)
    % load the new settings:
    
    importedDefaultSettings = importSettings(defaultSettings_file);
    
    new_defaultSettings.settingsFile = defaultSettings_file;
    new_defaultSettings.exportPath = '';
    new_defaultSettings.dataProcessing = importedDefaultSettings;
    
    new_datasetSettings = new_defaultSettings;
    new_datasetSettings.exportPath = handles.datasetSettings(selected_channel).exportPath;
    
else
    % inherit the actual settings:
    new_defaultSettings = handles.defaultSettings(selected_channel);
    
    new_datasetSettings = handles.datasetSettings(selected_channel);
    new_datasetSettings.settingsFile = handles.datasetSettings(selected_channel).settingsFile;
    new_datasetSettings.exportPath = handles.datasetSettings(selected_channel).exportPath;
    new_datasetSettings.dataProcessing = handles.datasetSettings(selected_channel).dataProcessing(selected_recon);
end


for idxFile = 1:numel(dataFileFullNameList)
    new_analysisObject =  analysisClass();
    
    lastIndex = numel(handles.analysisObjects);
    

    
    
    % inherit the actual settings:
    handles.defaultSettings(lastIndex+1) = new_defaultSettings;
    handles.datasetSettings(lastIndex+1) = new_datasetSettings;
    
    operationSettingsFullFile = handles.datasetSettings(lastIndex+1).settingsFile;
    new_analysisObject.loadOperationSettings(operationSettingsFullFile);
    new_analysisObject.localizationDataImport(dataFileFullNameList{idxFile}, selectedConvention);
    
    handles.analysisObjects(lastIndex+1) = new_analysisObject;
    
    idxData = 1;
    handles.selectedFilter{lastIndex+1}{idxData} = 1;
end

handles = updateSettingsFileText(hObject, eventdata, handles);
handles = updateExportPathText(hObject, eventdata, handles);

handles = setup_Channel_Select_Panel(hObject, eventdata, handles);

handles = setup_Select_Recon_Panel(hObject, eventdata, handles);

handles = setup_Recon_Algo_Settings_Panel(hObject, eventdata, handles);

handles = setup_Drift_Correction_Settings(hObject, eventdata, handles);

handles = setup_Select_Filter_Panel(hObject, eventdata, handles);

handles = setup_Filter_Settings_Panel(hObject, eventdata, handles);

handles = resetExportPathFunc(hObject, eventdata, handles);

guidata(hObject, handles);



% --- Executes on selection change in dataImport_popupmenu.
function dataImport_popupmenu_Callback(hObject, eventdata, handles)
% hObject    handle to dataImport_popupmenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns dataImport_popupmenu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from dataImport_popupmenu


% --- Executes during object creation, after setting all properties.
function dataImport_popupmenu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to dataImport_popupmenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

set(hObject,'String',conventionFunctions.conventionList());

guidata(hObject, handles);


% --- Executes on button press in processBeforeExport_radiobutton.
function processBeforeExport_radiobutton_Callback(hObject, eventdata, handles)
% hObject    handle to processBeforeExport_radiobutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of processBeforeExport_radiobutton


% --- Executes on button press in resetExportPath_pushbutton.
function resetExportPath_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to resetExportPath_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles = resetExportPathFunc(hObject, eventdata, handles);

guidata(hObject, handles);


% --- Executes on button press in dataExportPath_pushbutton.
function dataExportPath_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to dataExportPath_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
exportPath = uigetdir('', 'Select a folder for data export');

if exportPath == 0
   return 
end

handles.defaultSettings(selected_channel).exportPath = exportPath;
handles.datasetSettings(selected_channel).exportPath = exportPath;

handles = updateExportPathText(hObject, eventdata, handles);

guidata(hObject, handles);


% --- Executes on button press in createSubfolder_radiobutton.
function createSubfolder_radiobutton_Callback(hObject, eventdata, handles)
% hObject    handle to createSubfolder_radiobutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of createSubfolder_radiobutton


% --- Executes on selection change in Drift_Algorithm_Selection_popupmenu.
function Drift_Algorithm_Selection_popupmenu_Callback(hObject, eventdata, handles)
% hObject    handle to Drift_Algorithm_Selection_popupmenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Drift_Algorithm_Selection_popupmenu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Drift_Algorithm_Selection_popupmenu

contents = cellstr(get(hObject,'String'));
chosenMethod = contents{get(hObject,'Value')};

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

handles.datasetSettings(selected_channel).dataProcessing(selected_recon).driftCorrection = rainSTORM_GUIsettings_driftCorrection.settings(chosenMethod);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Drift_Algorithm_Selection_popupmenu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Drift_Algorithm_Selection_popupmenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton54.
function pushbutton54_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton54 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

setup_Concatenation_Settings_Panel(hObject, eventdata, handles);

guidata(hObject, handles);


function handles = setup_Concatenation_Settings_Panel(hObject, eventdata, handles)
% This function creates the GUI elements on the reconstruction settings panel

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

concatenationOperation = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).concatenation;
pixelizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).pixelization;
pixelizationOperationSettings = rainSTORM_GUI_settings_extract.operation(pixelizationOperationSettings);
visualizationOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).visualization;
visualizationOperationSettings = rainSTORM_GUI_settings_extract.operation(visualizationOperationSettings);


concatenationObject = rainSTORM_GUI_concatenation();
concatenationObject.create(pointillisticDataObject, concatenationOperation, pixelizationOperationSettings, visualizationOperationSettings);

delete(concatenationObject);
% it also deletes the trajectory data because I have no idea what to do with it
% after closed the window

guidata(hObject, handles);


% --- Executes on button press in astigmatic3D_calibration_pushbutton.
function astigmatic3D_calibration_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to astigmatic3D_calibration_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
selected_filter = get_selected_Filter(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

filteringOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter);
pointillisticDataObject.filter(filteringOperationSettings);

rainSTORM_GUI_astigmatic3D_calibration(pointillisticDataObject)



% --- Executes on button press in astigmatic3D_calculation_pushbutton.
function astigmatic3D_calculation_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to astigmatic3D_calculation_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);
selected_filter = get_selected_Filter(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

filteringOperationSettings = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).filtering(selected_filter);
pointillisticDataObject.filter(filteringOperationSettings);

astigmatic3DOperation = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).astigmatic3D;

astigmatic3DObject = rainSTORM_GUI_astigmatic3D_calculation();
pointillisticDataObject = astigmatic3DObject.create(pointillisticDataObject, astigmatic3DOperation);

delete(astigmatic3DObject);

handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon) = pointillisticDataObject;


% --- Executes on button press in pushbutton57.
function pushbutton57_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton57 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);
selected_recon = get_selected_Recon(handles);

pointillisticDataObject = handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon);

clusterizationOperation = handles.datasetSettings(selected_channel).dataProcessing(selected_recon).clusterization;

clusterAnalysisObject = rainSTORM_GUI_clusterAnalysis();
pointillisticDataObject = clusterAnalysisObject.create(pointillisticDataObject, clusterizationOperation);

delete(clusterAnalysisObject);

handles.analysisObjects(selected_channel).pointillisticDatas(selected_recon) = pointillisticDataObject;


% --- Executes on button press in settings_import_pushbutton.
function settings_import_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to settings_import_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_channel = get_selected_channel(handles);

currentSettingsPath = fileparts(handles.datasetSettings(selected_channel).settingsFile);

[FILENAME, PATHNAME] = uigetfile({'*.json', 'JSON'}, 'Choose a settings file', currentSettingsPath);

if FILENAME == 0
   return 
end

settingsFileFullName = fullfile(PATHNAME, FILENAME);

importedDataProcessing = importSettings(settingsFileFullName);

handles.defaultSettings(selected_channel).settingsFile = settingsFileFullName;
handles.defaultSettings(selected_channel).dataProcessing = importedDataProcessing;
handles.datasetSettings(selected_channel).settingsFile = settingsFileFullName;
% change all data settings in the dataset to the imported one
for idxData = numel(handles.datasetSettings(selected_channel).dataProcessing)
    handles.datasetSettings(selected_channel).dataProcessing(idxData) = importedDataProcessing;
end

handles = updateSettingsFileText(hObject, eventdata, handles);

handles = setup_Recon_Algo_Settings_Panel(hObject, eventdata, handles);

handles = setup_Drift_Correction_Settings(hObject, eventdata, handles);

handles = setup_Select_Filter_Panel(hObject, eventdata, handles);

handles = setup_Filter_Settings_Panel(hObject, eventdata, handles);

guidata(hObject, handles);



% probably obbsolete stuff:


function rearrange_radiobuttons_Recon(hObject, eventdata, handles)

num_of_recons=length(handles.Recon_Select_Radiobutton_h);
panel_pos = get(handles.select_data_uipanel,'Position');
panel_unit = get(handles.select_data_uipanel,'Unit');
for idx_radiobutton=1:num_of_recons
    if idx_radiobutton <= 7
        visibility = 'on';
    else
        visibility = 'off';
    end
    position = get(handles.Recon_Select_Radiobutton_h(idx_radiobutton),'Position');
    position(2) = panel_pos(4)-15-idx_radiobutton*30;
    set(handles.Recon_Select_Radiobutton_h(idx_radiobutton),...
        'Position',position,...
        'Visible',visibility);
end

if num_of_recons<7
    set(handles.uipanel_Select_Recon_Slider,'Visible','off');
end

guidata(hObject, handles);


function rearrange_radiobuttons_Filters(hObject, eventdata, handles)

num_of_filters=length(handles.Filter_Select_Radiobutton_h);
panel_pos = get(handles.uipanel_Select_Filter,'Position');
panel_unit = get(handles.uipanel_Select_Filter,'Unit');
for idx_radiobutton=1:num_of_filters
    if idx_radiobutton <= 7
        visibility = 'on';
    else
        visibility = 'off';
    end
    position = get(handles.Filter_Select_Radiobutton_h(idx_radiobutton),'Position');
    position(2) = panel_pos(4)-15-idx_radiobutton*30;
    set(handles.Filter_Select_Radiobutton_h(idx_radiobutton),...
        'Position',position,...
        'Visible',visibility);
end
if num_of_filters <= 7
    set(handles.uipanel_Select_Filter_Slider,'Visible','off');
end

guidata(hObject, handles);


% --- Executes on button press in createSubfolder_checkbox.
function createSubfolder_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to createSubfolder_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of createSubfolder_checkbox


% --- Executes on button press in processBeforeExport_checkbox.
function processBeforeExport_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to processBeforeExport_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of processBeforeExport_checkbox


% --- Executes during object creation, after setting all properties.
function imported_settings_text_CreateFcn(hObject, eventdata, handles)
% hObject    handle to imported_settings_text (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
