function [quantDistribution, histEdges]=rainSTORM_traj_calcHistData(quantity, histIntegersBool, binMin, binMax, varargin)
% 	Summary:	
%	Version:    3.2	
%	Note:		
%	Package:	rainSTORM v3.1+
%	Developer:	novakt
%	Name:		Novák Tibor
%	Company:	University of Szeged
%	Date of the merger: 2017.11.08.	

% Function for calculating the histogram data for the given quatity.

% parents: rainSTORM_traj_calcImagePlotQuantity, rainSTORM_traj_photophysicsHist
% children:

if ~histIntegersBool
    NBins=varargin{1};
    
    binEdges = linspace(binMin, binMax, NBins+1);	% create bins
    [quantDistribution, histEdges]=histcounts(quantity,binEdges);
else
    % if the quantity to plot is the "frame
    % duration" then the "integers" option
    % should be used for the histogram
    % data creation and the histogram
    % "edges should be corrigated"
    [quantDistribution, histEdges]=histcounts(quantity, 'BinMethod', 'integers', 'BinLimits', [binMin, binMax]);
    histEdges=histEdges-0.5;
end


end

