function F=rainSTORM_traj_exponentialToFit(expParams, frameDurationBool, histTrajN, histValues, iterBool, varargin)
% 	Summary:	
%	Version:    3.2	
%	Note:		
%	Package:	rainSTORM v3.1+
%	Developer:	novakt
%	Name:		Novák Tibor
%	Company:	University of Szeged
%	Date of the merger: 2017.11.08.	

% Function for the exponential fit. It fits a discretized
% (integrated over the bins) exponential functions on the bins and
% values of the histogram data of the trajectories. THe total area
% under the function in the considered region (determined by the bins)
% must equal that of the number of accounted trajectories.

% parents: rainSTORM_traj_calcImagePlotQuantity
% children: -

% determining haw many exponential shold be fit
switch length(expParams)
    case 1  % one exponential
        expDecay=expParams; % decay rate
        weight=1;           % the area under the fitted exponential should be the as the under the histogram
        % the fitted exponential
        [frameNProbability_normalized, initVal]=calcExponentialFunction(expDecay, frameDurationBool, histTrajN, weight, varargin{:});
    case 3  % two exponentials
        expDecay_1=expParams(1);    % decay rate
        weight_1=1-expParams(3);    % the area ratio of the fitted exponential and the histogram
        % one of the the fitted exponentials
        [frameNProbability_normalized_1, initVal1]=calcExponentialFunction(expDecay_1, frameDurationBool, histTrajN, weight_1, varargin{:});
        expDecay_2=expParams(2);    % decay rate
        weight_2=expParams(3);      % the area ratio of the fitted exponential and the histogram
        % the other fitted exponential
        [frameNProbability_normalized_2, initVal2]=calcExponentialFunction(expDecay_2, frameDurationBool, histTrajN, weight_2, varargin{:});
        % the resultent function is the sum of the two exponentials
        frameNProbability_normalized=frameNProbability_normalized_1+frameNProbability_normalized_2;
        initVal=[initVal1, initVal2];
    otherwise
        error('Wrong number of exponential parameters.')
end

if iterBool
    % The residuum between the histogram of the measurement and the
    % exponential to be fit
    F=sum((histValues-frameNProbability_normalized).^2)/sum(histValues)^2;
else
    
    if length(varargin)==2
        frameNVect=varargin{1}:varargin{2};
    else
        error('Something is wrong with "varargin".')
    end
    
    % Initial value (at "x=0") of the exponential
    F=initVal;
    
    figure(25)
    plot(frameNVect, histValues, '-d', 'Color', 'b', 'MarkerFaceColor', 'b', 'MarkerSize', 5)
    hold on;
    plot(frameNVect, frameNProbability_normalized, '-v', 'Color', 'r', 'MarkerFaceColor', 'r', 'MarkerSize', 5)
    hold off;
    axis([varargin{1},varargin{2}, -Inf, Inf])
    
    title('Histogram of frame durations');
    xlabel('frame duration')
    ylabel('number of trajectories');
    legend('measured','fitted exponential');
    
    labelXPos=[0.35];
    labelYPos=[0.75];
    switch length(expParams)
        case 1  % one exponential
            labelText={['expected frame duration: ', sprintf('%.4g', 1/expDecay)]};
        case 2
            labelText={['expected frame duration: ', sprintf('%.4g/%.4g/%.4g', 1/expDecay_1, 1/expDecay_2, expParams(3))]};
    end
    text( labelXPos, labelYPos, labelText, 'Units', 'normalized')

end
    

    function [frameNProbability_normalized, initVal]=calcExponentialFunction(expDecay, frameDurationBool, histTrajN, weight, varargin)
        
        switch frameDurationBool
            case false
                histEdges=varargin{1};
                % Normal analitical integrations over the bins. The area under
                % the exponential to be fit is equal to the number of accounted
                % trajectories
                initVal=histTrajN*weight/(exp(-expDecay*histEdges(end))-exp(-expDecay*histEdges(1)));   % the initial value and the normalization factor (the area under the exponential should match that of the histogram)
                frameNProbability_normalized=initVal*(exp(-expDecay*histEdges(2:end))-exp(-expDecay*histEdges(1:end-1)));
            case true
                %% Initializing constants
                % minimal number of frames on the histogram
                frameNMin=varargin{1};
                % maximal number of frames on the histogram
                frameNMax=varargin{2};
                % frame time
                frameTime=1;                        % let fit the lifetime in frame duration number and not in seconds
                % time duration where
                acquisitionTime=frameTime*0.05;     % let it be
                % minimum emission time thet provides the sufficient minimal number of photons for localization
                minDetEmTime=frameTime*0.05;        % let it be
                
                if frameNMin<1
                    warning('The minimal frame duration should not be smaller than "1"')
                end
                
                NMin_frameNMin_shift=-2;
                NMax_frameNMax_shift=1;
                
                % let "N" donate to the floor(t/frameTime) and , let "t"
                % donate to the time duration of the emission
                NMin=(frameNMin+NMin_frameNMin_shift);
                NMax=(frameNMax+NMax_frameNMax_shift);
                
                % time interval within if the end of the trajectory falls, then it is not
                % detected on the that frame (let this time interval be placed on the
                % beginning of every frame), blind time
                H=acquisitionTime+2*minDetEmTime;
                
                % vector containing the lower limits of integration, where the length
                % of the emission is "N*frameTime<t<N*frameTime+H"
                N_vect=NMin:1:NMax-1;
                TLowerLimit_vect=N_vect*frameTime;
                
                % integration should not start from "0" but from the "minDetEmTime" as
                % blinking shorter than this, can not be localized at all
                TLowerLimit_vect_mod=TLowerLimit_vect;
                TLowerLimit_vect_mod(N_vect==0)=minDetEmTime;
                
                % vector containing the upper limits of integration, where the length
                % of the emission is
                % "N*frameTime<t<N*frameTime+H", and the
                % lower limit of the other integration
                T_H_vect=TLowerLimit_vect+H;
                % vector containing the upper limits of integration, where the length
                % of the emission is
                % "N*frameTime+H<t<(N+1)*frameTime"
                TUpperLimit_vect=TLowerLimit_vect+frameTime;
                
                %% Integrations (ananlytical) for the frame number probability
                % constant for the frame duration probability, if
                % "N*frameTime<t<N+H"
                c1_withinH_vect=(TLowerLimit_vect+H)/frameTime;
                c2_withinH_vect=1-c1_withinH_vect;
                
                % constant for the frame duration probability, if
                % "N*frameTime+H<t<(N+1)*frameTime"
                c2_outsideH_vect=(TUpperLimit_vect+H)/frameTime;
                c3_outsideH_vect=1-c2_outsideH_vect;
                
                % integrals of the exponentials evaluated at the different integral limits
                exp_TLower_vect=-expDecay*exp(-expDecay*TLowerLimit_vect_mod)/expDecay;
                exp_T_H_vect=-expDecay*exp(-expDecay*T_H_vect)/expDecay;
                exp_TUpper_vect=-expDecay*exp(-expDecay*TUpperLimit_vect)/expDecay;
                
                % integrals, that starts in the negative regime, should not be accounted for
                exp_TLower_vect(N_vect<0)=0;
                exp_T_H_vect(N_vect<0)=0;
                exp_TUpper_vect(N_vect<0)=0;
                
                % probability of the trajectory that it resides on "floor(t/frameTime)"
                % number of frames, if
                % "N*frameTime<t<N*frameTime+H"
                p1_withinH_vect=...
                    (c1_withinH_vect-(T_H_vect+1/expDecay)/frameTime).*exp_T_H_vect...
                    -(c1_withinH_vect-(TLowerLimit_vect_mod+1/expDecay)/frameTime).*exp_TLower_vect;
                
                % probability of the trajectory that it resides on "floor(t/frameTime)+1"
                % number of frames, if
                % "N*frameTime<t<N*frameTime+H"
                p2_withinH_vect=...
                    (c2_withinH_vect+(T_H_vect+1/expDecay)/frameTime).*exp_T_H_vect...
                    -(c2_withinH_vect+(TLowerLimit_vect_mod+1/expDecay)/frameTime).*exp_TLower_vect;
                
                
                % probability of the trajectory that it resides on "floor(t/frameTime)+1"
                % number of frames, if
                % "N*frameTime+H<t<(N+1)*frameTime"
                p2_outsideH_vect=...
                    (c2_outsideH_vect-(TUpperLimit_vect+1/expDecay)/frameTime).*exp_TUpper_vect...
                    -(c2_outsideH_vect-(T_H_vect+1/expDecay)/frameTime).*exp_T_H_vect;
                % probability of the trajectory that it resides on "floor(t/frameTime)+2"
                % number of frames, if
                % "N*frameTime+H<t<(N+1)*frameTime"
                p3_outsideH_vect=...
                    (c3_outsideH_vect+(TUpperLimit_vect+1/expDecay)/frameTime).*exp_TUpper_vect...
                    -(c3_outsideH_vect+(T_H_vect+1/expDecay)/frameTime).*exp_T_H_vect;
                
                %% Calculating the frame number probabilities
                % probabilty of the different frame durations
                frameNProbability=p1_withinH_vect(1-NMin_frameNMin_shift:end)...
                    +p2_withinH_vect(1-NMin_frameNMin_shift-1:end-1)...
                    +p2_outsideH_vect(1-NMin_frameNMin_shift-1:end-1)...
                    +p3_outsideH_vect(1-NMin_frameNMin_shift-2:end-2);
                
                % make sure that the function to fit results in the same number of
                % localization as the measurement
                initVal=histTrajN*weight/sum(frameNProbability);   % the initial value and the normalization factor (the area under the exponential should match that of the histogram)
                frameNProbability_normalized=initVal*frameNProbability;
                
                %% For testing
                %histEdges=linspace(frameNMin-0.5,frameNMax+0.5, frameNMax-frameNMin+2);
                %frameNProbability_normalized=histTrajN/(exp(-expDecay*histEdges(end))-exp(-expDecay*histEdges(1)))*(exp(-expDecay*histEdges(2:end))-exp(-expDecay*histEdges(1:end-1)));
                %histogram('BinCounts', frameNProbability_normalized, 'BinEdges', histEdges)
                
                % figure()
                % scatter(frameN_vect, frameNProbability)
                
                % % frame duration probability, for fixed "t", if
                % % "N*frameTime<t<N*frameTime+H"
                % t=(NMin:0.01:NMin+2)*frameTime;
                %
                % p1_withinH_test=(c1_withinH_vect(floor(t/frameTime)+1)-(t)/frameTime);
                % p2_withinH_test=(c2_withinH_vect(floor(t/frameTime)+1)+(t)/frameTime);
                %
                % p2_outsideH_vect_test=(c2_outsideH_vect(floor(t/frameTime)+1)-(t)/frameTime);
                % p3_outsideH_vect_test=(c3_outsideH_vect(floor(t/frameTime)+1)+(t)/frameTime);
                %
                % figure()
                % plot(t, p1_withinH_test, t, p2_withinH_test)
                % figure()
                % plot(t, p2_withinH_test, t, p2_outsideH_vect_test)
                % figure()
                % plot(t, p2_outsideH_vect_test, t, p3_outsideH_vect_test)
                
                
        end
        
        
    end

end

