function figHistsHandle = rainSTORM_traj_photophysicsHist( trajQuantitesAccepted, trajQuantitesRejected, text_figure_name, calcParamsStruct )
% 	Summary:	
%	Version:    3.2	
%	Note:		
%	Package:	rainSTORM v3.1+
%	Developer:	novakt
%	Name:		Novák Tibor
%	Company:	University of Szeged
%	Date of the merger: 2017.11.08.	

% Function for creating a set histograms about photophysics quantities.

% parents: reconTrajGraphsGUIElementsFunc
% children: rainSTORM_traj_calcHistData, rainSTORM_traj_calcImagePlotQuantity

NBins=calcParamsStruct.NBins;

%% Plot graphs
figSize = [1,100,1120,840];
figHistsHandle = figure(...
    'Name',text_figure_name,...
    'NumberTitle','off',...
    'OuterPosition', figSize, ...
    'Visible', 'off'...
    );


%% First Subplot:
set(0, 'CurrentFigure', figHistsHandle) 
%subplot(2,2,1) % Use this if screen shape spoils the method below
subplot('Position', [0.07,0.57,0.4,0.4])

% The quantity is the emitted photon number of trajectories
NPhoton_vals_accepted = double(trajQuantitesAccepted.NPhoton);
NPhoton_vals_rejected = double(trajQuantitesRejected.NPhoton);

% bin properties
if calcParamsStruct.NPhotonBounds(1)==-Inf
    binMin=0;
else
    binMin=calcParamsStruct.NPhotonBounds(1);
end
if calcParamsStruct.NPhotonBounds(2)==Inf
    binMax=max(NPhoton_vals_accepted);
else
    binMax=calcParamsStruct.NPhotonBounds(2);
end

if isempty(binMin) || isnan(binMin)     % is not meaningful
    binMin=-0.001;                      % let it be
end
if isempty(binMax) || isnan(binMax)     % is not meaningful
    binMax=binMin+0.001;                % let it be
end
if binMin==binMax                       % they can not be equal
   binMin=binMin*0.999;                 % let it be
   binMax=binMax*1.001;                 % let it be
end

% create histogram
histIntegersBool=false;
[myNGood, binEdges]=rainSTORM_traj_calcHistData(NPhoton_vals_accepted, histIntegersBool, binMin, binMax, NBins);
%[myNBad,~] = rainSTORM_traj_calcHistData(NPhoton_vals_rejected, histIntegersBool, binMin, binMax, NBins);

hold on
histogram('BinEdges', binEdges, 'BinCounts', myNGood);
hold off

plotParamsStruct.quantityType='photon number';
plotParamsStruct.mapType='exponential histogram';
plotParamsStruct.thresPixValN=2;
quantData=rainSTORM_traj_calcImagePlotQuantity( NPhoton_vals_accepted, 'hist', plotParamsStruct, calcParamsStruct );

quantMean=quantData.mean;
quantMeanForExpLifeTime=quantData.meanForExpLifeTime;
quantExpectedLifeTime=quantData.expectedLifeTime;
quantFitResiduum=quantData.fitResiduum;

labelXPos=[0.55, 0.55, 0.55, 0.55];
labelYPos=[0.95, 0.9, 0.85, 0.8];
labelText={['mean: ', sprintf('%.4g', quantMean)],...
    ['exp. dist. mean: ', sprintf('%.4g', quantMeanForExpLifeTime)],...
    ['exp. lifetime: ', sprintf('%.4g', quantExpectedLifeTime)],...
    ['fit residuum: ', sprintf('%.4g', quantFitResiduum)]};
text( labelXPos, labelYPos, labelText, 'Units', 'normalized')

set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Photon number');
xlabel('N phtoton')
ylabel('Number of Candidates');


%% Second subplot:
set(0, 'CurrentFigure', figHistsHandle) 
%subplot(2,2,2)
subplot('Position', [0.57,0.57,0.4,0.4])

% The quantity is the frame duration of trajectories
frameN_vals_accepted = double(trajQuantitesAccepted.frame_N);
frameN_vals_rejected = double(trajQuantitesRejected.frame_N);

% bin properties
if calcParamsStruct.frameDurationBounds(1)==-Inf
    % the displacement is becuse of the "'BinMethod', 'integers'" option in
    % the "histogram" function
    binMin=1-0.5;
else
    binMin=calcParamsStruct.frameDurationBounds(1)-0.5;
end
if calcParamsStruct.frameDurationBounds(2)==Inf
    % the displacement is becuse of the "'BinMethod', 'integers'" option in
    % the "histogram" function
    binMax=max(frameN_vals_accepted)+0.5;
else
    binMax=calcParamsStruct.frameDurationBounds(2)+0.5;
end

if isempty(binMin) || isnan(binMin)     % is not meaningful
    binMin=-0.001;
end
if isempty(binMax) || isnan(binMax)     % is not meaningful
    binMax=binMin+0.001;
end
if binMin==binMax                       % they can not be equal
   binMin=binMin*0.999;                 % let it be
   binMax=binMax*1.001;                 % let it be
end

% create histogram
histIntegersBool=true;
[myNGood, binEdges]=rainSTORM_traj_calcHistData(frameN_vals_accepted, histIntegersBool, binMin, binMax);
%[myNBad,~] = rainSTORM_traj_calcHistData(frameN_vals_rejected, histIntegersBool, binMin, binMax);

hold on
histogram('BinCounts', myNGood, 'BinEdges', binEdges);
hold off

plotParamsStruct.quantityType='frame duration';
plotParamsStruct.mapType='exponential histogram';
plotParamsStruct.thresPixValN=2;
quantData=rainSTORM_traj_calcImagePlotQuantity( frameN_vals_accepted, 'hist', plotParamsStruct, calcParamsStruct );

quantMean=quantData.mean;
quantMeanForExpLifeTime=quantData.meanForExpLifeTime;
quantExpectedLifeTime=quantData.expectedLifeTime;
quantFitResiduum=quantData.fitResiduum;

set(0, 'CurrentFigure', figHistsHandle)
if isfield(quantData, 'multiExp')
    labelXPos=[0.55, 0.55, 0.55, 0.55, 0.55];
    labelYPos=[0.95, 0.9, 0.85, 0.8, 0.75];
    
    expDecay1=quantData.multiExp.lifetime1;
    expDecay2=quantData.multiExp.lifetime2;
    expWeight=quantData.multiExp.weight;
    labelText={['mean: ', sprintf('%.4g', quantMean)],...
        ['exp. dist. mean: ', sprintf('%.4g', quantMeanForExpLifeTime)],...
        ['exp. lifetime: ', sprintf('%.4g', quantExpectedLifeTime)],...
        ['multi exp.: ', sprintf('%.4g/%.4g/%.4g', expDecay1, expDecay2, expWeight)],...
        ['fit residuum: ', sprintf('%.4g', quantFitResiduum)]};
    text( labelXPos, labelYPos, labelText, 'Units', 'normalized')
else
    labelXPos=[0.55, 0.55, 0.55, 0.55];
    labelYPos=[0.95, 0.9, 0.85, 0.8];
    
    labelText={['mean: ', sprintf('%.4g', quantMean)],...
        ['exp. dist. mean: ', sprintf('%.4g', quantMeanForExpLifeTime)],...
        ['exp. lifetime: ', sprintf('%.4g', quantExpectedLifeTime)],...
        ['fit residuum: ', sprintf('%.4g', quantFitResiduum)]};
    text( labelXPos, labelYPos, labelText, 'Units', 'normalized')
end
set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Frame duration');
xlabel('Frame N')
ylabel('Number of Candidates');


%% Third Plot
set(0, 'CurrentFigure', figHistsHandle) 
%subplot(2,2,3)
subplot('Position', [0.07,0.07,0.4,0.4])

% The quantity is the emission power of blinking events in the
% trajectories that are long enough
emPower_vals_accepted = double(trajQuantitesAccepted.emPower);
emPower_vals_rejected = double(trajQuantitesRejected.emPower);

% bin properties
if calcParamsStruct.emPowerBounds(1)==-Inf
    binMin=0;
else
    binMin=calcParamsStruct.emPowerBounds(1);
end
if calcParamsStruct.emPowerBounds(2)==Inf
    binMax=max(emPower_vals_accepted);
else
    binMax=calcParamsStruct.emPowerBounds(2);
end

if isempty(binMin) || isnan(binMin)     % is not meaningful
    binMin=-0.001;                      % let it be
end
if isempty(binMax) || isnan(binMax)     % is not meaningful
    binMax=binMin+0.001;                % let it be
end
if binMin==binMax                       % they can not be equal
   binMin=binMin*0.999;                 % let it be
   binMax=binMax*1.001;                 % let it be
end

% create histogram
histIntegersBool=false;
[myNGood, binEdges]=rainSTORM_traj_calcHistData(emPower_vals_accepted, histIntegersBool, binMin, binMax, NBins);
%[myNBad,~] = rainSTORM_traj_calcHistData(emPower_vals_rejected, histIntegersBool, binMin, binMax, NBins);

hold on
histogram('BinCounts', myNGood, 'BinEdges', binEdges);
hold off

plotParamsStruct.quantityType='emission power';
plotParamsStruct.mapType='emission power histogram';
plotParamsStruct.thresPixValN=2;
quantData=rainSTORM_traj_calcImagePlotQuantity( emPower_vals_accepted, 'hist', plotParamsStruct, calcParamsStruct );

quantMean=quantData.mean;

labelXPos=[0.55];
labelYPos=[0.95];
labelText={['mean: ', sprintf('%.4g', quantMean)]};
text( labelXPos, labelYPos, labelText, 'Units', 'normalized')

set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Emisson power');
xlabel('Em. power [photon/s]')
ylabel('Number of Candidates');


%% Fourth Figure
set(0, 'CurrentFigure', figHistsHandle) 
%subplot(2,2,4)
subplot('Position', [0.57,0.07,0.4,0.4])

% The quantity is the lifetime of trajectories that are long enough
lifeTime_vals_accepted = double(trajQuantitesAccepted.lifeTime);
lifeTime_vals_rejected = double(trajQuantitesRejected.lifeTime);

% bin properties
if calcParamsStruct.lifeTimeBounds(1)==-Inf
    binMin=2.0*calcParamsStruct.frameTime;
else
    binMin=calcParamsStruct.lifeTimeBounds(1);
end
if calcParamsStruct.lifeTimeBounds(2)==Inf
    binMax=max(lifeTime_vals_accepted);
else
    binMax=calcParamsStruct.lifeTimeBounds(2);
end

if isempty(binMin) || isnan(binMin)     % is not meaningful
    binMin=-0.001;                      % let it be
end
if isempty(binMax) || isnan(binMax)     % is not meaningful
    binMax=binMin+0.001;                % let it be
end
if binMin==binMax                       % they can not be equal
   binMin=binMin*0.999;                 % let it be
   binMax=binMax*1.001;                 % let it be
end

% create histogram
histIntegersBool=false;
[myNGood, binEdges]=rainSTORM_traj_calcHistData(lifeTime_vals_accepted, histIntegersBool, binMin, binMax, NBins);
%[myNBad,~] = rainSTORM_traj_calcHistData(lifeTime_vals_rejected, histIntegersBool, binMin, binMax, NBins);

hold on
histogram('BinCounts', myNGood, 'BinEdges', binEdges);
hold off

plotParamsStruct.quantityType='lifetime';
plotParamsStruct.mapType='exponential histogram';
plotParamsStruct.thresPixValN=2;
quantData=rainSTORM_traj_calcImagePlotQuantity( lifeTime_vals_accepted, 'hist', plotParamsStruct, calcParamsStruct );

quantMean=quantData.mean;
quantMeanForExpLifeTime=quantData.meanForExpLifeTime;
quantExpectedLifeTime=quantData.expectedLifeTime;
quantFitResiduum=quantData.fitResiduum;

set(0, 'CurrentFigure', figHistsHandle)
labelXPos=[0.55, 0.55, 0.55, 0.55];
labelYPos=[0.95, 0.9, 0.85, 0.8];
labelText={['mean: ', sprintf('%.4g', quantMean)],...
    ['exp. dist. mean: ', sprintf('%.4g', quantMeanForExpLifeTime)],...
    ['exp. lifetime: ', sprintf('%.4g', quantExpectedLifeTime)],...
    ['fit residuum: ', sprintf('%.4g', quantFitResiduum)]};
text( labelXPos, labelYPos, labelText, 'Units', 'normalized')

set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Lifetime of ON states');
xlabel('Lifetime [s]')
ylabel('Number of Candidates');

end

