function rainSTORM_traj_plotQuantity( plotParamsStruct, posits, quantity, calcParamsStruct )
% 	Summary:	
%	Version:    3.2	
%	Note:		
%	Package:	rainSTORM v3.1+
%	Developer:	novakt
%	Name:		Novák Tibor
%	Company:	University of Szeged
%	Date of the merger: 2017.11.08.	

% This function creates the scatter or image map of the chosen qantity. 

% parent: reconTrayGraphsGUIElementsFunc
% childs: rainSTORM_traj_calcImagePlotQuantity

%% Preparation
figureType=plotParamsStruct.figureType;
switch figureType
    case 'scatter'
        % size of camera pixels in um
        pixelWidth_um=plotParamsStruct.camPixelWidth/1000;
        
    case 'image'
        % number of camera pixels on the frames
        sizeOfCCDFrame=plotParamsStruct.sizeOfCCDFrame;
        % size of camera pixels in nm
        pixelWidth=plotParamsStruct.camPixelWidth/1000;
        
end

%% Creating the scatter or image map
mapFigureHAndle = figure('Visible', 'off');
switch figureType
    case 'scatter'
        
        xRotated=(posits(:,1)*cos(90/180*pi)+posits(:,2)*sin(90/180*pi))*pixelWidth_um;
        yRotated=(-posits(:,1)*sin(90/180*pi)+posits(:,2)*cos(90/180*pi))*pixelWidth_um;
        
        scatter(xRotated, yRotated, 3, quantity, 'filled');
        xlabel('X position [um]');
        ylabel('Y position [um]');
        colormap(jet);
        colorbar;
    case 'image'
        % pixelize the trajectories
        [SupResIm, nRows, nRows_mod, nCols, nCols_mod] = rainSTORM_traj_calcImagePlotQuantity( quantity, 'map', plotParamsStruct, calcParamsStruct, posits);
        
        % minimum and maximum pixel values, for the colorbar
        pixValMin=min(min(SupResIm(SupResIm~=-Inf)));      % do not count the pixels with minus infinite and NaN value
        pixValMax=max(max(SupResIm(SupResIm~=Inf)));    % do not count the pixels with infinite and NaN value
        
        % colorbar properties
        colorbarMin=pixValMin-(pixValMax-pixValMin)/4;
        colorbarMax=pixValMax;
        if colorbarMin==colorbarMax
            colorbarMin=colorbarMin-0.001;
            colorbarMax=colorbarMax+0.001;
        elseif colorbarMin>=colorbarMax
            error('Something is wrong with the pixel values.')
        end
        
        % Create the image
        h=imagesc(SupResIm);
        hold on
        caxis([colorbarMin colorbarMax]);
        colormap(hot);
        %set(h, 'AlphaData', ~isnan(SupResIm)) % makes the pixels with NaN values transperent I guess
        axis equal
        %xlim([0.5-nRows_mod*0.5 nRows+0.5+nRows_mod*0.5])   % +0.5 is needed the for proper boundaries (imagesc())
        %ylim([0.5-nCols_mod*0.5 nCols+0.5+nCols_mod*0.5])   % +0.5 is needed the for proper boundaries (imagesc())
        xlim([0.5-nCols_mod*0.5 nCols+0.5+nCols_mod*0.5])   % +0.5 is needed the for proper boundaries (imagesc())
        ylim([0.5-nRows_mod*0.5 nRows+0.5+nRows_mod*0.5])   % +0.5 is needed the for proper boundaries (imagesc())
        box on
        set(gca, 'XTick', []);
        set(gca, 'YTick', []);
        colorbar;
        hold on
        
        % Scalebar, 1000 nanometers
        plot([max(xlim)*95, max(xlim)*95-1000/pixelWidth*nCols/sizeOfCCDFrame(1)], ...
            [max(ylim)*0.95, max(ylim)*0.95],'k-', 'Color','white' ,'LineWidth',3);
end

end

