function figHistsHandle = rainSTORM_traj_qualityHist( trajectoriesAccepted, trajectoriesRejected, text_figure_name, calcParamsStruct )
% 	Summary:	
%	Version:    3.2	
%	Note:		
%	Package:	rainSTORM v3.1+
%	Developer:	novakt
%	Name:		Novák Tibor
%	Company:	University of Szeged
%	Date of the merger: 2017.11.08.	

% Function for creating a set histograms about localization quality.

% parents: reconTrajGraphsGUIElementsFunc
% children: rainSTORM_traj_calcHistData

NBins=calcParamsStruct.NBins;

%% Plot graphs
figSize = [1,100,1120,840];
figHistsHandle = figure(...
    'Name',text_figure_name,...
    'NumberTitle','off',...
    'OuterPosition', figSize,...
    'Visible', off...
    );


%% First Subplot:
%subplot(2,2,1) % Use this if screen shape spoils the method below
subplot('Position', [0.07,0.57,0.4,0.4])

% The quantity is the mean residuum of fitted Gaussians of localizations
% belonging to a trajectory 
Res_vals_accepted = double(trajectoriesAccepted.meanRes);
Res_vals_rejected = double(trajectoriesRejected.meanRes);

% bin properties
binMin=min([Res_vals_accepted; Res_vals_rejected]);
binMax=max([Res_vals_accepted; Res_vals_rejected]);

if isempty(binMin) || isnan(binMin)     % is not meaningful
    binMin=-0.001;                      % let it be
end
if isempty(binMax) || isnan(binMax)     % is not meaningful
    binMax=binMin+0.001;                % let it be
end
if binMin==binMax                       % they can not be equal
   binMin=binMin*0.999;                 % let it be
   binMax=binMax*1.001;                 % let it be
end

% create histogram
histIntegersBool=false;
[myNGood, edges]=rainSTORM_traj_calcHistData(Res_vals_accepted, histIntegersBool, binMin, binMax, NBins);
[myNBad,~] = rainSTORM_traj_calcHistData(Res_vals_rejected, histIntegersBool, binMin, binMax, NBins);

hold on
histogram('BinCounts', myNGood, 'BinEdges', edges);
hold on
histogram('BinCounts', myNBad, 'BinEdges', edges);
hold off

set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Mean residuum of fits of trajectories');
xlabel('Residuum')
ylabel('Number of Candidates');


%% Second subplot:
%subplot(2,2,2)
subplot('Position', [0.57,0.57,0.4,0.4])

% The quantity is the mean PSF width in the "x" direction of fitted
% Gaussians of localizations belonging to a trajectory 
Sig_X_accepted = double(trajectoriesAccepted.meanSigX);
Sig_X_rejected = double(trajectoriesRejected.meanSigX);

% bin properties
binMin=min([Sig_X_accepted; Sig_X_rejected]);
binMax=max([Sig_X_accepted; Sig_X_rejected]);

if isempty(binMin) || isnan(binMin)     % is not meaningful
    binMin=-0.001;
end
if isempty(binMax) || isnan(binMax)     % is not meaningful
    binMax=binMin+0.001;
end
if binMin==binMax                       % they can not be equal
   binMin=binMin*0.999;                 % let it be
   binMax=binMax*1.001;                 % let it be
end

% create histogram
histIntegersBool=false;
[myNGood, edges]=rainSTORM_traj_calcHistData(Sig_X_accepted, histIntegersBool, binMin, binMax, NBins);
[myNBad,~] = rainSTORM_traj_calcHistData(Sig_X_rejected, histIntegersBool, binMin, binMax, NBins);

hold on
histogram('BinCounts', myNGood, 'BinEdges', edges);
hold on
histogram('BinCounts', myNBad, 'BinEdges', edges);
hold off

set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Mean sigma X of trajectories');
xlabel('STD X')
ylabel('Number of Candidates');



%% Third Plot
%subplot(2,2,3)
subplot('Position', [0.07,0.07,0.4,0.4])

% The quantity is the mean PSF width in the "y" direction of fitted
% Gaussians of localizations belonging to a trajectory 
Sig_Y_accepted = double(trajectoriesAccepted.meanSigY);
Sig_Y_rejected = double(trajectoriesRejected.meanSigY);

% bin properties
binMin=min([Sig_Y_accepted; Sig_Y_rejected]);
binMax=max([Sig_Y_accepted; Sig_Y_rejected]);

if isempty(binMin) || isnan(binMin)     % is not meaningful
    binMin=-0.001;
end
if isempty(binMax) || isnan(binMax)     % is not meaningful
    binMax=binMin+0.001;
end
if binMin==binMax                       % they can not be equal
   binMin=binMin*0.999;                 % let it be
   binMax=binMax*1.001;                 % let it be
end

% create histogram
histIntegersBool=false;
[myNGood, edges]=rainSTORM_traj_calcHistData(Sig_Y_accepted, histIntegersBool, binMin, binMax, NBins);
[myNBad,~] = rainSTORM_traj_calcHistData(Sig_Y_rejected, histIntegersBool, binMin, binMax, NBins);

hold on
histogram('BinCounts', myNGood, 'BinEdges', edges);
hold on
histogram('BinCounts', myNBad, 'BinEdges', edges);
hold off

set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Mean sigma Y of trajectories');
xlabel('STD Y')
ylabel('Number of Candidates');


end

