function [myPixels]=rainSTORM_avNMS(myFrame,rad,ImageFilter)
% Copyright 2012. Refer to 00_license.txt for details.

% revision by Tibor Novák, 2021.10.16.

myFrame = double(myFrame);

switch ImageFilter
    case 'Average'
        
        % 1(a) Averaging. Create averaged image for non-max suppression:
        % These 9 matrix additions are equivalent to conv(ones(3)). Neglect edge.
        average = myFrame;
        average(1:end-1, :)=average(1:end-1, :) + myFrame(2:end,:);
        average(2:end, :)  =average(2:end, :)   + myFrame(1:end-1,:);
        average(:, 1:end-1)=average(:, 1:end-1) + myFrame(:,2:end);
        average(:, 2:end)  =average(:, 2:end)   + myFrame(:, 1:end-1);
        average(1:end-1,1:end-1) = average(1:end-1,1:end-1) + myFrame(2:end,2:end);
        average(1:end-1,2:end) = average(1:end-1,2:end) + myFrame(2:end,1:end-1);
        average(2:end,1:end-1) = average(2:end,1:end-1) + myFrame(1:end-1,2:end);
        average(2:end,2:end) = average(2:end,2:end) + myFrame(1:end-1,1:end-1);
        
        % Divide by 9 to return mean smoothed peak value
        filtered = average/9;
    case 'none'
        filtered = myFrame;
    case 'Laplacian of Gaussian'
        % NT: some description:
        % https://academic.mu.edu/phys/matthysd/web226/Lab02.htm
        
        filtered = -imfilter( myFrame, fspecial('log', 9, 1/2  ), 'replicate' );
    case 'Determinant of Hessian'
        % NT: some description:
        % https://dsp.stackexchange.com/questions/10579/how-hessian-feature-detector-works
        
        smooth = imfilter( myFrame, fspecial('gaussian', 9, 1/2  ), 'replicate' );
        Lxx = imfilter( smooth, [1 -2 1; 2 -4 2; 1 -2 1], 'replicate' );
        Lyy = imfilter( smooth, [1 -2 1; 2 -4 2; 1 -2 1]', 'replicate' );
        Lxy = imfilter( smooth, [1 0 -1; 0 0 0; -1 0 1], 'replicate' );
        filtered = Lxx.*Lyy - Lxy.^2;
    otherwise
        error( ['Unknown image filter: "' ImageFilter '"' ] );
end

% 1(b) Non-maximum suppression
% Create a logical mask with true values at local maxima. Neglect border.
myRR = rad+1:size(myFrame,1)-rad; % Range of rows within border 
myRC = rad+1:size(myFrame,2)-rad; % Range of cols within border
Gtr = false([size(filtered),8] );
Gtr(myRR,myRC,1) = filtered(myRR,myRC) >  filtered(myRR,myRC+1);
Gtr(myRR,myRC,2) = filtered(myRR,myRC) >= filtered(myRR,myRC-1);
Gtr(myRR,myRC,3) = filtered(myRR,myRC) >  filtered(myRR+1,myRC);
Gtr(myRR,myRC,4) = filtered(myRR,myRC) >= filtered(myRR-1,myRC);
Gtr(myRR,myRC,5) = filtered(myRR,myRC) >= filtered(myRR-1,myRC-1);
Gtr(myRR,myRC,6) = filtered(myRR,myRC) >= filtered(myRR-1,myRC+1);
Gtr(myRR,myRC,7) = filtered(myRR,myRC) >  filtered(myRR+1,myRC-1);
Gtr(myRR,myRC,8) = filtered(myRR,myRC) >  filtered(myRR+1,myRC+1);

mask = Gtr(:,:,1)&Gtr(:,:,2)&Gtr(:,:,3)&Gtr(:,:,4)&...
       Gtr(:,:,5)&Gtr(:,:,6)&Gtr(:,:,7)&Gtr(:,:,8);

% 1(c) Return myPixels=[rows,cols, intensities] of local maxima,
%      I suggest that we then threshold and sort these values.
[myRows,myCols] = find(mask);
idx = sub2ind(size(mask),myRows,myCols);
myIntens = filtered(idx);

myPixels = [myRows,myCols,myIntens];
end
