function SupResParams = rainSTORM_fitLocMultiGF_2D_linearBg(frameIdx, myFrame,myPixels,settings)
    SupResParams = [];
    myFrame = double( myFrame );
    myPixels = double( myPixels );
    
    rad = settings.rad;
    
    numMyPixels = size( myPixels, 1 );
    if numMyPixels <= 0; return; end
    
    connectDistance = 6;
    maxGroupSize = 5;
    groups = groupPoints( myPixels, connectDistance, maxGroupSize );
    
    for g = 1:max( groups )
        if numel( find(groups == g ) ) <= 0; continue; end
        
        groupPixels = myPixels( groups==g, : );
        
        minX = min( groupPixels(:,1) ) - rad;
        maxX = max( groupPixels(:,1) ) + rad;
        minY = min( groupPixels(:,2) ) - rad;
        maxY = max( groupPixels(:,2) ) + rad;

        groupROI = double(myFrame( minX:maxX, minY:maxY ));
        
        groupPixels(:,1) = groupPixels(:,1) + 1 - minX;
        groupPixels(:,2) = groupPixels(:,2) + 1 - minY;

        
        if size( groupPixels, 1 ) > 1
            SupResParamsGroup = multiFit2D( frameIdx, groupROI, groupPixels, settings, minX-1, minY-1 );
        else
            SupResParamsGroup = singleFit2D( frameIdx, groupROI, groupPixels, settings, minX-1, minY-1 );
        end
        
        SupResParams = [SupResParams SupResParamsGroup];
    end
end


function SupResParams = multiFit2D( frameIdx, myROI, myPixels, settings, offX, offY )
    initSig = settings.initSig;
    tol = settings.tol;
    maxIts = settings.maxIts;
    allowSig = settings.allowSig;
    allowX = settings.allowX;
    rad = settings.rad;

    [N, M] = size(myROI);
    
    myROI_min = min(myROI(:));
%    myROI_bg = mean( [myROI(:,1); myROI(:,end); myROI(1,2:end-1)'; myROI(end,2:end-1)' ] ); % Slow version
    myROI_bg = (sum(myROI(:,1))+ sum(myROI(:,end))+ sum(myROI(1,2:end-1))+sum(myROI(end,2:end-1)))/(2*N+2*M-4); % Fast version
    myROI = myROI - myROI_bg;
  
    xx = repmat( (1:N)', [1 M] );
    yy = repmat( (1:M), [N 1] );
    
    nPixels = size( myPixels, 1);
    
    % Initial params
    x0 = myPixels(:,1);
    y0 = myPixels(:,2);
    sig = initSig*ones(nPixels,1);
    Dx = zeros(nPixels,1);
    Dy = zeros(nPixels,1);
    E = zeros(nPixels,1);    
    C = myROI( myPixels(:,1) + N * (myPixels(:,2)-1) );
    
    xxSmall = repmat( (-rad:rad)', [1 2*rad+1] );      % x-positions (rows) (pixel widths) as column vector
    yySmall = repmat( (-rad:rad),  [2*rad+1 1] );      % y-positions (cols) (pixel widths) as column vector
    for i = 1:nPixels
        xxx{i} = zeros( N, M );
        yyy{i} = zeros( N, M );
        ooo{i} = zeros( N, M );
        xxx{i}( myPixels(i,1)-rad:myPixels(i,1)+rad, myPixels(i,2)-rad:myPixels(i,2)+rad ) = xxSmall;
        yyy{i}( myPixels(i,1)-rad:myPixels(i,1)+rad, myPixels(i,2)-rad:myPixels(i,2)+rad ) = yySmall;
        ooo{i}( myPixels(i,1)-rad:myPixels(i,1)+rad, myPixels(i,2)-rad:myPixels(i,2)+rad ) = 1;
    end
    
    SupResParams = [];
    
    fofX = zeros( N, M, nPixels ); 
    for i = 1:nPixels
        fofX(:,:,i) = C(i)*exp(-((xx-x0(i)).^2+(yy-y0(i)).^2)/(2*sig(i)^2));
    end
    fofXsum = sum( fofX, 3 );
    
    Beta = myROI(:) - fofXsum(:);        
    for i = 1:nPixels
        Beta = Beta - E(i)*ooo{i}(:) - Dx(i)*xxx{i}(:) - Dy(i)*yyy{i}(:);
    end
    
    for it = 1:maxIts    
        A = [ ];  % Jacobian
        for i = 1:nPixels
            D1 = fofX(:,:,i)/C(i);                                     % dC
            D2 = fofX(:,:,i).*(xx-x0(i))/sig(i)^2;                       % dx0
            D3 = fofX(:,:,i).*(yy-y0(i))/sig(i)^2;                       % dy0
            D4 = fofX(:,:,i).*((xx-x0(i)).^2+(yy-y0(i)).^2)/sig(i)^3;       % dsig
            A = [A D1(:) D2(:) D3(:) D4(:) xxx{i}(:) yyy{i}(:) ooo{i}(:)];
        end
        
        b = A'*Beta;
        a = A'*A;
        RC = rcond(a);
        if isnan( RC ) || RC < 1e-12; break; end
        dL= a\b;

        % Refresh params
        for i = nPixels:-1:1
            C(i) = C(i) + dL( 7*(i-1) + 1 );
            x0(i) = x0(i) + dL( 7*(i-1) + 2 );
            y0(i) = y0(i) + dL( 7*(i-1) + 3 );
            sig(i) = sig(i) + dL( 7*(i-1) + 4 );
            Dx(i) = Dx(i) + dL( 7*(i-1) + 5 );
            Dy(i) = Dy(i) + dL( 7*(i-1) + 6 );
            E(i) = E(i) + dL( 7*(i-1) + 7 );
            
            if C(i)<=0 || abs(x0(i)-myPixels(i,1))>allowX || abs(y0(i)-myPixels(i,2))>allowX || sig(i)<allowSig(1) || sig(i)>allowSig(2)
                C(i) = []; x0(i) = []; y0(i) = []; sig(i) = [];
                Dx(i) = []; Dy(i) = []; E(i) = []; 
                myPixels(i,:) = [];
                nPixels = nPixels - 1;
                fofX(:,:,i) = [];
            end
        end
        
        if nPixels == 0; return; end
        
        for i = 1:nPixels
            fofX(:,:,i) = C(i)*exp(-((xx-x0(i)).^2+(yy-y0(i)).^2)/(2*sig(i)^2));
        end        
        fofXsum = sum( fofX, 3 );
        
        Beta = myROI(:) - fofXsum(:);
        for i = 1:nPixels
            Beta = Beta - E(i)*ooo{i}(:) - Dx(i)*xxx{i}(:) - Dy(i)*yyy{i}(:);
        end
    end
    
%     figure; 
%     subplot(1,2,1); surf( myROI );
%     subplot(1,2,2); surf( sum( fofX, 3 ) );

    
    % Compute residues
    for i = 1:nPixels
        myROI = myROI - E(i)*ooo{i} - Dx(i)*xxx{i} - Dy(i)*yyy{i};
    end
    
    Beta = reshape( Beta, size( myROI ) );

    for i = 1:nPixels
        myRow = myPixels(i,1);
        myCol = myPixels(i,2);        
        
        betaSmall = Beta(myRow-rad:myRow+rad,myCol-rad:myCol+rad);
        fofXsmall = fofX(myRow-rad:myRow+rad,myCol-rad:myCol+rad, i );
        
        BetaRows = sum(betaSmall,1);
        BetaCols = sum(betaSmall,2);
        
        residueRows(i) = sum(BetaRows.^2)/sum( sum(fofXsmall,1).^2 );
        residueCols(i) = sum(BetaCols.^2)/sum( sum(fofXsmall,2).^2 );
        residue(i) = (residueRows(i) + residueCols(i)) / 2;
    end

    index = 0;
    for i = 1:nPixels
        if residueRows(i)>tol || residueCols(i)>tol
            continue;
        end

        index = 1+index;
        SupResParams(index).frame_idx = uint32(frameIdx);
        SupResParams(index).x_coord = single(x0(i) + offX - 0.5);
        SupResParams(index).y_coord = single(y0(i) + offY - 0.5);
        SupResParams(index).sig = single(sig(i));  % width (sigma, rows, fitted) of this Gaussian
        SupResParams(index).background = single(E(i)); % Background for each ROI
        SupResParams(index).backgroundSTD = single.empty; % standard deviation of the background signal (noise level)
        SupResParams(index).res = single(residue(i)); % Mean critical tol for fit
        SupResParams(index).sum_signal = single(2*pi*C(i)*sig(i)*sig(i)); % Sum of signal (counts) for this fit
        
%         SupResParams(index).z_coord = single(0);
%         SupResParams(index).I = single(C(i)); %fitted maximum, %I = myPixels(i,3); % Averaged magnitude of this signal
%         SupResParams(index).res_Row = single(residueRows(i));
%         SupResParams(index).res_Col = single(residueCols(i));
%         SupResParams(index).roi_min = uint16(myROI_min);
    end
end


function SupResParams = singleFit2D( frameIdx, myROI, myPixel, settings, offX, offY )
    initSig = settings.initSig;
    tol = settings.tol;
    maxIts = settings.maxIts;
    allowSig = settings.allowSig;
    allowX = settings.allowX;
    
    [N, M] = size(myROI);
    
    myROI_min = min(myROI(:));
%    myROI_bg = mean( [myROI(:,1); myROI(:,end); myROI(1,2:end-1)'; myROI(end,2:end-1)' ] ); % Slow version
    myROI_bg = (sum(myROI(:,1))+ sum(myROI(:,end))+ sum(myROI(1,2:end-1))+sum(myROI(end,2:end-1)))/(2*N+2*M-4); % Fast version
    myROI = myROI - myROI_bg;
    
    xx = repmat( (1:N)', [1 M] );
    yy = repmat( (1:M), [N 1] );
    
    % Initial params
    x0 = myPixel(:,1);
    y0 = myPixel(:,2);
    sig = initSig;
    Dx = 0;
    Dy = 0;
    E = 0;    
    C = myROI( myPixel(1) + N * (myPixel(2)-1) );
    
    SupResParams = [];
    
    fofX = C*exp(-((xx-x0).^2+(yy-y0).^2)/(2*sig^2));
    Beta = myROI(:) - fofX(:) - Dx*xx(:) - Dy*yy(:) - E;
    
    for it = 1:maxIts        
        D1 = fofX/C;                                     % dC
        D2 = fofX.*(xx-x0)/sig^2;                       % dx0
        D3 = fofX.*(yy-y0)/sig^2;                       % dy0
        D4 = fofX.*((xx-x0).^2+(yy-y0).^2)/sig^3;       % dsig
        A = [xx(:) yy(:) ones(size(xx(:))) D1(:) D2(:) D3(:) D4(:)];
        
        b = A'*Beta;
        a = A'*A;
        RC = rcond(a);
        if isnan( RC ) || RC < 1e-12; break; end
        dL= a\b;

        % Refresh params
        Dx = Dx + dL(1);
        Dy = Dy + dL(2);
        E = E + dL(3);
        C = C + dL(4);
        x0 = x0 + dL(5);
        y0 = y0 + dL(6);
        sig = sig + dL(7);
        
        fofX = C*exp(-((xx-x0).^2+(yy-y0).^2)/(2*sig^2));
        Beta = myROI(:) - fofX(:) - Dx*xx(:) - Dy*yy(:) - E;
        
        if C <= 0 || abs(x0-myPixel(1))>allowX || abs(y0-myPixel(2))>allowX || sig<allowSig(1) || sig>allowSig(2)
            return
        end
    end

    % Compute residues
    myROI = myROI - (Dx*xx + Dy*yy + E);
    
    BetaRows = sum(myROI,1)-sum(fofX,1);
    BetaCols = sum(myROI,2)-sum(fofX,2);

    residueRows = sum(BetaRows.^2)/sum( sum(myROI,1).^2 );
    residueCols = sum(BetaCols.^2)/sum( sum(myROI,2).^2 );
    residue = sum(Beta.^2)/sum(myROI(:).^2);

    if residueRows>tol || residueCols>tol
        return
    end

    SupResParams.frame_idx = uint32(frameIdx);
    SupResParams.x_coord = single(x0 + offX-0.5);
    SupResParams.y_coord = single(y0 + offY-0.5);
    SupResParams.sig = single(sig);  % width (sigma, rows, fitted) of this Gaussian
    SupResParams.background = single(E+myROI_bg); % Background for each ROI
    SupResParams.backgroundSTD = single.empty; % standard deviation of the background signal (noise level)
    SupResParams.res = single(residue); % Mean critical tol for fit
    SupResParams.sum_signal = single(2*pi*C*sig*sig); %volume under the gaussian in counts % Sum of signal (counts) for this fit
    
%     SupResParams.z_coord = single(0);
%     SupResParams.res_Row = single(residueRows);
%     SupResParams.res_Col = single(residueCols);
%     SupResParams.roi_min = uint16(myROI_min);
end


function groups = groupPoints( myPixels, maxDistance, maxGroupSize )
    numMyPixels = size( myPixels, 1 );
    
    groups = (1:numMyPixels)';
    
    mySubtraction = @(v1, v2) bsxfun(@minus, v1', v2);
    
    DX = mySubtraction( myPixels(:,1), myPixels(:,1) );
    DY = mySubtraction( myPixels(:,2), myPixels(:,2) );
    
    dists = triu( DX.^2 + DY.^2 ); % Keep only 1 entry for each point pairs.
    
    [dists, distIndices] = sort( dists(:) ); % Sort distances
    
    firstIx = 1+numel(find(dists==0)); 
    dists = dists(firstIx:end);
    distIndices = distIndices(firstIx:end);
    
    map = dists <= maxDistance^2;
    dists = dists(map);
    distIndices = distIndices(map);
    
    indices1 = repmat( (1:numMyPixels)', [1, numMyPixels] );
    indices1 = indices1(:); indices1 = indices1(distIndices);
    indices2 = repmat( (1:numMyPixels), [numMyPixels, 1] );
    indices2 = indices2(:); indices2 = indices2(distIndices);
    
    for ix = 1:length(dists)
        g1 = groups( indices1(ix) );
        g2 = groups( indices2(ix) );
        
        groupSize1 = numel(find( groups == g1 ) );
        groupSize2 = numel(find( groups == g2 ) );
        
        if groupSize1 + groupSize2 > maxGroupSize; continue; end
            
        groups( groups==g2 ) = g1;
    end
end

