function [localizationData_accepted, localizationData_rejected, metadata, sharedParameters] = rainSTORM_localize(imageStack, method, localizationSettings)

parforFlag = true;

    if parforFlag
        % Start matlabpool if there is Parallel Computing Toolbox for R2014a or
        % greater and there is no active matlabpool.
        v=ver();
        for k=1:length(v)
            if strfind(v(k).Name, 'Parallel Computing Toolbox')
                parCompTool = str2double((sprintf( v(k).Version)));
            end
        end
        if (parCompTool >= 6) && (~verLessThan('matlab','8.4.0')) && isempty(gcp('nocreate'))
            gcp;
            disp('Parallel computing has been enabled.');
        else
            disp('Could not enable parallel computing.');
            disp('rainSTORM will run in Single-Threaded mode only.');
        end
        feature('numcores');
    else
        disp('Parallel Processing Toolbox was not requested or detected.')
    end

    localizationData_accepted=rainSTORM_main(imageStack, method, localizationSettings, parforFlag);

    metadata.convention = struct();
    metadata.convention.name = 'rainSTORM';
    metadata.convention.algorithm = method;
    metadata.convention.analyses = {};

    % create empty data for the rejected localizations
    localizationData_rejected=pointillisticData_fieldManagement.createEmptyData(localizationData_accepted);

    % full ROI:
    metadata.ROI.x=[0, size(imageStack, 1)];
    metadata.ROI.y=[0, size(imageStack, 2)];
    metadata.ROI.unit='camera pixel length';

    metadata.frameRange=[1, size(imageStack, 3)];

    sharedParameters.frameRange = metadata.frameRange;
    sharedParameters.ROI = metadata.ROI;
    sharedParameters.convention = metadata.convention;
end

